jQuery(document).ready(function($) {

    const ajaxConfig = typeof seoLicense !== 'undefined' ? seoLicense : {
        ajax_url: ajaxurl,
        nonce: ''
    };

    console.log('License JS loaded', ajaxConfig);

    function validateLicenseKey(key) {
        const trimmedKey = key.trim().toUpperCase();

        const proRegex = /^SEOFURY-[A-Z0-9]{5}-[A-Z0-9]{6}-[A-Z0-9]{5}-[A-Z0-9]{5}$/;

        const freeRegex = /^FREE-[A-F0-9]{16}$/;

        return proRegex.test(trimmedKey) || freeRegex.test(trimmedKey);
    }

    $('#activate-license-btn').on('click', function(e) {
        e.preventDefault();
        console.log('Activate license clicked');

        const licenseKey = $('#license-key-input').val().trim().toUpperCase();

        if (!licenseKey) {
            showResult('#license-activation-result', 'error', seoLicense.i18n.enterLicenseKey);
            return;
        }

        if (!validateLicenseKey(licenseKey)) {
            showResult('#license-activation-result', 'error',
    seoLicense.i18n.invalidKeyFormat + '<br>PRO: SEOFURY-XXXXX-XXXXXX-XXXXX-XXXXX<br>FREE: FREE-XXXXXXXXXXXXXXXX');
            return;
        }

        const btn = $(this);
        const originalText = btn.text();
        btn.prop('disabled', true).text(seoLicense.i18n.activating);

        $.ajax({
            url: ajaxConfig.ajax_url,
            type: 'POST',
            data: {
                action: 'sf_activate_license',
                nonce: ajaxConfig.nonce,
                license_key: licenseKey
            },
            success: function(response) {
                console.log('Activation response:', response);

                if (response.success) {
                    showResult('#license-activation-result', 'success',
                        '✅ ' + seoLicense.i18n.licenseActivated);

                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    const errorMsg = response.data || seoLicense.i18n.activationFailed;
                    showResult('#license-activation-result', 'error', '❌ ' + errorMsg);
                    btn.prop('disabled', false).text(originalText);
                }
            },
            error: function(xhr, status, error) {
                console.error('Activation error:', error);
                showResult('#license-activation-result', 'error',
                    '❌ ' + seoLicense.i18n.activationServerError);
                btn.prop('disabled', false).text(originalText);
            }
        });
    });

    $('#deactivate-license-btn').on('click', function(e) {
        e.preventDefault();
        console.log('Deactivate license clicked');

        if (!confirm(seoLicense.i18n.confirmDeactivate)) {
            return;
        }

        const btn = $(this);
        const originalText = btn.text();
        btn.prop('disabled', true).text(seoLicense.i18n.deactivating);

        $.ajax({
            url: ajaxConfig.ajax_url,
            type: 'POST',
            data: {
                action: 'sf_deactivate_license',
                nonce: ajaxConfig.nonce
            },
            success: function(response) {
                console.log('Deactivation response:', response);

                if (response.success) {
                    showResult('#license-check-result', 'success',
                        '✅ ' + seoLicense.i18n.licenseDeactivated);

                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    showResult('#license-check-result', 'error',
                        '❌ ' + seoLicense.i18n.deactivationFailed);
                    btn.prop('disabled', false).text(originalText);
                }
            },
            error: function(xhr, status, error) {
                console.error('Deactivation error:', error);
                showResult('#license-check-result', 'error',
                    '❌ ' + seoLicense.i18n.serverError);
                btn.prop('disabled', false).text(originalText);
            }
        });
    });

    $('#check-license-btn').on('click', function(e) {
        e.preventDefault();
        console.log('Check license clicked');

        const btn = $(this);
        const originalText = btn.text();
        btn.prop('disabled', true).text(seoLicense.i18n.checking);

        $.ajax({
            url: ajaxConfig.ajax_url,
            type: 'POST',
            data: {
                action: 'sf_check_license',
                nonce: ajaxConfig.nonce
            },
            success: function(response) {
                console.log('Check response:', response);
                console.log('response.data:', response.data);
                console.log('is_active:', response.data?.is_active);

                if (response.success && response.data && response.data.is_active) {
                    const plan = response.data.plan || 'unknown';
                    const status = response.data.status || {};

                    let message = '✅ ' + seoLicense.i18n.licenseActiveValid + '<br>';
                    message += '<strong>' + seoLicense.i18n.plan + '</strong> ' + plan.toUpperCase() + '<br>';

                    if (status.status) {
                        message += '<strong>' + seoLicense.i18n.status + '</strong> ' + status.status.toUpperCase() + '<br>';
                    }

                    if (status.expiresAt) {
                        const expDate = new Date(status.expiresAt);
                        message += '<strong>' + seoLicense.i18n.expires + '</strong> ' + expDate.toLocaleDateString('en-US');
                    }

                    showResult('#license-check-result', 'success', message);
                } else {
                    let errorMsg = '❌ ' + seoLicense.i18n.licenseInactive;

                    if (response.data) {
                        errorMsg += '<br><small>Status: ' + (response.data.is_active ? 'active' : 'inactive') + '</small>';
                        errorMsg += '<br><small>Plan: ' + (response.data.plan || 'unknown') + '</small>';
                    }

                    console.warn('License check failed:', response.data);
                    showResult('#license-check-result', 'error', errorMsg);
                }
            },
            error: function(xhr, status, error) {
                console.error('Check error:', error);
                showResult('#license-check-result', 'error',
                    '⚠️ ' + seoLicense.i18n.couldNotReach);
            },
            complete: function() {
                btn.prop('disabled', false).text(originalText);
            }
        });
    });

    $('#license-key-input').on('input', function() {
        let value = $(this).val().toUpperCase().replace(/[^A-Z0-9-]/g, '');
        $(this).val(value);
    });

    $('#license-key-input').on('keypress', function(e) {
        if (e.which === 13) {
            e.preventDefault();
            $('#activate-license-btn').click();
        }
    });

    function showResult(selector, type, message) {
        const $result = $(selector);

        $result.removeClass('success error warning')
               .addClass(type)
               .html(message)
               .slideDown();

        if (type === 'error' || type === 'warning') {
            setTimeout(function() {
                $result.slideUp();
            }, 10000);
        }
    }

    $(document).on('click', '.license-active code', function() {
        const text = $(this).text();

        const $temp = $('<textarea>');
        $('body').append($temp);
        $temp.val(text).select();
        document.execCommand('copy');
        $temp.remove();

        const $notification = $('<div>')
            .css({
                position: 'fixed',
                top: '50%',
                left: '50%',
                transform: 'translate(-50%, -50%)',
                background: '#00a32a',
                color: 'white',
                padding: '15px 30px',
                borderRadius: '4px',
                zIndex: 999999,
                fontSize: '14px',
                fontWeight: '600',
                boxShadow: '0 4px 12px rgba(0,0,0,0.3)'
            })
            .text('✅ ' + seoLicense.i18n.keyCopied)
            .appendTo('body');

        setTimeout(function() {
            $notification.fadeOut(function() {
                $(this).remove();
            });
        }, 2000);
    });

    $(document).on('mouseenter', '.license-active code', function() {
        $(this).attr('title', seoLicense.i18n.clickToCopy);
        $(this).css('cursor', 'pointer');
    });

});
