(function (wp) {
    var editor = wp && (wp.editor || wp.editPost);
    if (!wp || !wp.plugins || !editor || !wp.element || !wp.components) {
        return;
    }

    var registerPlugin = wp.plugins.registerPlugin;
    var PluginSidebar = editor.PluginSidebar;
    var PluginSidebarMoreMenuItem = editor.PluginSidebarMoreMenuItem;
    var el = wp.element.createElement;
    var Fragment = wp.element.Fragment;

    var brandName = (window.seoFuryGutenberg && window.seoFuryGutenberg.brandName) ? window.seoFuryGutenberg.brandName : 'SEO Fury';

    function SeoFurySidebar() {
        return el(
            PluginSidebar,
            { name: 'seo-fury-sidebar', title: brandName, icon: 'search' },
            el(
                'div',
                { className: 'seo-fury-sidebar' },
                el('div', { id: 'seo-fury-sidebar-container' })
            )
        );
    }

    var originalParent = null;
    var originalNextSibling = null;

    function rememberOriginalPlacement(metabox) {
        if (!originalParent) {
            originalParent = metabox.parentNode;
            originalNextSibling = metabox.nextSibling;
        }
    }

    /**
     * Hide the bottom metabox area in Gutenberg.
     * The metabox still needs to exist in the DOM for form submission,
     * but it should not be visible at the bottom of the editor.
     */
    function hideBottomMetabox() {
        var metabox = document.getElementById('my_seo_post_meta');
        if (!metabox) return;
        // Hide the postbox wrapper in the metaboxes area
        var postboxWrapper = metabox.closest('.postbox');
        if (postboxWrapper && postboxWrapper.parentNode) {
            // Check if it's in the bottom metaboxes area (not in sidebar)
            var isInMetaboxArea = postboxWrapper.closest('.edit-post-layout__metaboxes') ||
                                  postboxWrapper.closest('#normal-sortables') ||
                                  postboxWrapper.closest('#advanced-sortables');
            if (isInMetaboxArea) {
                postboxWrapper.style.display = 'none';
            }
        }
    }

    function moveMetaboxBack() {
        var metabox = document.getElementById('my_seo_post_meta');
        if (!metabox || !originalParent) {
            return;
        }
        if (metabox.parentNode === originalParent) {
            return;
        }
        // Temporarily show the bottom metabox for form data submission
        var postboxWrapper = originalParent.closest('.postbox');
        if (postboxWrapper) {
            postboxWrapper.style.display = '';
        }

        if (originalNextSibling && originalNextSibling.parentNode === originalParent) {
            originalParent.insertBefore(metabox, originalNextSibling);
        } else {
            originalParent.appendChild(metabox);
        }
        metabox.dataset.seoFuryMoved = '0';
        document.body.classList.remove('seo-fury-metabox-in-sidebar');
    }

    function moveMetaboxIntoSidebar() {
        var container = document.getElementById('seo-fury-sidebar-container');
        var metabox = document.getElementById('my_seo_post_meta');
        if (!container || !metabox) {
            return false;
        }
        if (metabox.dataset.seoFuryMoved === '1') {
            return true;
        }

        rememberOriginalPlacement(metabox);

        // Hide the bottom metabox wrapper before moving
        hideBottomMetabox();

        metabox.dataset.seoFuryMoved = '1';
        container.appendChild(metabox);
        document.body.classList.add('seo-fury-metabox-in-sidebar');
        return true;
    }

    function scheduleMetaboxMove() {
        var attempts = 0;
        var maxAttempts = 30;
        var interval = setInterval(function () {
            attempts += 1;
            if (moveMetaboxIntoSidebar() || attempts >= maxAttempts) {
                clearInterval(interval);
                // Even if move failed, still hide bottom metabox in Gutenberg
                if (attempts >= maxAttempts) {
                    hideBottomMetabox();
                }
            }
        }, 400);
    }

    registerPlugin('seo-fury-sidebar', {
        render: function () {
            return el(
                Fragment,
                null,
                el(
                    PluginSidebarMoreMenuItem,
                    { target: 'seo-fury-sidebar', icon: 'search' },
                    brandName
                ),
                el(SeoFurySidebar)
            );
        }
    });

    function hookSaveEvents() {
        document.addEventListener('submit', function (event) {
            if (event.target && event.target.id === 'post') {
                moveMetaboxBack();
            }
        }, true);

        if (wp.data && wp.data.subscribe && wp.data.select) {
            var isSaving = false;
            wp.data.subscribe(function () {
                var editorStore = wp.data.select('core/editor');
                if (!editorStore || !editorStore.isSavingPost) {
                    return;
                }
                var saving = editorStore.isSavingPost();
                if (saving && !isSaving) {
                    isSaving = true;
                    moveMetaboxBack();
                }
                if (!saving && isSaving) {
                    isSaving = false;
                    scheduleMetaboxMove();
                }
            });
        }
    }

    // Immediately add class to body for CSS-based hiding (before JS executes)
    document.body.classList.add('seo-fury-gutenberg-active');

    if (wp.domReady) {
        wp.domReady(function () {
            scheduleMetaboxMove();
            hookSaveEvents();
        });
    } else {
        document.addEventListener('DOMContentLoaded', function () {
            scheduleMetaboxMove();
            hookSaveEvents();
        });
    }
})(window.wp);
