<?php

if (!defined('ABSPATH')) {
    exit;
}

class My_SEO_Plugin_Breadcrumbs {
    public function __construct() {
        add_shortcode('seo_fury_breadcrumbs', array($this, 'render_shortcode'));
    }

    public function register_settings() {
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_enabled');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_show_home');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_home_label');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_home_url');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_prefix');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_separator');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_separator_custom');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_archive_format');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_search_format');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_404_label');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_hide_post_title');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_show_categories');
        register_setting('my_seo_breadcrumbs_group', 'my_seo_breadcrumbs_hide_taxonomy');

        add_settings_section(
            'my_seo_breadcrumbs_section',
            __('Breadcrumbs', 'seo-fury'),
            array($this, 'breadcrumbs_section_callback'),
            'my_seo_breadcrumbs_group'
        );

        add_settings_field(
            'my_seo_breadcrumbs_enabled',
            __('Enable Breadcrumbs', 'seo-fury'),
            array($this, 'breadcrumbs_enabled_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_show_home',
            __('Show Home Link', 'seo-fury'),
            array($this, 'breadcrumbs_show_home_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_home_label',
            __('Home Label', 'seo-fury'),
            array($this, 'breadcrumbs_home_label_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_home_url',
            __('Home URL', 'seo-fury'),
            array($this, 'breadcrumbs_home_url_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_prefix',
            __('Breadcrumb Prefix', 'seo-fury'),
            array($this, 'breadcrumbs_prefix_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_separator',
            __('Separator', 'seo-fury'),
            array($this, 'breadcrumbs_separator_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_archive_format',
            __('Archive Format', 'seo-fury'),
            array($this, 'breadcrumbs_archive_format_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_search_format',
            __('Search Format', 'seo-fury'),
            array($this, 'breadcrumbs_search_format_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_404_label',
            __('404 Label', 'seo-fury'),
            array($this, 'breadcrumbs_404_label_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_hide_post_title',
            __('Hide Post Title', 'seo-fury'),
            array($this, 'breadcrumbs_hide_post_title_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_show_categories',
            __('Show Categories', 'seo-fury'),
            array($this, 'breadcrumbs_show_categories_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );

        add_settings_field(
            'my_seo_breadcrumbs_hide_taxonomy',
            __('Hide Taxonomy Name', 'seo-fury'),
            array($this, 'breadcrumbs_hide_taxonomy_callback'),
            'my_seo_breadcrumbs_group',
            'my_seo_breadcrumbs_section'
        );
    }

    public function render_settings_page() {
        ?>
        <form method="post" action="options.php">
            <?php
            settings_fields('my_seo_breadcrumbs_group');
            do_settings_sections('my_seo_breadcrumbs_group');
            submit_button();
            ?>
        </form>
        <div class="seo-card">
            <h3><?php esc_html_e('How to display breadcrumbs', 'seo-fury'); ?></h3>
            <p><?php esc_html_e('Use this PHP snippet in your theme template:', 'seo-fury'); ?></p>
            <pre><code>&lt;?php if (function_exists('seo_fury_breadcrumbs')) { seo_fury_breadcrumbs(); } ?&gt;</code></pre>
            <p><?php esc_html_e('Or use shortcode:', 'seo-fury'); ?></p>
            <pre><code>[seo_fury_breadcrumbs]</code></pre>
        </div>
        <?php
    }

    public function breadcrumbs_section_callback() {
        echo '<p>' . esc_html__('Enable and configure breadcrumbs for your site.', 'seo-fury') . '</p>';
    }

    public function breadcrumbs_enabled_callback() {
        $enabled = get_option('my_seo_breadcrumbs_enabled', 1);
        ?>
        <label>
            <input type="checkbox" name="my_seo_breadcrumbs_enabled" value="1" <?php checked($enabled, 1); ?>>
            <?php esc_html_e('Show breadcrumbs output', 'seo-fury'); ?>
        </label>
        <?php
    }

    public function breadcrumbs_show_home_callback() {
        $show_home = get_option('my_seo_breadcrumbs_show_home', 1);
        ?>
        <label>
            <input type="checkbox" name="my_seo_breadcrumbs_show_home" value="1" <?php checked($show_home, 1); ?>>
            <?php esc_html_e('Show link to the homepage', 'seo-fury'); ?>
        </label>
        <?php
    }

    public function breadcrumbs_home_label_callback() {
        $label = get_option('my_seo_breadcrumbs_home_label', __('Home', 'seo-fury'));
        ?>
        <input type="text" name="my_seo_breadcrumbs_home_label" value="<?php echo esc_attr($label); ?>" class="regular-text" />
        <p class="description"><?php esc_html_e('The label used for the homepage link (the first item) in breadcrumb trails.', 'seo-fury'); ?></p>
        <?php
    }

    public function breadcrumbs_home_url_callback() {
        $home_url = get_option('my_seo_breadcrumbs_home_url', '');
        ?>
        <input type="text" name="my_seo_breadcrumbs_home_url" value="<?php echo esc_attr($home_url); ?>" class="regular-text" placeholder="<?php echo esc_attr(home_url('/')); ?>" />
        <p class="description"><?php esc_html_e('The homepage link (the first item) in breadcrumb trails. Leave empty to use the default homepage URL.', 'seo-fury'); ?></p>
        <?php
    }

    public function breadcrumbs_prefix_callback() {
        $prefix = get_option('my_seo_breadcrumbs_prefix', '');
        ?>
        <input type="text" name="my_seo_breadcrumbs_prefix" value="<?php echo esc_attr($prefix); ?>" class="regular-text" />
        <p class="description"><?php esc_html_e('An element displayed before the breadcrumb trail.', 'seo-fury'); ?></p>
        <?php
    }

    public function breadcrumbs_separator_callback() {
        $separator = get_option('my_seo_breadcrumbs_separator', '›');
        $custom_separator = get_option('my_seo_breadcrumbs_separator_custom', '');
        $predefined = array('›', '-', '–', '—', '»', '|', '•');
        ?>
        <select name="my_seo_breadcrumbs_separator" id="breadcrumbs_separator">
            <?php foreach ($predefined as $sep): ?>
                <option value="<?php echo esc_attr($sep); ?>" <?php selected($separator, $sep); ?>><?php echo esc_html($sep); ?></option>
            <?php endforeach; ?>
            <option value="custom" <?php selected($separator, 'custom'); ?>><?php esc_html_e('Custom', 'seo-fury'); ?></option>
        </select>
        <input type="text" name="my_seo_breadcrumbs_separator_custom" id="breadcrumbs_separator_custom" value="<?php echo esc_attr($custom_separator); ?>" style="width: 150px; margin-left: 10px; <?php echo ($separator === 'custom') ? '' : 'display:none;'; ?>" placeholder="<?php echo esc_attr__('Enter custom separator', 'seo-fury'); ?>" />
        <script>
        jQuery(document).ready(function($) {
            $('#breadcrumbs_separator').on('change', function() {
                if ($(this).val() === 'custom') {
                    $('#breadcrumbs_separator_custom').show();
                } else {
                    $('#breadcrumbs_separator_custom').hide();
                }
            });
        });
        </script>
        <?php
    }

    public function breadcrumbs_archive_format_callback() {
        $format = get_option('my_seo_breadcrumbs_archive_format', __('Archives for %s', 'seo-fury'));
        ?>
        <input type="text" name="my_seo_breadcrumbs_archive_format" value="<?php echo esc_attr($format); ?>" class="regular-text" />
        <p class="description"><?php esc_html_e('A template that defines what text appears at the beginning of the breadcrumb trail when the user is on an archive page (e.g. category, tag, or author page). Use %s as a placeholder for the archive name.', 'seo-fury'); ?></p>
        <?php
    }

    public function breadcrumbs_search_format_callback() {
        $format = get_option('my_seo_breadcrumbs_search_format', __('Search results for "%s"', 'seo-fury'));
        ?>
        <input type="text" name="my_seo_breadcrumbs_search_format" value="<?php echo esc_attr($format); ?>" class="regular-text" />
        <p class="description"><?php esc_html_e('Format the label used for search results pages. Use %s as a placeholder for the search query.', 'seo-fury'); ?></p>
        <?php
    }

    public function breadcrumbs_404_label_callback() {
        $label = get_option('my_seo_breadcrumbs_404_label', __('Page not found', 'seo-fury'));
        ?>
        <input type="text" name="my_seo_breadcrumbs_404_label" value="<?php echo esc_attr($label); ?>" class="regular-text" />
        <p class="description"><?php esc_html_e('The label used for the 404 error page in breadcrumb trails.', 'seo-fury'); ?></p>
        <?php
    }

    public function breadcrumbs_hide_post_title_callback() {
        $hide_post_title = get_option('my_seo_breadcrumbs_hide_post_title', 0);
        ?>
        <label>
            <input type="checkbox" name="my_seo_breadcrumbs_hide_post_title" value="1" <?php checked($hide_post_title, 1); ?>>
            <?php esc_html_e('Hide the post title in the breadcrumb trail', 'seo-fury'); ?>
        </label>
        <?php
    }

    public function breadcrumbs_show_categories_callback() {
        $show_categories = get_option('my_seo_breadcrumbs_show_categories', 1);
        ?>
        <label>
            <input type="checkbox" name="my_seo_breadcrumbs_show_categories" value="1" <?php checked($show_categories, 1); ?>>
            <?php esc_html_e('If a category is a child, display all parent categories', 'seo-fury'); ?>
        </label>
        <?php
    }

    public function breadcrumbs_hide_taxonomy_callback() {
        $hide_taxonomy = get_option('my_seo_breadcrumbs_hide_taxonomy', 0);
        ?>
        <label>
            <input type="checkbox" name="my_seo_breadcrumbs_hide_taxonomy" value="1" <?php checked($hide_taxonomy, 1); ?>>
            <?php esc_html_e('Hide the taxonomy name in the breadcrumb trail', 'seo-fury'); ?>
        </label>
        <?php
    }

    public function render_shortcode() {
        return $this->get_breadcrumbs_html();
    }

    public function get_breadcrumbs_html() {
        $enabled = get_option('my_seo_breadcrumbs_enabled', 1);
        if (!$enabled) {
            return '';
        }

        $separator = get_option('my_seo_breadcrumbs_separator', '›');
        if ($separator === 'custom') {
            $separator = get_option('my_seo_breadcrumbs_separator_custom', '›');
        }

        $show_home = get_option('my_seo_breadcrumbs_show_home', 1);
        $home_label = get_option('my_seo_breadcrumbs_home_label', __('Home', 'seo-fury'));
        $home_url = get_option('my_seo_breadcrumbs_home_url', '');
        $prefix = get_option('my_seo_breadcrumbs_prefix', '');
        $archive_format = get_option('my_seo_breadcrumbs_archive_format', __('Archives for %s', 'seo-fury'));
        $search_format = get_option('my_seo_breadcrumbs_search_format', __('Search results for "%s"', 'seo-fury'));
        $label_404 = get_option('my_seo_breadcrumbs_404_label', __('Page not found', 'seo-fury'));
        $hide_post_title = get_option('my_seo_breadcrumbs_hide_post_title', 0);
        $show_categories = get_option('my_seo_breadcrumbs_show_categories', 1);
        $hide_taxonomy = get_option('my_seo_breadcrumbs_hide_taxonomy', 0);

        $home_link = !empty($home_url) ? $home_url : home_url('/');

        $items = array();

        if ($show_home) {
            $items[] = array('label' => $home_label, 'url' => $home_link);
        }

        if (is_singular()) {
            global $post;
            if (is_page()) {
                $ancestors = array_reverse(get_post_ancestors($post));
                foreach ($ancestors as $ancestor_id) {
                    $items[] = array(
                        'label' => get_the_title($ancestor_id),
                        'url' => get_permalink($ancestor_id)
                    );
                }
            } elseif (is_single()) {
                if ($show_categories) {
                    $categories = get_the_category($post->ID);
                    if (!empty($categories)) {
                        $primary = $categories[0];
                        $cat_ancestors = array_reverse(get_ancestors($primary->term_id, 'category'));
                        foreach ($cat_ancestors as $cat_id) {
                            $items[] = array(
                                'label' => get_cat_name($cat_id),
                                'url' => get_category_link($cat_id)
                            );
                        }
                        $items[] = array(
                            'label' => $primary->name,
                            'url' => get_category_link($primary->term_id)
                        );
                    }
                }
            }

            if (!$hide_post_title) {
                $items[] = array('label' => get_the_title($post), 'url' => '');
            }
        } elseif (is_archive()) {
            if (is_category()) {
                $current_cat = get_queried_object();
                if ($current_cat && $show_categories && $current_cat->parent) {
                    $cat_ancestors = array_reverse(get_ancestors($current_cat->term_id, 'category'));
                    foreach ($cat_ancestors as $cat_id) {
                        $items[] = array(
                            'label' => get_cat_name($cat_id),
                            'url' => get_category_link($cat_id)
                        );
                    }
                }
                $archive_name = $current_cat ? $current_cat->name : '';
                if ($archive_format && strpos($archive_format, '%s') !== false) {
                    $label = sprintf($archive_format, $archive_name);
                } else {
                    $label = $archive_name;
                }
                $items[] = array('label' => $label, 'url' => '');
            } elseif (is_tag() || is_tax()) {
                $term = get_queried_object();
                $archive_name = $term ? $term->name : '';
                if ($archive_format && strpos($archive_format, '%s') !== false) {
                    $label = sprintf($archive_format, $archive_name);
                } else {
                    $label = $archive_name;
                }
                $items[] = array('label' => $label, 'url' => '');
            } else {
                $archive_title = get_the_archive_title();
                $archive_title = wp_strip_all_tags($archive_title);
                if ($hide_taxonomy) {
                    $archive_title = preg_replace('/^[^:]+:\s*/', '', $archive_title);
                }
                if ($archive_format && strpos($archive_format, '%s') !== false) {
                    $archive_title = sprintf($archive_format, $archive_title);
                }
                $items[] = array('label' => $archive_title, 'url' => '');
            }
        } elseif (is_search()) {
            $search_query = get_search_query();
            $search_label = sprintf($search_format, $search_query);
            $items[] = array('label' => $search_label, 'url' => '');
        } elseif (is_404()) {
            $items[] = array('label' => $label_404, 'url' => '');
        }

        $parts = array();
        foreach ($items as $item) {
            if (!empty($item['url'])) {
                $parts[] = '<a href="' . esc_url($item['url']) . '">' . esc_html($item['label']) . '</a>';
            } else {
                $parts[] = '<span>' . esc_html($item['label']) . '</span>';
            }
        }

        $output = '';
        if (!empty($prefix)) {
            $output .= '<span class="breadcrumb-prefix">' . esc_html($prefix) . ' </span>';
        }

        $output .= implode(' <span class="separator">' . esc_html($separator) . '</span> ', $parts);

        return '<nav class="seo-fury-breadcrumbs">' . $output . '</nav>';
    }
}

function seo_fury_breadcrumbs() {
    if (!class_exists('SEO_Fury_Core')) {
        return;
    }
    $core = SEO_Fury_Core::get_instance();
    $breadcrumbs = method_exists($core, 'get_breadcrumbs') ? $core->get_breadcrumbs() : null;
    if ($breadcrumbs) {
        echo $breadcrumbs->get_breadcrumbs_html();
    }
}
