<?php

if (!defined('ABSPATH')) {
    exit;
}

class My_SEO_Plugin_Fingerprint {

    public function generate_site_hash() {
        global $wpdb;

        $components = array(
            'domain' => $this->get_clean_domain(),
            'db_prefix' => $wpdb->prefix,
            'auth_salt' => $this->get_auth_salt(),
        );

        $hash = hash('sha256', json_encode($components));

        error_log('FINGERPRINT: Generated hash for ' . $components['domain']);

        return $hash;
    }

    private function get_clean_domain() {
        $url = home_url();
        $parsed = parse_url($url);
        $domain = $parsed['host'] ?? 'localhost';

        $domain = preg_replace('/^www\./', '', $domain);

        return strtolower($domain);
    }

    private function get_auth_salt() {
        if (defined('AUTH_KEY')) {
            return substr(AUTH_KEY, 0, 32);
        }

        return 'fallback_' . $this->get_clean_domain();
    }

    public function verify_fingerprint($stored_hash) {
        $current_hash = $this->generate_site_hash();

        if ($current_hash !== $stored_hash) {
            error_log('FINGERPRINT: Mismatch! Current: ' . $current_hash . ' vs Stored: ' . $stored_hash);
            return false;
        }

        error_log('FINGERPRINT: Match OK');
        return true;
    }

    public function get_site_info() {
        global $wpdb;

        return array(
            'domain' => $this->get_clean_domain(),
            'siteUrl' => site_url(),
            'homeUrl' => home_url(),
            'dbPrefix' => $wpdb->prefix,
            'phpVersion' => PHP_VERSION,
            'wpVersion' => get_bloginfo('version'),
            'siteHash' => $this->generate_site_hash()
        );
    }
}
