<?php

if (!defined('ABSPATH')) {
    exit;
}

class My_SEO_Plugin_Local_SEO {
    public function __construct() {
        add_action('wp_head', array($this, 'output_schema'), 1);
    }

    public function register_settings() {
        register_setting('my_seo_local_group', 'my_seo_local_enabled');
        register_setting('my_seo_local_group', 'my_seo_local_type');
        register_setting('my_seo_local_group', 'my_seo_local_name');
        register_setting('my_seo_local_group', 'my_seo_local_phone');
        register_setting('my_seo_local_group', 'my_seo_local_email');
        register_setting('my_seo_local_group', 'my_seo_local_url');
        register_setting('my_seo_local_group', 'my_seo_local_logo');
        register_setting('my_seo_local_group', 'my_seo_local_image');
        register_setting('my_seo_local_group', 'my_seo_local_price_range');
        register_setting('my_seo_local_group', 'my_seo_local_street');
        register_setting('my_seo_local_group', 'my_seo_local_city');
        register_setting('my_seo_local_group', 'my_seo_local_region');
        register_setting('my_seo_local_group', 'my_seo_local_postal');
        register_setting('my_seo_local_group', 'my_seo_local_country');
        register_setting('my_seo_local_group', 'my_seo_local_lat');
        register_setting('my_seo_local_group', 'my_seo_local_lng');
        register_setting('my_seo_local_group', 'my_seo_local_opening_hours');

        add_settings_section(
            'my_seo_local_section',
            __('Local SEO', 'seo-fury'),
            array($this, 'local_section_callback'),
            'my_seo_local_group'
        );

        add_settings_field('my_seo_local_enabled', __('Enable Local SEO', 'seo-fury'), array($this, 'field_enabled'), 'my_seo_local_group', 'my_seo_local_section');
        add_settings_field('my_seo_local_type', __('Business Type', 'seo-fury'), array($this, 'field_type'), 'my_seo_local_group', 'my_seo_local_section');
        add_settings_field('my_seo_local_name', __('Business Name', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_name'));
        add_settings_field('my_seo_local_phone', __('Phone', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_phone'));
        add_settings_field('my_seo_local_email', __('Email', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_email'));
        add_settings_field('my_seo_local_url', __('URL', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_url'));
        add_settings_field('my_seo_local_logo', __('Logo URL', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_logo'));
        add_settings_field('my_seo_local_image', __('Image URL', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_image'));
        add_settings_field('my_seo_local_price_range', __('Price Range', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_price_range'));

        add_settings_field('my_seo_local_street', __('Street Address', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_street'));
        add_settings_field('my_seo_local_city', __('City', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_city'));
        add_settings_field('my_seo_local_region', __('Region/State', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_region'));
        add_settings_field('my_seo_local_postal', __('Postal Code', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_postal'));
        add_settings_field('my_seo_local_country', __('Country', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_country'));

        add_settings_field('my_seo_local_lat', __('Latitude', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_lat'));
        add_settings_field('my_seo_local_lng', __('Longitude', 'seo-fury'), array($this, 'field_text'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_lng'));
        add_settings_field('my_seo_local_opening_hours', __('Opening Hours', 'seo-fury'), array($this, 'field_textarea'), 'my_seo_local_group', 'my_seo_local_section', array('key' => 'my_seo_local_opening_hours'));
    }

    public function render_settings_page() {
        ?>
        <form method="post" action="options.php">
            <?php
            settings_fields('my_seo_local_group');
            do_settings_sections('my_seo_local_group');
            submit_button();
            ?>
        </form>
        <?php
    }

    public function local_section_callback() {
        echo '<p>' . esc_html__('Configure your local business details for Local SEO schema.', 'seo-fury') . '</p>';
    }

    public function field_enabled() {
        $enabled = get_option('my_seo_local_enabled', 0);
        ?>
        <label>
            <input type="checkbox" name="my_seo_local_enabled" value="1" <?php checked($enabled, 1); ?>>
            <?php esc_html_e('Output LocalBusiness schema on the frontend', 'seo-fury'); ?>
        </label>
        <?php
    }

    public function field_type() {
        $value = get_option('my_seo_local_type', 'LocalBusiness');
        ?>
        <input type="text" name="my_seo_local_type" value="<?php echo esc_attr($value); ?>" class="regular-text" />
        <p class="description"><?php esc_html_e('Example: LocalBusiness, Store, Restaurant, MedicalBusiness', 'seo-fury'); ?></p>
        <?php
    }

    public function field_text($args) {
        $key = $args['key'];
        $value = get_option($key, '');
        ?>
        <input type="text" name="<?php echo esc_attr($key); ?>" value="<?php echo esc_attr($value); ?>" class="regular-text" />
        <?php
    }

    public function field_textarea($args) {
        $key = $args['key'];
        $value = get_option($key, '');
        ?>
        <textarea name="<?php echo esc_attr($key); ?>" class="large-text" rows="4"><?php echo esc_textarea($value); ?></textarea>
        <p class="description"><?php esc_html_e('One line per rule, e.g. "Mo-Fr 09:00-18:00"', 'seo-fury'); ?></p>
        <?php
    }

    public function output_schema() {
        if (!get_option('my_seo_local_enabled', 0)) {
            return;
        }

        $type = get_option('my_seo_local_type', 'LocalBusiness');
        $data = array(
            '@context' => 'https://schema.org',
            '@type' => $type,
            'name' => get_option('my_seo_local_name', ''),
            'telephone' => get_option('my_seo_local_phone', ''),
            'email' => get_option('my_seo_local_email', ''),
            'url' => get_option('my_seo_local_url', home_url('/')),
            'image' => get_option('my_seo_local_image', ''),
            'logo' => get_option('my_seo_local_logo', ''),
            'priceRange' => get_option('my_seo_local_price_range', ''),
            'address' => array(
                '@type' => 'PostalAddress',
                'streetAddress' => get_option('my_seo_local_street', ''),
                'addressLocality' => get_option('my_seo_local_city', ''),
                'addressRegion' => get_option('my_seo_local_region', ''),
                'postalCode' => get_option('my_seo_local_postal', ''),
                'addressCountry' => get_option('my_seo_local_country', '')
            )
        );

        $lat = get_option('my_seo_local_lat', '');
        $lng = get_option('my_seo_local_lng', '');
        if ($lat !== '' && $lng !== '') {
            $data['geo'] = array(
                '@type' => 'GeoCoordinates',
                'latitude' => $lat,
                'longitude' => $lng
            );
        }

        $hours = get_option('my_seo_local_opening_hours', '');
        if (!empty($hours)) {
            $lines = array_filter(array_map('trim', preg_split('/\r\n|\r|\n/', $hours)));
            if (!empty($lines)) {
                $data['openingHours'] = $lines;
            }
        }

        echo '<script type="application/ld+json">' . wp_json_encode($data) . '</script>' . "\n";
    }
}
