<?php

if (!defined('ABSPATH')) {
    exit;
}

class SEO_Fury_Migration {

    private $migration_version = '0.1.0';

    private $options_map = array(
        'my_seo_robots_enabled' => 'seo_fury_robots_enabled',
        'my_seo_robots_content' => 'seo_fury_robots_content',
        'my_seo_robots_user_agents' => 'seo_fury_robots_user_agents',
        'my_seo_robots_crawl_delay' => 'seo_fury_robots_crawl_delay',
        'my_seo_robots_use_dynamic_vars' => 'seo_fury_robots_use_dynamic_vars',

        'my_seo_sitemap_enabled' => 'seo_fury_sitemap_enabled',
        'my_seo_sitemap_post_types' => 'seo_fury_sitemap_post_types',
        'my_seo_sitemap_post_types_settings' => 'seo_fury_sitemap_post_types_settings',
        'my_seo_sitemap_include_images' => 'seo_fury_sitemap_include_images',
        'my_seo_sitemap_exclude_urls' => 'seo_fury_sitemap_exclude_urls',
        'my_seo_sitemap_additional_urls' => 'seo_fury_sitemap_additional_urls',
        'my_seo_html_sitemap_slug' => 'seo_fury_html_sitemap_slug',
        'my_seo_html_sitemap_post_types' => 'seo_fury_html_sitemap_post_types',

        'my_seo_indexnow_api_key' => 'seo_fury_indexnow_api_key',
        'my_seo_indexnow_search_engine' => 'seo_fury_indexnow_search_engine',
        'my_seo_indexnow_auto_submit' => 'seo_fury_indexnow_auto_submit',
        'my_seo_indexnow_auto_delete' => 'seo_fury_indexnow_auto_delete',

        'my_seo_transliterate_urls' => 'seo_fury_transliterate_urls',

        'my_seo_robots_meta_index' => 'seo_fury_robots_meta_index',
        'my_seo_robots_meta_noindex' => 'seo_fury_robots_meta_noindex',
        'my_seo_robots_meta_nofollow' => 'seo_fury_robots_meta_nofollow',
        'my_seo_robots_meta_noarchive' => 'seo_fury_robots_meta_noarchive',
        'my_seo_robots_meta_noimageindex' => 'seo_fury_robots_meta_noimageindex',
        'my_seo_robots_meta_nosnippet' => 'seo_fury_robots_meta_nosnippet',
        'my_seo_robots_meta_max_snippet' => 'seo_fury_robots_meta_max_snippet',
        'my_seo_robots_meta_max_video_preview' => 'seo_fury_robots_meta_max_video_preview',
        'my_seo_robots_meta_max_image_preview' => 'seo_fury_robots_meta_max_image_preview',
        'my_seo_noindex_empty_archives' => 'seo_fury_noindex_empty_archives',
        'my_seo_title_separator' => 'seo_fury_title_separator',
        'my_seo_title_capitalize' => 'seo_fury_title_capitalize',
        'my_seo_twitter_card_type' => 'seo_fury_twitter_card_type',

        'my_seo_license_key' => 'seo_fury_license_key',
        'my_seo_license_status' => 'seo_fury_license_status',
        'my_seo_license_plan' => 'seo_fury_license_plan',
        'my_seo_license_domain' => 'seo_fury_license_domain',
        'my_seo_license_activated_at' => 'seo_fury_license_activated_at',
        'my_seo_license_last_checked' => 'seo_fury_license_last_checked',
        'my_seo_license_data' => 'seo_fury_license_data',

        'my_seo_404_max_logs' => 'seo_fury_404_max_logs',

        'my_seo_plugin_db_version' => 'seo_fury_db_version',

        'my_seo_integrity_manifest' => 'seo_fury_integrity_manifest',
    );

    public function run_migration() {
        $current_version = get_option('seo_fury_migration_version', '0.0.0');

        if (version_compare($current_version, $this->migration_version, '>=')) {
            error_log('SEO_FURY MIGRATION: Already migrated to version ' . $this->migration_version);
            return;
        }

        error_log('SEO_FURY MIGRATION: Starting migration from ' . $current_version . ' to ' . $this->migration_version);

        $this->migrate_options();

        update_option('seo_fury_migration_version', $this->migration_version);

        error_log('SEO_FURY MIGRATION: Migration completed successfully!');
    }

    private function migrate_options() {
        $migrated_count = 0;
        $skipped_count = 0;

        foreach ($this->options_map as $old_key => $new_key) {
            $old_value = get_option($old_key, null);

            if ($old_value === null) {
                $skipped_count++;
                continue;
            }

            $new_value = get_option($new_key, null);

            if ($new_value !== null) {
                error_log('SEO_FURY MIGRATION: Skipping ' . $new_key . ' - already exists');
                $skipped_count++;
                continue;
            }

            update_option($new_key, $old_value);
            error_log('SEO_FURY MIGRATION: ' . $old_key . ' → ' . $new_key);
            $migrated_count++;
        }

        error_log('SEO_FURY MIGRATION: Migrated ' . $migrated_count . ' options, skipped ' . $skipped_count);
    }

    public function rollback_migration() {
        error_log('SEO_FURY MIGRATION: Rolling back...');

        foreach ($this->options_map as $old_key => $new_key) {
            delete_option($new_key);
        }

        delete_option('seo_fury_migration_version');
        error_log('SEO_FURY MIGRATION: Rollback completed');
    }
}
