<?php
if (!defined('ABSPATH')) exit;

class MySEO_Plugin_Post_Meta_Basic {

    public function __construct() {
    }

    public function render_basic_tab($post, $meta_data, $preview_data) {
        ?>
        <div class="seo-fury-tab-content active" id="tab-basic">
            <div class="seo-fury-section">
                <h4><?php esc_html_e('Google Preview', 'seo-fury'); ?></h4>
                <div class="google-preview">
                    <div class="preview-url"><?php echo esc_html(parse_url($preview_data['current_url'], PHP_URL_HOST)); ?></div>
                    <div class="preview-title"><?php echo esc_html($preview_data['preview_title']); ?></div>
                    <div class="preview-description"><?php echo esc_html($preview_data['preview_description']); ?></div>
                    <div>
                        <button type="button" class="button button-primary seo-fury-edit-snippet" style="margin-top: 12px;">
                            <span class="dashicons dashicons-edit" style="margin-top: 3px;"></span>
                            <?php esc_html_e('Edit Snippet', 'seo-fury'); ?>
                        </button>
                    </div>
                </div>
            </div>

            <div class="seo-fury-section">
                <h4><?php esc_html_e('Focus Keyword', 'seo-fury'); ?></h4>
                <div class="seo-fury-field">
                    <input type="text" id="my_seo_focus_keyword" name="my_seo_focus_keyword" value="<?php echo esc_attr($meta_data['focus_keyword']); ?>" placeholder="<?php echo esc_attr__('e.g. Rank Math SEO', 'seo-fury'); ?>">
                </div>
            </div>

            <div class="seo-fury-section seo-fury-analysis">
                <div class="seo-fury-analysis-header">
                    <h4><?php esc_html_e('Basic SEO', 'seo-fury'); ?></h4>
                    <span class="seo-fury-score" id="seo-fury-score">0/100</span>
                </div>
                <ul class="seo-fury-analysis-list" id="seo-fury-analysis-list"></ul>
                <div class="seo-fury-analysis-footer">
                    <span class="seo-fury-analysis-metric"><?php esc_html_e('Keyword Density:', 'seo-fury'); ?> <strong id="seo-fury-keyword-density">0%</strong></span>
                    <div class="seo-fury-meter">
                        <span class="seo-fury-meter-bar" id="seo-fury-keyword-density-bar"></span>
                    </div>
                </div>
            </div>

            <div class="seo-fury-section seo-fury-readability">
                <div class="seo-fury-analysis-header">
                    <h4><?php esc_html_e('Readability', 'seo-fury'); ?></h4>
                    <span class="seo-fury-score" id="seo-fury-readability-score">0/100</span>
                </div>
                <ul class="seo-fury-analysis-list" id="seo-fury-readability-list"></ul>
                <div class="seo-fury-analysis-footer">
                    <span class="seo-fury-analysis-metric"><?php esc_html_e('Readability:', 'seo-fury'); ?> <strong id="seo-fury-readability-text">&mdash;</strong></span>
                    <div class="seo-fury-meter">
                        <span class="seo-fury-meter-bar" id="seo-fury-readability-bar"></span>
                    </div>
                </div>
            </div>

            <div class="seo-fury-section seo-fury-extra-seo">
                <div class="seo-fury-analysis-header">
                    <h4><?php esc_html_e('Additional SEO', 'seo-fury'); ?></h4>
                    <span class="seo-fury-score" id="seo-fury-extra-score">0/100</span>
                </div>
                <p class="description"><?php esc_html_e('Extra on-page checks to improve visibility.', 'seo-fury'); ?></p>
                <ul class="seo-fury-analysis-list" id="seo-fury-extra-list"></ul>
            </div>
        </div>
        <?php
    }

    public function render_advanced_tab($post, $meta_data) {
        ?>
        <div class="seo-fury-tab-content" id="tab-advanced">
            <div class="seo-fury-section">
                <h4><?php esc_html_e('Robots Meta', 'seo-fury'); ?></h4>
                <p class="description"><?php esc_html_e('These settings override global robots meta for this page', 'seo-fury'); ?></p>

                <div class="seo-fury-fields-grid">
                    <div class="seo-fury-field">
                        <label>
                            <input type="checkbox" name="my_seo_page_robots_noindex" value="1" <?php checked($meta_data['page_robots_noindex'], 1); ?>>
                            <?php esc_html_e('NoIndex', 'seo-fury'); ?>
                        </label>
                        <p class="description"><?php esc_html_e('Prevent indexing of this page', 'seo-fury'); ?></p>
                    </div>

                    <div class="seo-fury-field">
                        <label>
                            <input type="checkbox" name="my_seo_page_robots_nofollow" value="1" <?php checked($meta_data['page_robots_nofollow'], 1); ?>>
                            <?php esc_html_e('NoFollow', 'seo-fury'); ?>
                        </label>
                        <p class="description"><?php esc_html_e('Prevent following links', 'seo-fury'); ?></p>
                    </div>

                    <div class="seo-fury-field">
                        <label>
                            <input type="checkbox" name="my_seo_page_robots_noarchive" value="1" <?php checked($meta_data['page_robots_noarchive'], 1); ?>>
                            <?php esc_html_e('NoArchive', 'seo-fury'); ?>
                        </label>
                        <p class="description"><?php esc_html_e('Prevent cached copy', 'seo-fury'); ?></p>
                    </div>

                    <div class="seo-fury-field">
                        <label>
                            <input type="checkbox" name="my_seo_page_robots_nosnippet" value="1" <?php checked($meta_data['page_robots_nosnippet'], 1); ?>>
                            <?php esc_html_e('NoSnippet', 'seo-fury'); ?>
                        </label>
                        <p class="description"><?php esc_html_e('Prevent snippet display', 'seo-fury'); ?></p>
                    </div>

                    <div class="seo-fury-field">
                        <label>
                            <input type="checkbox" name="my_seo_page_robots_noimageindex" value="1" <?php checked($meta_data['page_robots_noimageindex'], 1); ?>>
                            <?php esc_html_e('NoImageIndex', 'seo-fury'); ?>
                        </label>
                        <p class="description"><?php esc_html_e('Prevent image indexing', 'seo-fury'); ?></p>
                    </div>

                    <div class="seo-fury-field">
                        <label for="my_seo_page_robots_max_snippet"><?php esc_html_e('Max Snippet', 'seo-fury'); ?></label>
                        <input type="number" id="my_seo_page_robots_max_snippet" name="my_seo_page_robots_max_snippet"
                               value="<?php echo esc_attr($meta_data['page_robots_max_snippet']); ?>" placeholder="-1">
                        <p class="description"><?php esc_html_e('Text length (-1 = unlimited)', 'seo-fury'); ?></p>
                    </div>

                    <div class="seo-fury-field">
                        <label for="my_seo_page_robots_max_video"><?php esc_html_e('Max Video Preview', 'seo-fury'); ?></label>
                        <input type="number" id="my_seo_page_robots_max_video" name="my_seo_page_robots_max_video"
                               value="<?php echo esc_attr($meta_data['page_robots_max_video']); ?>" placeholder="-1">
                        <p class="description"><?php esc_html_e('Video length in seconds', 'seo-fury'); ?></p>
                    </div>

                    <div class="seo-fury-field">
                        <label for="my_seo_page_robots_max_image"><?php esc_html_e('Max Image Preview', 'seo-fury'); ?></label>
                        <select id="my_seo_page_robots_max_image" name="my_seo_page_robots_max_image">
                            <option value=""><?php esc_html_e('Default', 'seo-fury'); ?></option>
                            <option value="none" <?php selected($meta_data['page_robots_max_image'], 'none'); ?>><?php esc_html_e('None', 'seo-fury'); ?></option>
                            <option value="standard" <?php selected($meta_data['page_robots_max_image'], 'standard'); ?>><?php esc_html_e('Standard', 'seo-fury'); ?></option>
                            <option value="large" <?php selected($meta_data['page_robots_max_image'], 'large'); ?>><?php esc_html_e('Large', 'seo-fury'); ?></option>
                        </select>
                        <p class="description"><?php esc_html_e('Preview size', 'seo-fury'); ?></p>
                    </div>
                </div>
            </div>

            <div class="seo-fury-section">
                <h4><?php esc_html_e('Canonical URL', 'seo-fury'); ?></h4>
                <div class="seo-fury-field">
                    <label for="my_seo_canonical"><?php esc_html_e('Canonical URL', 'seo-fury'); ?></label>
                    <input type="url" id="my_seo_canonical" name="my_seo_canonical"
                           value="<?php echo esc_attr($meta_data['canonical_url']); ?>">
                    <p class="description"><?php esc_html_e('Defaults to current page URL', 'seo-fury'); ?></p>
                </div>
            </div>
        </div>
        <?php
    }

    public function save_meta($post_id) {
        update_post_meta($post_id, '_my_seo_page_robots_noindex', isset($_POST['my_seo_page_robots_noindex']) ? 1 : 0);
        update_post_meta($post_id, '_my_seo_page_robots_nofollow', isset($_POST['my_seo_page_robots_nofollow']) ? 1 : 0);
        update_post_meta($post_id, '_my_seo_page_robots_noarchive', isset($_POST['my_seo_page_robots_noarchive']) ? 1 : 0);
        update_post_meta($post_id, '_my_seo_page_robots_nosnippet', isset($_POST['my_seo_page_robots_nosnippet']) ? 1 : 0);
        update_post_meta($post_id, '_my_seo_page_robots_noimageindex', isset($_POST['my_seo_page_robots_noimageindex']) ? 1 : 0);

        if (isset($_POST['my_seo_page_robots_max_snippet'])) {
            update_post_meta($post_id, '_my_seo_page_robots_max_snippet', sanitize_text_field($_POST['my_seo_page_robots_max_snippet']));
        }

        if (isset($_POST['my_seo_page_robots_max_video'])) {
            update_post_meta($post_id, '_my_seo_page_robots_max_video', sanitize_text_field($_POST['my_seo_page_robots_max_video']));
        }

        if (isset($_POST['my_seo_page_robots_max_image'])) {
            update_post_meta($post_id, '_my_seo_page_robots_max_image', sanitize_text_field($_POST['my_seo_page_robots_max_image']));
        }

        if (isset($_POST['my_seo_canonical'])) {
            update_post_meta($post_id, '_my_seo_canonical', esc_url_raw($_POST['my_seo_canonical']));
        }
    }

    public function output_meta_tags($post) {
        $robots_parts = array();
        $page_robots_noindex = get_post_meta($post->ID, '_my_seo_page_robots_noindex', true);
        $page_robots_nofollow = get_post_meta($post->ID, '_my_seo_page_robots_nofollow', true);
        $page_robots_noarchive = get_post_meta($post->ID, '_my_seo_page_robots_noarchive', true);
        $page_robots_nosnippet = get_post_meta($post->ID, '_my_seo_page_robots_nosnippet', true);
        $page_robots_noimageindex = get_post_meta($post->ID, '_my_seo_page_robots_noimageindex', true);

        if ($page_robots_noindex) {
            $robots_parts[] = 'noindex';
        } else {
            $robots_parts[] = 'index';
        }

        if ($page_robots_nofollow) {
            $robots_parts[] = 'nofollow';
        } else {
            $robots_parts[] = 'follow';
        }

        if ($page_robots_noarchive) {
            $robots_parts[] = 'noarchive';
        }

        if ($page_robots_nosnippet) {
            $robots_parts[] = 'nosnippet';
        }

        if ($page_robots_noimageindex) {
            $robots_parts[] = 'noimageindex';
        }

        $page_robots_max_snippet = get_post_meta($post->ID, '_my_seo_page_robots_max_snippet', true);
        if ($page_robots_max_snippet !== '') {
            $robots_parts[] = 'max-snippet:' . intval($page_robots_max_snippet);
        }

        $page_robots_max_video = get_post_meta($post->ID, '_my_seo_page_robots_max_video', true);
        if ($page_robots_max_video !== '') {
            $robots_parts[] = 'max-video-preview:' . intval($page_robots_max_video);
        }

        $page_robots_max_image = get_post_meta($post->ID, '_my_seo_page_robots_max_image', true);
        if ($page_robots_max_image) {
            $robots_parts[] = 'max-image-preview:' . $page_robots_max_image;
        }

        if (!empty($robots_parts)) {
            echo '<meta name="robots" content="' . esc_attr(implode(', ', $robots_parts)) . '">' . "\n";
        }

        $canonical_url = get_post_meta($post->ID, '_my_seo_canonical', true);
        if (!$canonical_url) {
            $canonical_url = get_permalink($post->ID);
        }

        if ($canonical_url) {
            echo '<link rel="canonical" href="' . esc_url($canonical_url) . '">' . "\n";
        }
    }
}
