<?php
if (!defined('ABSPATH')) exit;

class MySEO_Plugin_Post_Meta_Social
{

    public function __construct()
    {
    }

    public function render_opengraph_tab($post, $meta_data, $preview_data)
    {
?>
        <div class="seo-fury-tab-content" id="tab-opengraph">
            <div class="seo-fury-section">
                <h4><?php esc_html_e('Social Preview', 'seo-fury'); ?></h4>
                <div class="seo-fury-social-preview-tabs">
                    <button type="button" class="seo-fury-social-tab active" data-social-tab="facebook">
                        <span class="dashicons dashicons-facebook"></span>
                        <?php esc_html_e('Facebook', 'seo-fury'); ?>
                    </button>
                    <button type="button" class="seo-fury-social-tab" data-social-tab="twitter">
                        <span class="dashicons dashicons-twitter"></span>
                        <?php esc_html_e('Twitter', 'seo-fury'); ?>
                    </button>
                </div>

                <div class="seo-fury-social-preview-panels">
                    <div class="seo-fury-social-panel active" data-social-panel="facebook">
                        <div class="social-post-card facebook-card">
                            <div class="social-post-header">
                                <div class="social-avatar"></div>
                                <div class="social-post-meta">
                                    <strong class="social-username"><?php esc_html_e('Facebook user', 'seo-fury'); ?></strong>
                                    <div class="social-time"><?php esc_html_e('2 hours ago', 'seo-fury'); ?></div>
                                </div>
                            </div>
                            <?php if ($preview_data['fb_preview_image']): ?>
                                <div class="social-post-image">
                                    <img src="<?php echo esc_url($preview_data['fb_preview_image']); ?>" alt="<?php echo esc_attr__('FB Preview', 'seo-fury'); ?>">
                                </div>
                            <?php endif; ?>
                            <div class="social-post-footer facebook-footer">
                                <div class="social-link-domain"><?php echo esc_html(strtoupper(parse_url($preview_data['current_url'], PHP_URL_HOST))); ?></div>
                                <div class="social-link-title fb-title"><?php echo esc_html($preview_data['fb_preview_title']); ?></div>
                                <div class="social-link-description fb-description"><?php echo esc_html($preview_data['fb_preview_desc']); ?></div>
                            </div>
                        </div>
                    </div>

                    <div class="seo-fury-social-panel" data-social-panel="twitter">
                        <div class="social-post-card twitter-card">
                            <div class="social-post-header">
                                <div class="social-avatar"></div>
                                <div class="social-post-meta">
                                    <strong class="social-username"><?php esc_html_e('Twitter user', 'seo-fury'); ?></strong>
                                    <div class="social-handle">@username · <?php esc_html_e('2 hours', 'seo-fury'); ?></div>
                                </div>
                            </div>
                            <div class="social-post-text"><?php esc_html_e('Post with a link!', 'seo-fury'); ?></div>
                            <?php if ($preview_data['tw_preview_image']): ?>
                                <div class="social-post-image">
                                    <img src="<?php echo esc_url($preview_data['tw_preview_image']); ?>" alt="<?php echo esc_attr__('Twitter Preview', 'seo-fury'); ?>">
                                </div>
                            <?php endif; ?>
                            <div class="social-post-footer twitter-footer">
                                <div class="social-link-title tw-title"><?php echo esc_html($preview_data['tw_preview_title']); ?></div>
                                <div class="social-link-description tw-description"><?php echo esc_html($preview_data['tw_preview_desc']); ?></div>
                                <div class="social-link-domain"><?php echo esc_html(parse_url($preview_data['current_url'], PHP_URL_HOST)); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <p style="margin-top: 12px;">
                    <button type="button" class="button button-primary seo-fury-edit-snippet" data-modal-tab="social">
                        <span class="dashicons dashicons-edit" style="margin-top: 3px;"></span>
                        <?php esc_html_e('Edit Snippet', 'seo-fury'); ?>
                    </button>
                </p>
            </div>

            <div class="seo-fury-section seo-fury-social-settings">
                <h4><?php esc_html_e('Social Settings', 'seo-fury'); ?></h4>
                <div class="seo-fury-social-settings-tabs">
                    <button type="button" class="seo-fury-social-settings-tab active" data-settings-tab="all"><?php esc_html_e('All Networks', 'seo-fury'); ?></button>
                    <button type="button" class="seo-fury-social-settings-tab" data-settings-tab="facebook"><?php esc_html_e('Facebook', 'seo-fury'); ?></button>
                    <button type="button" class="seo-fury-social-settings-tab" data-settings-tab="twitter"><?php esc_html_e('Twitter', 'seo-fury'); ?></button>
                </div>

                <div class="seo-fury-social-settings-panels">
                    <div class="seo-fury-social-settings-panel active" data-settings-panel="all">
                        <div class="seo-fury-fields-grid">
                            <div class="seo-fury-field">
                                <label for="my_seo_social_title"><?php esc_html_e('Title', 'seo-fury'); ?></label>
                                <input type="text" id="my_seo_social_title" class="seo-fury-social-all-title" placeholder="<?php echo esc_attr__('Title for all networks', 'seo-fury'); ?>">
                            </div>
                            <div class="seo-fury-field">
                                <label for="my_seo_social_description"><?php esc_html_e('Description', 'seo-fury'); ?></label>
                                <textarea id="my_seo_social_description" class="seo-fury-social-all-description" rows="3" placeholder="<?php echo esc_attr__('Description for all networks', 'seo-fury'); ?>"></textarea>
                            </div>
                            <div class="seo-fury-field">
                                <label for="my_seo_social_image"><?php esc_html_e('Image', 'seo-fury'); ?></label>
                                <input type="url" id="my_seo_social_image" class="seo-fury-social-all-image" placeholder="https://">
                                <button type="button" class="button my-seo-upload-image" data-target="my_seo_social_image">
                                    <span class="dashicons dashicons-format-image" style="vertical-align: middle;"></span>
                                    <?php esc_html_e('Choose Image', 'seo-fury'); ?>
                                </button>
                            </div>
                        </div>
                        <p class="description"><?php esc_html_e('Values apply to Facebook and Twitter', 'seo-fury'); ?></p>
                    </div>

                    <div class="seo-fury-social-settings-panel" data-settings-panel="facebook">
                        <div class="seo-fury-fields-grid">
                            <div class="seo-fury-field">
                                <label for="my_seo_fb_title"><?php esc_html_e('Facebook Title', 'seo-fury'); ?></label>
                                <div class="input-with-dropdown">
                                    <input type="text" id="my_seo_fb_title" name="my_seo_fb_title" value="<?php echo esc_attr($meta_data['fb_title']); ?>">
                                    <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_fb_title">
                                        <span class="dashicons dashicons-arrow-down-alt2"></span>
                                    </button>
                                    <div class="shortcode-dropdown-menu">
                                        <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%seotitle%"><strong>%seotitle%</strong> <span><?php esc_html_e('SEO title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sitename%"><strong>%sitename%</strong> <span><?php esc_html_e('Site name', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sep%"><strong>%sep%</strong> <span><?php esc_html_e('Separator —', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%category%"><strong>%category%</strong> <span><?php esc_html_e('Category', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%date%"><strong>%date%</strong> <span><?php esc_html_e('Publish date', 'seo-fury'); ?></span></div>
                                    </div>
                                </div>
                            </div>

                            <div class="seo-fury-field">
                                <label for="my_seo_fb_image"><?php esc_html_e('Facebook Image', 'seo-fury'); ?></label>
                                <input type="url" id="my_seo_fb_image" name="my_seo_fb_image" value="<?php echo esc_attr($meta_data['fb_image']); ?>">
                                <button type="button" class="button my-seo-upload-image" data-target="my_seo_fb_image">
                                    <span class="dashicons dashicons-format-image" style="vertical-align: middle;"></span>
                                    <?php esc_html_e('Choose Image', 'seo-fury'); ?>
                                </button>
                                <button type="button" class="button my-seo-remove-image-button" data-target="my_seo_fb_image"
                                    style="<?php echo $meta_data['fb_image'] ? '' : 'display:none;'; ?>margin-left: 5px;">
                                    <span class="dashicons dashicons-no" style="vertical-align: middle;"></span>
                                    <?php esc_html_e('Remove', 'seo-fury'); ?>
                                </button>
                            </div>

                            <div class="seo-fury-field">
                                <label for="my_seo_fb_description"><?php esc_html_e('Facebook Description', 'seo-fury'); ?></label>
                                <div class="input-with-dropdown">
                                    <textarea id="my_seo_fb_description" name="my_seo_fb_description" rows="3"><?php echo esc_textarea($meta_data['fb_description']); ?></textarea>
                                    <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_fb_description">
                                        <span class="dashicons dashicons-arrow-down-alt2"></span>
                                    </button>
                                    <div class="shortcode-dropdown-menu">
                                        <div class="shortcode-item" data-var="%excerpt%"><strong>%excerpt%</strong> <span><?php esc_html_e('Post excerpt', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%seodescription%"><strong>%seodescription%</strong> <span><?php esc_html_e('SEO description', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sitedesc%"><strong>%sitedesc%</strong> <span><?php esc_html_e('Site description', 'seo-fury'); ?></span></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="seo-fury-social-settings-panel" data-settings-panel="twitter">
                        <div class="seo-fury-fields-grid">
                            <div class="seo-fury-field">
                                <label for="my_seo_twitter_title"><?php esc_html_e('Twitter Title', 'seo-fury'); ?></label>
                                <div class="input-with-dropdown">
                                    <input type="text" id="my_seo_twitter_title" name="my_seo_twitter_title" value="<?php echo esc_attr($meta_data['twitter_title']); ?>">
                                    <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_twitter_title">
                                        <span class="dashicons dashicons-arrow-down-alt2"></span>
                                    </button>
                                    <div class="shortcode-dropdown-menu">
                                        <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%seotitle%"><strong>%seotitle%</strong> <span><?php esc_html_e('SEO title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sitename%"><strong>%sitename%</strong> <span><?php esc_html_e('Site name', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sep%"><strong>%sep%</strong> <span><?php esc_html_e('Separator —', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%category%"><strong>%category%</strong> <span><?php esc_html_e('Category', 'seo-fury'); ?></span></div>
                                    </div>
                                </div>
                            </div>

                            <div class="seo-fury-field">
                                <label for="my_seo_twitter_card_type"><?php esc_html_e('Twitter Card Type', 'seo-fury'); ?></label>
                                <select id="my_seo_twitter_card_type" name="my_seo_twitter_card_type">
                                    <option value="summary" <?php selected($meta_data['twitter_card_type'], 'summary'); ?>><?php esc_html_e('Summary', 'seo-fury'); ?></option>
                                    <option value="summary_large_image" <?php selected($meta_data['twitter_card_type'], 'summary_large_image'); ?>><?php esc_html_e('Summary Large Image', 'seo-fury'); ?></option>
                                </select>
                            </div>

                            <div class="seo-fury-field">
                                <label for="my_seo_twitter_description"><?php esc_html_e('Twitter Description', 'seo-fury'); ?></label>
                                <div class="input-with-dropdown">
                                    <textarea id="my_seo_twitter_description" name="my_seo_twitter_description" rows="3"><?php echo esc_textarea($meta_data['twitter_description']); ?></textarea>
                                    <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_twitter_description">
                                        <span class="dashicons dashicons-arrow-down-alt2"></span>
                                    </button>
                                    <div class="shortcode-dropdown-menu">
                                        <div class="shortcode-item" data-var="%excerpt%"><strong>%excerpt%</strong> <span><?php esc_html_e('Post excerpt', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%seodescription%"><strong>%seodescription%</strong> <span><?php esc_html_e('SEO description', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sitedesc%"><strong>%sitedesc%</strong> <span><?php esc_html_e('Site description', 'seo-fury'); ?></span></div>
                                    </div>
                                </div>
                            </div>

                            <div class="seo-fury-field">
                                <label for="my_seo_twitter_image"><?php esc_html_e('Twitter Image', 'seo-fury'); ?></label>
                                <input type="url" id="my_seo_twitter_image" name="my_seo_twitter_image" value="<?php echo esc_attr($meta_data['twitter_image']); ?>">
                                <button type="button" class="button my-seo-upload-image" data-target="my_seo_twitter_image">
                                    <span class="dashicons dashicons-format-image" style="vertical-align: middle;"></span>
                                    <?php esc_html_e('Choose Image', 'seo-fury'); ?>
                                </button>
                                <button type="button" class="button my-seo-remove-image-button" data-target="my_seo_twitter_image"
                                    style="<?php echo $meta_data['twitter_image'] ? '' : 'display:none;'; ?>margin-left: 5px;">
                                    <span class="dashicons dashicons-no" style="vertical-align: middle;"></span>
                                    <?php esc_html_e('Remove', 'seo-fury'); ?>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="seo-fury-social-settings-panel" data-settings-panel="opengraph">
                        <div class="seo-fury-fields-grid">
                            <div class="seo-fury-field">
                                <label for="my_seo_og_title"><?php esc_html_e('OG Title', 'seo-fury'); ?></label>
                                <div class="input-with-dropdown">
                                    <input type="text" id="my_seo_og_title" name="my_seo_og_title" value="<?php echo esc_attr($meta_data['og_title']); ?>">
                                    <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_og_title">
                                        <span class="dashicons dashicons-arrow-down-alt2"></span>
                                    </button>
                                    <div class="shortcode-dropdown-menu">
                                        <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%seotitle%"><strong>%seotitle%</strong> <span><?php esc_html_e('SEO title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sitename%"><strong>%sitename%</strong> <span><?php esc_html_e('Site name', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sep%"><strong>%sep%</strong> <span><?php esc_html_e('Separator —', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%category%"><strong>%category%</strong> <span><?php esc_html_e('Category', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%date%"><strong>%date%</strong> <span><?php esc_html_e('Publish date', 'seo-fury'); ?></span></div>
                                    </div>
                                </div>
                            </div>

                            <div class="seo-fury-field">
                                <label for="my_seo_og_type"><?php esc_html_e('OG Type', 'seo-fury'); ?></label>
                                <select id="my_seo_og_type" name="my_seo_og_type">
                                    <option value="article" <?php selected($meta_data['og_type'], 'article'); ?>><?php esc_html_e('Article', 'seo-fury'); ?></option>
                                    <option value="website" <?php selected($meta_data['og_type'], 'website'); ?>><?php esc_html_e('Website', 'seo-fury'); ?></option>
                                    <option value="product" <?php selected($meta_data['og_type'], 'product'); ?>><?php esc_html_e('Product', 'seo-fury'); ?></option>
                                    <option value="video" <?php selected($meta_data['og_type'], 'video'); ?>><?php esc_html_e('Video', 'seo-fury'); ?></option>
                                </select>
                            </div>

                            <div class="seo-fury-field">
                                <label for="my_seo_og_description"><?php esc_html_e('OG Description', 'seo-fury'); ?></label>
                                <div class="input-with-dropdown">
                                    <textarea id="my_seo_og_description" name="my_seo_og_description" rows="2"><?php echo esc_textarea($meta_data['og_description']); ?></textarea>
                                    <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_og_description">
                                        <span class="dashicons dashicons-arrow-down-alt2"></span>
                                    </button>
                                    <div class="shortcode-dropdown-menu">
                                        <div class="shortcode-item" data-var="%excerpt%"><strong>%excerpt%</strong> <span><?php esc_html_e('Post excerpt', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%seodescription%"><strong>%seodescription%</strong> <span><?php esc_html_e('SEO description', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%sitedesc%"><strong>%sitedesc%</strong> <span><?php esc_html_e('Site description', 'seo-fury'); ?></span></div>
                                        <div class="shortcode-item" data-var="%wcshortdesc%"><strong>%wcshortdesc%</strong> <span><?php esc_html_e('Product short description', 'seo-fury'); ?></span></div>
                                    </div>
                                </div>
                            </div>

                            <div class="seo-fury-field">
                                <label for="my_seo_og_image"><?php esc_html_e('OG Image', 'seo-fury'); ?></label>
                                <input type="url" id="my_seo_og_image" name="my_seo_og_image" value="<?php echo esc_attr($meta_data['og_image']); ?>">
                                <button type="button" class="button my-seo-upload-image" data-target="my_seo_og_image">
                                    <span class="dashicons dashicons-format-image" style="vertical-align: middle;"></span>
                                    <?php esc_html_e('Select image', 'seo-fury'); ?>
                                </button>
                                <button type="button" class="button my-seo-remove-image-button" data-target="my_seo_og_image"
                                    style="<?php echo $meta_data['og_image'] ? '' : 'display:none;'; ?>margin-left: 5px;">
                                    <span class="dashicons dashicons-no" style="vertical-align: middle;"></span>
                                    <?php esc_html_e('Remove', 'seo-fury'); ?>
                                </button>
                                <?php if ($meta_data['og_image']): ?>
                                    <div class="my-seo-image-preview">
                                        <img src="<?php echo esc_url($meta_data['og_image']); ?>" alt="<?php echo esc_attr__('Preview', 'seo-fury'); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }

    public function render_social_tab($post, $meta_data, $preview_data)
    {
    ?>
        <div class="seo-fury-tab-content" id="tab-social">
            <div class="social-tab-layout">
                <div class="social-preview-row">
                    <div class="social-preview-column">
                        <div class="seo-fury-section">
                            <h4><?php esc_html_e('Facebook Preview', 'seo-fury'); ?></h4>
                            <div class="social-post-card facebook-card">
                                <div class="social-post-header">
                                    <div class="social-avatar"></div>
                                    <div class="social-post-meta">
                                        <strong class="social-username"><?php esc_html_e('Facebook user', 'seo-fury'); ?></strong>
                                        <div class="social-time"><?php esc_html_e('2 hours ago', 'seo-fury'); ?></div>
                                    </div>
                                </div>
                                <?php if ($preview_data['fb_preview_image']): ?>
                                    <div class="social-post-image">
                                        <img src="<?php echo esc_url($preview_data['fb_preview_image']); ?>" alt="<?php echo esc_attr__('FB Preview', 'seo-fury'); ?>">
                                    </div>
                                <?php endif; ?>
                                <div class="social-post-footer facebook-footer">
                                    <div class="social-link-domain"><?php echo esc_html(strtoupper(parse_url($preview_data['current_url'], PHP_URL_HOST))); ?></div>
                                    <div class="social-link-title fb-title"><?php echo esc_html($preview_data['fb_preview_title']); ?></div>
                                    <div class="social-link-description fb-description"><?php echo esc_html($preview_data['fb_preview_desc']); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="social-preview-column">
                        <div class="seo-fury-section">
                            <h4><?php esc_html_e('Twitter Preview', 'seo-fury'); ?></h4>
                            <div class="social-post-card twitter-card">
                                <div class="social-post-header">
                                    <div class="social-avatar"></div>
                                    <div class="social-post-meta">
                                        <strong class="social-username"><?php esc_html_e('Twitter user', 'seo-fury'); ?></strong>
                                        <div class="social-handle">@username · <?php esc_html_e('2h', 'seo-fury'); ?></div>
                                    </div>
                                </div>
                                <div class="social-post-text"><?php esc_html_e('Post with a link!', 'seo-fury'); ?></div>
                                <?php if ($preview_data['tw_preview_image']): ?>
                                    <div class="social-post-image">
                                        <img src="<?php echo esc_url($preview_data['tw_preview_image']); ?>" alt="<?php echo esc_attr__('Twitter Preview', 'seo-fury'); ?>">
                                    </div>
                                <?php endif; ?>
                                <div class="social-post-footer twitter-footer">
                                    <div class="social-link-title tw-title"><?php echo esc_html($preview_data['tw_preview_title']); ?></div>
                                    <div class="social-link-description tw-description"><?php echo esc_html($preview_data['tw_preview_desc']); ?></div>
                                    <div class="social-link-domain"><?php echo esc_html(parse_url($preview_data['current_url'], PHP_URL_HOST)); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="social-settings-row">
                    <div class="social-settings-column">
                        <div class="seo-fury-section">
                            <h4><?php esc_html_e('Facebook Settings', 'seo-fury'); ?></h4>
                            <div class="seo-fury-fields-grid">
                                <div class="seo-fury-field">
                                    <label for="my_seo_fb_title"><?php esc_html_e('Facebook Title', 'seo-fury'); ?></label>
                                    <div class="input-with-dropdown">
                                        <input type="text" id="my_seo_fb_title" name="my_seo_fb_title" value="<?php echo esc_attr($meta_data['fb_title']); ?>">
                                        <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_fb_title">
                                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                                        </button>
                                        <div class="shortcode-dropdown-menu">
                                            <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%seotitle%"><strong>%seotitle%</strong> <span><?php esc_html_e('SEO title', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%sitename%"><strong>%sitename%</strong> <span><?php esc_html_e('Site name', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%sep%"><strong>%sep%</strong> <span><?php esc_html_e('Separator —', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%category%"><strong>%category%</strong> <span><?php esc_html_e('Category', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%date%"><strong>%date%</strong> <span><?php esc_html_e('Publish date', 'seo-fury'); ?></span></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="seo-fury-field">
                                    <label for="my_seo_fb_image"><?php esc_html_e('Facebook Image', 'seo-fury'); ?></label>
                                    <input type="url" id="my_seo_fb_image" name="my_seo_fb_image" value="<?php echo esc_attr($meta_data['fb_image']); ?>">
                                    <button type="button" class="button my-seo-upload-image" data-target="my_seo_fb_image">
                                        <span class="dashicons dashicons-format-image" style="vertical-align: middle;"></span>
                                        <?php esc_html_e('Select image', 'seo-fury'); ?>
                                    </button>
                                    <button type="button" class="button my-seo-remove-image-button" data-target="my_seo_fb_image"
                                        style="<?php echo $meta_data['fb_image'] ? '' : 'display:none;'; ?>margin-left: 5px;">
                                        <span class="dashicons dashicons-no" style="vertical-align: middle;"></span>
                                        <?php esc_html_e('Remove', 'seo-fury'); ?>
                                    </button>
                                </div>

                                <div class="seo-fury-field">
                                    <label for="my_seo_fb_description"><?php esc_html_e('Facebook Description', 'seo-fury'); ?></label>
                                    <div class="input-with-dropdown">
                                        <textarea id="my_seo_fb_description" name="my_seo_fb_description" rows="3"><?php echo esc_textarea($meta_data['fb_description']); ?></textarea>
                                        <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_fb_description">
                                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                                        </button>
                                        <div class="shortcode-dropdown-menu">
                                            <div class="shortcode-item" data-var="%excerpt%"><strong>%excerpt%</strong> <span><?php esc_html_e('Post excerpt', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%seodescription%"><strong>%seodescription%</strong> <span><?php esc_html_e('SEO description', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%sitedesc%"><strong>%sitedesc%</strong> <span><?php esc_html_e('Site description', 'seo-fury'); ?></span></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="social-settings-column">
                        <div class="seo-fury-section">
                            <h4><?php esc_html_e('Twitter (X) Settings', 'seo-fury'); ?></h4>
                            <div class="seo-fury-fields-grid">
                                <div class="seo-fury-field">
                                    <label for="my_seo_twitter_title"><?php esc_html_e('Twitter Title', 'seo-fury'); ?></label>
                                    <div class="input-with-dropdown">
                                        <input type="text" id="my_seo_twitter_title" name="my_seo_twitter_title" value="<?php echo esc_attr($meta_data['twitter_title']); ?>">
                                        <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_twitter_title">
                                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                                        </button>
                                        <div class="shortcode-dropdown-menu">
                                            <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%seotitle%"><strong>%seotitle%</strong> <span><?php esc_html_e('SEO title', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%sitename%"><strong>%sitename%</strong> <span><?php esc_html_e('Site name', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%sep%"><strong>%sep%</strong> <span><?php esc_html_e('Separator —', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%category%"><strong>%category%</strong> <span><?php esc_html_e('Category', 'seo-fury'); ?></span></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="seo-fury-field">
                                    <label for="my_seo_twitter_card_type"><?php esc_html_e('Twitter Card Type', 'seo-fury'); ?></label>
                                    <select id="my_seo_twitter_card_type" name="my_seo_twitter_card_type">
                                        <option value="summary" <?php selected($meta_data['twitter_card_type'], 'summary'); ?>><?php esc_html_e('Summary', 'seo-fury'); ?></option>
                                        <option value="summary_large_image" <?php selected($meta_data['twitter_card_type'], 'summary_large_image'); ?>><?php esc_html_e('Summary Large Image', 'seo-fury'); ?></option>
                                    </select>
                                </div>

                                <div class="seo-fury-field">
                                    <label for="my_seo_twitter_description"><?php esc_html_e('Twitter Description', 'seo-fury'); ?></label>
                                    <div class="input-with-dropdown">
                                        <textarea id="my_seo_twitter_description" name="my_seo_twitter_description" rows="3"><?php echo esc_textarea($meta_data['twitter_description']); ?></textarea>
                                        <button type="button" class="shortcode-dropdown-btn" data-target="my_seo_twitter_description">
                                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                                        </button>
                                        <div class="shortcode-dropdown-menu">
                                            <div class="shortcode-item" data-var="%excerpt%"><strong>%excerpt%</strong> <span><?php esc_html_e('Post excerpt', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%seodescription%"><strong>%seodescription%</strong> <span><?php esc_html_e('SEO description', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%title%"><strong>%title%</strong> <span><?php esc_html_e('Post title', 'seo-fury'); ?></span></div>
                                            <div class="shortcode-item" data-var="%sitedesc%"><strong>%sitedesc%</strong> <span><?php esc_html_e('Site description', 'seo-fury'); ?></span></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="seo-fury-field">
                                    <label for="my_seo_twitter_image"><?php esc_html_e('Twitter Image', 'seo-fury'); ?></label>
                                    <input type="url" id="my_seo_twitter_image" name="my_seo_twitter_image" value="<?php echo esc_attr($meta_data['twitter_image']); ?>">
                                    <button type="button" class="button my-seo-upload-image" data-target="my_seo_twitter_image">
                                        <span class="dashicons dashicons-format-image" style="vertical-align: middle;"></span>
                                        <?php esc_html_e('Select image', 'seo-fury'); ?>
                                    </button>
                                    <button type="button" class="button my-seo-remove-image-button" data-target="my_seo_twitter_image"
                                        style="<?php echo $meta_data['twitter_image'] ? '' : 'display:none;'; ?>margin-left: 5px;">
                                        <span class="dashicons dashicons-no" style="vertical-align: middle;"></span>
                                        <?php esc_html_e('Remove', 'seo-fury'); ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php
    }

    public function save_meta($post_id)
    {
        if (isset($_POST['my_seo_og_title'])) {
            update_post_meta($post_id, '_my_seo_og_title', sanitize_text_field($_POST['my_seo_og_title']));
        }

        if (isset($_POST['my_seo_og_description'])) {
            update_post_meta($post_id, '_my_seo_og_description', sanitize_textarea_field($_POST['my_seo_og_description']));
        }

        if (isset($_POST['my_seo_og_image'])) {
            update_post_meta($post_id, '_my_seo_og_image', esc_url_raw($_POST['my_seo_og_image']));
        }

        if (isset($_POST['my_seo_og_type'])) {
            update_post_meta($post_id, '_my_seo_og_type', sanitize_text_field($_POST['my_seo_og_type']));
        }

        if (isset($_POST['my_seo_twitter_title'])) {
            update_post_meta($post_id, '_my_seo_twitter_title', sanitize_text_field($_POST['my_seo_twitter_title']));
        }

        if (isset($_POST['my_seo_twitter_description'])) {
            update_post_meta($post_id, '_my_seo_twitter_description', sanitize_textarea_field($_POST['my_seo_twitter_description']));
        }

        if (isset($_POST['my_seo_twitter_image'])) {
            update_post_meta($post_id, '_my_seo_twitter_image', esc_url_raw($_POST['my_seo_twitter_image']));
        }

        if (isset($_POST['my_seo_twitter_card_type'])) {
            update_post_meta($post_id, '_my_seo_twitter_card_type', sanitize_text_field($_POST['my_seo_twitter_card_type']));
        }

        if (isset($_POST['my_seo_fb_title'])) {
            update_post_meta($post_id, '_my_seo_fb_title', sanitize_text_field($_POST['my_seo_fb_title']));
        }

        if (isset($_POST['my_seo_fb_description'])) {
            update_post_meta($post_id, '_my_seo_fb_description', sanitize_textarea_field($_POST['my_seo_fb_description']));
        }

        if (isset($_POST['my_seo_fb_image'])) {
            update_post_meta($post_id, '_my_seo_fb_image', esc_url_raw($_POST['my_seo_fb_image']));
        }
    }

    public function output_meta_tags($post, $parse_shortcodes_callback)
    {
        $meta_title = get_post_meta($post->ID, '_my_seo_title', true);
        $meta_description = get_post_meta($post->ID, '_my_seo_description', true);

        $og_title = get_post_meta($post->ID, '_my_seo_og_title', true);
        $og_description = get_post_meta($post->ID, '_my_seo_og_description', true);
        $og_image = get_post_meta($post->ID, '_my_seo_og_image', true);
        $og_type = get_post_meta($post->ID, '_my_seo_og_type', true);

        if (!$og_title) {
            $og_title = $meta_title ? call_user_func($parse_shortcodes_callback, $meta_title, $post) : get_the_title($post);
        }

        if (!$og_description) {
            $og_description = $meta_description ? call_user_func($parse_shortcodes_callback, $meta_description, $post) : wp_trim_words($post->post_content, 20);
        }

        if (!$og_image && has_post_thumbnail($post)) {
            $og_image = get_the_post_thumbnail_url($post, 'large');
        }

        if (!$og_type) {
            $og_type = 'article';
        }

        echo '<meta property="og:title" content="' . esc_attr($og_title) . '">' . "\n";
        echo '<meta property="og:description" content="' . esc_attr($og_description) . '">' . "\n";
        echo '<meta property="og:type" content="' . esc_attr($og_type) . '">' . "\n";
        echo '<meta property="og:url" content="' . esc_url(get_permalink($post)) . '">' . "\n";

        if ($og_image) {
            echo '<meta property="og:image" content="' . esc_url($og_image) . '">' . "\n";
        }

        $twitter_title = get_post_meta($post->ID, '_my_seo_twitter_title', true);
        $twitter_description = get_post_meta($post->ID, '_my_seo_twitter_description', true);
        $twitter_image = get_post_meta($post->ID, '_my_seo_twitter_image', true);
        $twitter_card_type = get_post_meta($post->ID, '_my_seo_twitter_card_type', true);

        if (!$twitter_title) {
            $twitter_title = $og_title;
        }

        if (!$twitter_description) {
            $twitter_description = $og_description;
        }

        if (!$twitter_image) {
            $twitter_image = $og_image;
        }

        if (!$twitter_card_type) {
            $twitter_card_type = get_option('my_seo_twitter_card_type', 'summary_large_image');
        }

        echo '<meta name="twitter:card" content="' . esc_attr($twitter_card_type) . '">' . "\n";
        echo '<meta name="twitter:title" content="' . esc_attr($twitter_title) . '">' . "\n";
        echo '<meta name="twitter:description" content="' . esc_attr($twitter_description) . '">' . "\n";

        if ($twitter_image) {
            echo '<meta name="twitter:image" content="' . esc_url($twitter_image) . '">' . "\n";
        }
    }
}
