#!/usr/bin/env python3
"""
Generate complete German (de_DE) translation .po file for SEO Fury WordPress plugin.
Reads the .pot template and produces a fully translated .po file.
"""

import re
import os
from datetime import datetime

SCRIPT_DIR = os.path.dirname(os.path.abspath(__file__))
POT_FILE = os.path.join(SCRIPT_DIR, "seo-fury.pot")
PO_FILE = os.path.join(SCRIPT_DIR, "seo-fury-de_DE.po")

# ──────────────────────────────────────────────────────────────────────
# Complete English → German translation dictionary
# ──────────────────────────────────────────────────────────────────────
TRANSLATIONS = {
    # ── Plugin meta ──────────────────────────────────────────────────
    "SEO Fury": "SEO Fury",
    "Complete SEO plugin with licensing, robots.txt, sitemaps, redirects, and IndexNow.":
        "Komplettes SEO-Plugin mit Lizenzierung, robots.txt, Sitemaps, Weiterleitungen und IndexNow.",
    "SEO Fury Team": "SEO Fury Team",

    # ── 404 Monitor Settings ────────────────────────────────────────
    "404 Monitor Settings": "404-Monitor-Einstellungen",
    "Enable Monitoring": "Überwachung aktivieren",
    "Ignore Bots": "Bots ignorieren",
    "Auto Cleanup": "Automatische Bereinigung",
    "Debug Logging": "Debug-Protokollierung",
    "Track and analyze 404 errors on your site.":
        "Verfolgen und analysieren Sie 404-Fehler auf Ihrer Website.",
    "Enable 404 tracking": "404-Verfolgung aktivieren",
    "Do not log requests from search bots":
        "Anfragen von Suchmaschinen-Bots nicht protokollieren",
    "Ignores Googlebot, Bingbot, Yandex, and other known bots.":
        "Ignoriert Googlebot, Bingbot, Yandex und andere bekannte Bots.",
    "days": "Tage",
    "Automatically delete entries older than this number of days. 0 = never delete":
        "Einträge automatisch löschen, die älter als diese Anzahl von Tagen sind. 0 = nie löschen",
    "Enable verbose logging for diagnostics":
        "Ausführliche Protokollierung für Diagnose aktivieren",
    "Writes detailed module logs to debug.log. Use for troubleshooting. Logs are in wp-content/debug.log (when WP_DEBUG_LOG is enabled).":
        "Schreibt detaillierte Modulprotokolle in debug.log. Verwenden Sie dies zur Fehlerbehebung. Protokolle befinden sich in wp-content/debug.log (wenn WP_DEBUG_LOG aktiviert ist).",

    # ── Common messages ─────────────────────────────────────────────
    "Insufficient permissions": "Unzureichende Berechtigungen",
    "Logs cleared": "Protokolle gelöscht",
    "URL is required": "URL ist erforderlich",
    "Invalid ID": "Ungültige ID",
    "Marked as resolved": "Als gelöst markiert",
    "Entry deleted": "Eintrag gelöscht",
    "Please fill in all fields": "Bitte füllen Sie alle Felder aus",
    "A redirect with this source already exists":
        "Eine Weiterleitung mit dieser Quelle existiert bereits",
    "Redirect created successfully!": "Weiterleitung erfolgreich erstellt!",
    "Error creating redirect: ": "Fehler beim Erstellen der Weiterleitung: ",

    # ── Table headers / labels ──────────────────────────────────────
    "URL": "URL",
    "Hits": "Aufrufe",
    "First Seen": "Erstmals gesehen",
    "Last Seen": "Zuletzt gesehen",
    "Status": "Status",
    "Resolved": "Gelöst",
    "Active": "Aktiv",
    "Loading...": "Laden...",
    "No redirects found": "Keine Weiterleitungen gefunden",
    "Inactive": "Inaktiv",
    "Activate": "Aktivieren",
    "Deactivate": "Deaktivieren",
    "Edit": "Bearbeiten",
    "Delete": "Löschen",
    "Adding...": "Hinzufügen...",
    "Deleting...": "Löschen...",
    "Saving...": "Speichern...",
    "Updating...": "Aktualisieren...",
    "Please fill all fields": "Bitte füllen Sie alle Felder aus",
    "Redirect added successfully!": "Weiterleitung erfolgreich hinzugefügt!",
    "Redirect deleted!": "Weiterleitung gelöscht!",
    "Redirect updated!": "Weiterleitung aktualisiert!",
    "Are you sure you want to delete this redirect?":
        "Sind Sie sicher, dass Sie diese Weiterleitung löschen möchten?",
    "Error loading redirects": "Fehler beim Laden der Weiterleitungen",
    "Error loading data": "Fehler beim Laden der Daten",
    "Error adding redirect": "Fehler beim Hinzufügen der Weiterleitung",
    "Error deleting redirect": "Fehler beim Löschen der Weiterleitung",
    "Error updating redirect": "Fehler beim Aktualisieren der Weiterleitung",
    "Error updating status": "Fehler beim Aktualisieren des Status",
    "Please select a CSV file.": "Bitte wählen Sie eine CSV-Datei aus.",
    "CSV import completed.": "CSV-Import abgeschlossen.",
    "Imported": "Importiert",
    "Updated": "Aktualisiert",
    "Skipped": "Übersprungen",
    "Upload failed.": "Hochladen fehlgeschlagen.",
    "Error": "Fehler",
    "An error occurred": "Ein Fehler ist aufgetreten",

    # ── IndexNow JS strings ─────────────────────────────────────────
    "Please enter at least one URL": "Bitte geben Sie mindestens eine URL ein",
    "No valid URLs found": "Keine gültigen URLs gefunden",
    "Maximum 10,000 URLs per request. You have:":
        "Maximal 10.000 URLs pro Anfrage. Sie haben:",
    "Sending...": "Senden...",
    "Sending in batches...": "Sende in Stapeln...",
    "Generating...": "Generieren...",
    "Checking...": "Überprüfen...",
    "Success!": "Erfolg!",
    "URLs sent:": "URLs gesendet:",
    "Error!": "Fehler!",
    "Unknown error": "Unbekannter Fehler",
    "Server connection error": "Server-Verbindungsfehler",
    "Settings saved": "Einstellungen gespeichert",
    "Save error": "Fehler beim Speichern",
    "Key generated!": "Schlüssel generiert!",
    "Verify key": "Schlüssel überprüfen",
    "No history yet": "Noch kein Verlauf",
    "Are you sure you want to clear the entire history?":
        "Sind Sie sicher, dass Sie den gesamten Verlauf löschen möchten?",
    "History cleared": "Verlauf gelöscht",
    "Clear failed": "Löschen fehlgeschlagen",
    "Sending batch": "Sende Stapel",
    "of": "von",
    "All batches sent successfully!": "Alle Stapel erfolgreich gesendet!",
    "Total URLs:": "URLs insgesamt:",
    "Batches:": "Stapel:",
    "Completed with errors": "Mit Fehlern abgeschlossen",
    "Errors:": "Fehler:",

    # ── License JS strings ──────────────────────────────────────────
    "Please enter a license key.": "Bitte geben Sie einen Lizenzschlüssel ein.",
    "Invalid key format.": "Ungültiges Schlüsselformat.",
    "Activating...": "Aktivieren...",
    "License activated! The page will reload...":
        "Lizenz aktiviert! Die Seite wird neu geladen...",
    "License activation failed": "Lizenzaktivierung fehlgeschlagen",
    "Activation server connection error": "Verbindungsfehler zum Aktivierungsserver",
    "Are you sure you want to deactivate the license?\n\nAll PRO features will be disabled.":
        "Sind Sie sicher, dass Sie die Lizenz deaktivieren möchten?\n\nAlle PRO-Funktionen werden deaktiviert.",
    "Deactivating...": "Deaktivieren...",
    "License deactivated. The page will reload...":
        "Lizenz deaktiviert. Die Seite wird neu geladen...",
    "Deactivation failed": "Deaktivierung fehlgeschlagen",
    "License is active and valid!": "Die Lizenz ist aktiv und gültig!",
    "Plan:": "Plan:",
    "Status:": "Status:",
    "Expires:": "Läuft ab:",
    "License is inactive or expired.": "Die Lizenz ist inaktiv oder abgelaufen.",
    "Could not reach the license server. Using local cache.":
        "Der Lizenzserver konnte nicht erreicht werden. Lokaler Cache wird verwendet.",
    "Key copied to clipboard!": "Schlüssel in die Zwischenablage kopiert!",
    "Click to copy": "Klicken zum Kopieren",

    # ── 404 Monitor page ────────────────────────────────────────────
    "Load error": "Ladefehler",
    "No 404 errors found": "Keine 404-Fehler gefunden",
    "Find": "Suchen",
    "Redirect": "Weiterleitung",
    "Resolve": "Lösen",
    "Are you sure? All 404 logs will be deleted!":
        "Sind Sie sicher? Alle 404-Protokolle werden gelöscht!",
    "Searching for similar pages...": "Suche nach ähnlichen Seiten...",
    "Found %d similar pages:": "%d ähnliche Seiten gefunden:",
    "Use this URL": "Diese URL verwenden",
    "No similar pages found": "Keine ähnlichen Seiten gefunden",
    "Please provide a target URL": "Bitte geben Sie eine Ziel-URL an",
    "Creating...": "Erstellen...",
    "Error creating redirect": "Fehler beim Erstellen der Weiterleitung",
    "Delete this entry?": "Diesen Eintrag löschen?",

    # ── Admin tabs / pages ──────────────────────────────────────────
    "General Settings": "Allgemeine Einstellungen",
    "Meta Titles": "Meta-Titel",
    "Robots.txt": "Robots.txt",
    "Sitemap": "Sitemap",
    "Breadcrumbs": "Breadcrumbs",
    "Local SEO": "Lokales SEO",
    "SSL & Security": "SSL & Sicherheit",
    "WooCommerce SEO": "WooCommerce SEO",
    "Redirects": "Weiterleitungen",
    "404 Monitor": "404-Monitor",
    "IndexNow": "IndexNow",
    "Changelog": "Änderungsprotokoll",
    "License": "Lizenz",
    "Version %s": "Version %s",

    # ── Internal Linking ────────────────────────────────────────────
    "Internal Linking": "Interne Verlinkung",
    "Scan your posts and pages for internal linking opportunities. The module analyzes your content and suggests relevant links to other published pages based on keyword and title matching.":
        "Scannen Sie Ihre Beiträge und Seiten nach internen Verlinkungsmöglichkeiten. Das Modul analysiert Ihre Inhalte und schlägt relevante Links zu anderen veröffentlichten Seiten basierend auf Keyword- und Titelübereinstimmung vor.",
    "Open any post or page in the editor and click the":
        "Öffnen Sie einen beliebigen Beitrag oder eine Seite im Editor und klicken Sie auf den",
    "Links": "Links",
    "tab in the SEO Fury sidebar.": "Tab in der SEO Fury-Seitenleiste.",
    "PRO Feature": "PRO-Funktion",
    "Available in all PRO plans. Upgrade to unlock smart internal linking suggestions in the post editor.":
        "In allen PRO-Plänen verfügbar. Upgraden Sie, um intelligente Vorschläge für interne Verlinkung im Beitragseditor freizuschalten.",
    "Upgrade": "Upgrade",

    # ── Sitemap links section ───────────────────────────────────────
    "Sitemap Links": "Sitemap-Links",
    "Index XML Sitemap:": "Index-XML-Sitemap:",
    "HTML Sitemap:": "HTML-Sitemap:",
    "You can also use the %s shortcode to display the HTML sitemap on any page.":
        "Sie können auch den %s-Shortcode verwenden, um die HTML-Sitemap auf jeder Seite anzuzeigen.",

    # ── Redirects page ──────────────────────────────────────────────
    "Create 301, 302 and 307 redirects. Track total hits.":
        "Erstellen Sie 301-, 302- und 307-Weiterleitungen. Verfolgen Sie die Gesamtaufrufe.",
    "Redirects used: %1$s of %2$s": "Verwendete Weiterleitungen: %1$s von %2$s",
    "You are nearing the FREE plan limit.":
        "Sie nähern sich dem Limit des FREE-Plans.",
    "PRO provides unlimited redirects.":
        "PRO bietet unbegrenzte Weiterleitungen.",
    "Upgrade to PRO": "Auf PRO upgraden",
    "Add a new redirect": "Neue Weiterleitung hinzufügen",
    "Source URL": "Quell-URL",
    "/old-page": "/alte-seite",
    "Relative path, e.g. %s": "Relativer Pfad, z. B. %s",
    "Target URL": "Ziel-URL",
    "/new-page": "/neue-seite",
    "Full URL or relative path": "Vollständige URL oder relativer Pfad",
    "Redirect Type": "Weiterleitungstyp",
    "301 (Permanent)": "301 (Permanent)",
    "302 (Temporary)": "302 (Temporär)",
    "307 (Temporary, preserves method)": "307 (Temporär, Methode bleibt erhalten)",
    "Add Redirect": "Weiterleitung hinzufügen",
    "Import / Export CSV": "CSV importieren / exportieren",
    "Export all redirects or import a CSV with columns: %s.":
        "Exportieren Sie alle Weiterleitungen oder importieren Sie eine CSV-Datei mit den Spalten: %s.",
    "Export CSV": "CSV exportieren",
    "Import CSV": "CSV importieren",
    "Redirects List": "Weiterleitungsliste",
    "ID": "ID",
    "Source": "Quelle",
    "Target": "Ziel",
    "Type": "Typ",
    "Created": "Erstellt",
    "Actions": "Aktionen",
    "Edit Redirect": "Weiterleitung bearbeiten",
    "Save Changes": "Änderungen speichern",

    # ── IndexNow page ───────────────────────────────────────────────
    "Submit URLs directly to the IndexNow API.":
        "URLs direkt an die IndexNow-API senden.",
    "Learn more": "Mehr erfahren",
    "Save Settings": "Einstellungen speichern",
    "Submit URLs": "URLs einreichen",
    "URLs to submit": "Einzureichende URLs",
    "Enter one URL per line...": "Geben Sie eine URL pro Zeile ein...",
    "Enter one URL per line. You can submit up to 10,000 URLs at once.":
        "Geben Sie eine URL pro Zeile ein. Sie können bis zu 10.000 URLs auf einmal einreichen.",
    "Submit to IndexNow": "An IndexNow senden",
    "Submission History": "Übermittlungsverlauf",
    "Last 100 IndexNow API requests.": "Die letzten 100 IndexNow-API-Anfragen.",
    "Load History": "Verlauf laden",
    "Clear History": "Verlauf löschen",
    "Time": "Zeit",
    "Response": "Antwort",
    "Method": "Methode",

    # ── 404 Monitor detail page ─────────────────────────────────────
    "404 logs used: %1$s of %2$s": "404-Protokolle verwendet: %1$s von %2$s",
    "PRO removes limits for 404 logging.":
        "PRO hebt die Limits für die 404-Protokollierung auf.",
    "Tracking 404 errors helps find broken links and create redirects.":
        "Das Verfolgen von 404-Fehlern hilft, defekte Links zu finden und Weiterleitungen zu erstellen.",
    "404 Statistics": "404-Statistiken",
    "Total URLs": "URLs insgesamt",
    "Total Hits": "Aufrufe insgesamt",
    "Refresh": "Aktualisieren",
    "Clear All": "Alle löschen",
    "Find a Similar Page": "Ähnliche Seite finden",
    "404 URL:": "404-URL:",
    "Create Redirect": "Weiterleitung erstellen",
    "Source (404 URL)": "Quelle (404-URL)",
    "Target (Target URL)": "Ziel (Ziel-URL)",

    # ── License page ────────────────────────────────────────────────
    "License Active": "Lizenz aktiv",
    "License Key:": "Lizenzschlüssel:",
    "Free": "Kostenlos",
    "Pro Starter": "Pro Starter",
    "Pro Business": "Pro Business",
    "Pro Agency": "Pro Agency",
    "Lifetime": "Lebenslang",
    "Unknown": "Unbekannt",
    "Domain:": "Domain:",
    "Available Features:": "Verfügbare Funktionen:",
    "Advanced SEO": "Erweitertes SEO",
    "Advanced SEO features": "Erweiterte SEO-Funktionen",
    "Not available on your plan": "In Ihrem Plan nicht verfügbar",
    "Unlimited redirects": "Unbegrenzte Weiterleitungen",
    "Limited to 50": "Begrenzt auf 50",
    "Unlimited 404 logs": "Unbegrenzte 404-Protokolle",
    "404 Logs": "404-Protokolle",
    "Limited to 100": "Begrenzt auf 100",
    "Smart link suggestions": "Intelligente Link-Vorschläge",
    "White Label": "White Label",
    "Branding": "Branding",
    "Not available": "Nicht verfügbar",
    "Priority Support": "Prioritäts-Support",
    "Priority support": "Prioritäts-Support",
    "Support": "Support",
    "Standard support": "Standard-Support",
    "Priority support is active": "Prioritäts-Support ist aktiv",
    "Reply within 24 hours": "Antwort innerhalb von 24 Stunden",
    "Direct line to developers": "Direkter Draht zu den Entwicklern",
    "Help with setup and optimization": "Hilfe bei Einrichtung und Optimierung",
    "Deactivate License": "Lizenz deaktivieren",
    "Check Status": "Status prüfen",
    "License Not Activated": "Lizenz nicht aktiviert",
    "Enter a license key to activate plugin features.":
        "Geben Sie einen Lizenzschlüssel ein, um die Plugin-Funktionen zu aktivieren.",
    "Supported formats:": "Unterstützte Formate:",
    "License Key": "Lizenzschlüssel",
    "PRO format: %s": "PRO-Format: %s",
    "FREE format: %s": "FREE-Format: %s",
    "Activate License": "Lizenz aktivieren",
    "Available plans:": "Verfügbare Pläne:",
    "%s domain": "%s Domain",
    "%s redirects": "%s Weiterleitungen",
    "%s 404 logs": "%s 404-Protokolle",
    "month": "Monat",
    "%s domains": "%s Domains",
    "Everything in Starter +": "Alles aus Starter +",
    "Unlimited domains": "Unbegrenzte Domains",
    "Everything in Business +": "Alles aus Business +",
    "All pro features": "Alle Pro-Funktionen",
    "one-time": "einmalig",
    "All features forever": "Alle Funktionen für immer",
    "Lifetime updates": "Lebenslange Updates",
    "Buy a license": "Lizenz kaufen",

    # ── SSL / HTTPS Security ────────────────────────────────────────
    "SSL / HTTPS Security": "SSL / HTTPS-Sicherheit",
    "Protect your site with HTTPS enforcement, mixed content fixes, and security headers.":
        "Schützen Sie Ihre Website mit HTTPS-Erzwingung, Behebung gemischter Inhalte und Sicherheits-Headern.",
    "SSL Certificate": "SSL-Zertifikat",
    "Not detected": "Nicht erkannt",
    "HTTPS Redirect": "HTTPS-Weiterleitung",
    "Enabled": "Aktiviert",
    "Disabled": "Deaktiviert",
    "Mixed Content": "Gemischte Inhalte",
    "Auto-fix on": "Automatische Korrektur ein",
    "Not active": "Nicht aktiv",
    "HSTS Header": "HSTS-Header",
    "Save Security Settings": "Sicherheitseinstellungen speichern",

    # ── Changelog ───────────────────────────────────────────────────
    "All updates and improvements for the plugin":
        "Alle Updates und Verbesserungen für das Plugin",
    "Current version": "Aktuelle Version",
    "Unable to load changelog. Please check your internet connection.":
        "Änderungsprotokoll konnte nicht geladen werden. Bitte überprüfen Sie Ihre Internetverbindung.",
    "Retry": "Erneut versuchen",

    # ── Breadcrumbs ─────────────────────────────────────────────────
    "Enable Breadcrumbs": "Breadcrumbs aktivieren",
    "Show Home Link": "Startseiten-Link anzeigen",
    "Home Label": "Startseiten-Bezeichnung",
    "Home URL": "Startseiten-URL",
    "Breadcrumb Prefix": "Breadcrumb-Präfix",
    "Separator": "Trennzeichen",
    "Archive Format": "Archiv-Format",
    "404 Label": "404-Bezeichnung",
    "Hide Post Title": "Beitragstitel verbergen",
    "Show Categories": "Kategorien anzeigen",
    "Hide Taxonomy Name": "Taxonomie-Name verbergen",
    "How to display breadcrumbs": "So zeigen Sie Breadcrumbs an",
    "Use this PHP snippet in your theme template:":
        "Verwenden Sie dieses PHP-Snippet in Ihrem Theme-Template:",
    "Or use shortcode:": "Oder verwenden Sie den Shortcode:",
    "Enable and configure breadcrumbs for your site.":
        "Aktivieren und konfigurieren Sie Breadcrumbs für Ihre Website.",
    "Show breadcrumbs output": "Breadcrumbs-Ausgabe anzeigen",
    "Show link to the homepage": "Link zur Startseite anzeigen",
    "Home": "Startseite",
    "The label used for the homepage link (the first item) in breadcrumb trails.":
        "Die Bezeichnung, die für den Startseiten-Link (das erste Element) in Breadcrumb-Pfaden verwendet wird.",
    "The homepage link (the first item) in breadcrumb trails. Leave empty to use the default homepage URL.":
        "Der Startseiten-Link (das erste Element) in Breadcrumb-Pfaden. Lassen Sie das Feld leer, um die Standard-Startseiten-URL zu verwenden.",
    "An element displayed before the breadcrumb trail.":
        "Ein Element, das vor dem Breadcrumb-Pfad angezeigt wird.",
    "Custom": "Benutzerdefiniert",
    "Enter custom separator": "Benutzerdefiniertes Trennzeichen eingeben",
    'Search results for "%s"': 'Suchergebnisse für „%s"',
    "Format the label used for search results pages. Use %s as a placeholder for the search query.":
        "Formatieren Sie die Bezeichnung für Suchergebnisseiten. Verwenden Sie %s als Platzhalter für die Suchanfrage.",
    "Page not found": "Seite nicht gefunden",
    "The label used for the 404 error page in breadcrumb trails.":
        "Die Bezeichnung, die für die 404-Fehlerseite in Breadcrumb-Pfaden verwendet wird.",
    "Hide the post title in the breadcrumb trail":
        "Den Beitragstitel im Breadcrumb-Pfad verbergen",
    "If a category is a child, display all parent categories":
        "Wenn eine Kategorie untergeordnet ist, alle übergeordneten Kategorien anzeigen",
    "Hide the taxonomy name in the breadcrumb trail":
        "Den Taxonomie-Namen im Breadcrumb-Pfad verbergen",

    # ── Core ────────────────────────────────────────────────────────
    "Plugin files have been modified. PRO features disabled for security.":
        "Plugin-Dateien wurden verändert. PRO-Funktionen wurden aus Sicherheitsgründen deaktiviert.",

    # ── General SEO Settings ────────────────────────────────────────
    "General SEO Settings": "Allgemeine SEO-Einstellungen",
    "Settings": "Einstellungen",
    "URL Transliteration": "URL-Transliteration",
    "Enable White Label": "White Label aktivieren",
    "Plugin Name": "Plugin-Name",
    "Hide Branding Links": "Branding-Links verbergen",
    "Bulk URL Conversion": "Massen-URL-Konvertierung",
    "Force HTTPS": "HTTPS erzwingen",
    "Fix Mixed Content": "Gemischte Inhalte beheben",
    "WWW Redirect": "WWW-Weiterleitung",
    "Configure the main SEO settings for your site.":
        "Konfigurieren Sie die wichtigsten SEO-Einstellungen für Ihre Website.",
    "Enable automatic transliteration for non-Latin URLs":
        "Automatische Transliteration für nicht-lateinische URLs aktivieren",
    "Automatically converts non-Latin characters to Latin in post and page URLs.":
        "Konvertiert automatisch nicht-lateinische Zeichen in lateinische Zeichen in Beitrags- und Seiten-URLs.",
    "Insufficient permissions.": "Unzureichende Berechtigungen.",
    "Convert existing non-Latin URLs to Latin slugs.":
        "Vorhandene nicht-lateinische URLs in lateinische Slugs umwandeln.",
    "Loading stats...": "Statistiken werden geladen...",
    "Posts": "Beiträge",
    "Pages": "Seiten",
    "Refresh Stats": "Statistiken aktualisieren",
    "Convert URLs": "URLs konvertieren",
    "URL stats:": "URL-Statistiken:",
    "Total:": "Gesamt:",
    "Non-Latin:": "Nicht-Lateinisch:",
    "Latin:": "Lateinisch:",
    "Are you sure? This will change URLs for all posts with non-Latin slugs.":
        "Sind Sie sicher? Dies ändert die URLs für alle Beiträge mit nicht-lateinischen Slugs.",
    "We recommend backing up the database first.":
        "Wir empfehlen, zunächst die Datenbank zu sichern.",
    "Converting...": "Konvertieren...",
    "Conversion completed!": "Konvertierung abgeschlossen!",
    "Updated:": "Aktualisiert:",
    "Skipped (already Latin):": "Übersprungen (bereits lateinisch):",
    "Total checked:": "Insgesamt geprüft:",
    "Error:": "Fehler:",
    "Configure HTTPS enforcement, HSTS headers, and WWW redirect.":
        "Konfigurieren Sie die HTTPS-Erzwingung, HSTS-Header und WWW-Weiterleitung.",
    "Redirect all HTTP requests to HTTPS (301)":
        "Alle HTTP-Anfragen auf HTTPS umleiten (301)",
    "Requires a valid SSL certificate installed on your server.":
        "Erfordert ein gültiges SSL-Zertifikat auf Ihrem Server.",
    "Automatically replace HTTP with HTTPS in page output":
        "HTTP automatisch durch HTTPS in der Seitenausgabe ersetzen",
    "Fixes mixed content warnings by rewriting internal HTTP URLs to HTTPS on the frontend.":
        "Behebt Warnungen zu gemischten Inhalten, indem interne HTTP-URLs im Frontend in HTTPS umgeschrieben werden.",
    "Send Strict-Transport-Security header":
        "Strict-Transport-Security-Header senden",
    "Max-Age (seconds):": "Max-Age (Sekunden):",
    "Default: 31536000 (1 year)": "Standard: 31536000 (1 Jahr)",
    "Tells browsers to always use HTTPS for this domain. Only enable if SSL is fully configured.":
        "Weist Browser an, für diese Domain immer HTTPS zu verwenden. Nur aktivieren, wenn SSL vollständig konfiguriert ist.",
    "No redirect": "Keine Weiterleitung",
    "Force www (redirect non-www to www)":
        "www erzwingen (non-www auf www umleiten)",
    "Force non-www (redirect www to non-www)":
        "non-www erzwingen (www auf non-www umleiten)",
    "Enforce a canonical www or non-www version of your domain (301 redirect).":
        "Erzwingen Sie eine kanonische www- oder non-www-Version Ihrer Domain (301-Weiterleitung).",

    # ── White Label ─────────────────────────────────────────────────
    "White Label is a PRO feature": "White Label ist eine PRO-Funktion",
    "Rename the plugin and remove branding. Perfect for agencies and resellers.":
        "Benennen Sie das Plugin um und entfernen Sie das Branding. Perfekt für Agenturen und Wiederverkäufer.",
    "Customize the plugin branding for your product.":
        "Passen Sie das Plugin-Branding für Ihr Produkt an.",
    "Enable white label": "White Label aktivieren",
    "When enabled, the plugin name changes across the admin UI.":
        "Wenn aktiviert, ändert sich der Plugin-Name in der gesamten Admin-Oberfläche.",
    "New plugin name used across the UI.":
        "Neuer Plugin-Name, der in der gesamten Oberfläche verwendet wird.",
    "Hide all branding links": "Alle Branding-Links verbergen",
    "Removes upgrade links and branding references.":
        "Entfernt Upgrade-Links und Branding-Verweise.",

    # ── IndexNow Settings ───────────────────────────────────────────
    "IndexNow Settings": "IndexNow-Einstellungen",
    "IndexNow API Key": "IndexNow-API-Schlüssel",
    "Search Engine": "Suchmaschine",
    "Automatic Submission": "Automatische Übermittlung",
    "Submit on Delete": "Bei Löschung senden",
    "Instant indexing module settings.": "Einstellungen für das Sofort-Indexierungsmodul.",
    "Generate Key": "Schlüssel generieren",
    "Verify Key": "Schlüssel überprüfen",
    "API key for IndexNow. It will be saved in the site root.":
        "API-Schlüssel für IndexNow. Er wird im Stammverzeichnis der Website gespeichert.",
    "IndexNow (all search engines)": "IndexNow (alle Suchmaschinen)",
    "Bing": "Bing",
    "Yandex": "Yandex",
    "Seznam": "Seznam",
    "Select the search engine to notify.":
        "Wählen Sie die zu benachrichtigende Suchmaschine aus.",
    "Automatically submit URLs on publish/update":
        "URLs automatisch beim Veröffentlichen/Aktualisieren senden",
    "Automatically notify on deletion":
        "Automatisch bei Löschung benachrichtigen",
    "Please provide URLs to submit": "Bitte geben Sie URLs zum Einreichen an",
    "No valid URLs provided": "Keine gültigen URLs angegeben",
    "Submission completed": "Übermittlung abgeschlossen",
    "Failed to create key file. Check permissions.":
        "Schlüsseldatei konnte nicht erstellt werden. Überprüfen Sie die Berechtigungen.",
    "API key is not configured": "API-Schlüssel ist nicht konfiguriert",
    "Key file not found on the server": "Schlüsseldatei nicht auf dem Server gefunden",
    "Key file content does not match": "Inhalt der Schlüsseldatei stimmt nicht überein",
    "Failed to check file availability: %s":
        "Dateiverfügbarkeit konnte nicht überprüft werden: %s",
    "Key file is not accessible via URL (code: %d)":
        "Schlüsseldatei ist nicht über URL erreichbar (Code: %d)",
    "Key file content via URL does not match":
        "Inhalt der Schlüsseldatei über URL stimmt nicht überein",
    "Key verified successfully!": "Schlüssel erfolgreich verifiziert!",
    "Failed to clear history": "Verlauf konnte nicht gelöscht werden",
    "URL sent successfully": "URL erfolgreich gesendet",
    "Error: %d": "Fehler: %d",

    # ── License class ───────────────────────────────────────────────
    "Invalid license key format": "Ungültiges Lizenzschlüsselformat",
    "Error: invalid API response format": "Fehler: Ungültiges API-Antwortformat",
    "License activated successfully!": "Lizenz erfolgreich aktiviert!",
    "License deactivated": "Lizenz deaktiviert",
    "Invalid response": "Ungültige Antwort",
    "License key is required": "Lizenzschlüssel ist erforderlich",
    "Invalid response format": "Ungültiges Antwortformat",
    "License activated": "Lizenz aktiviert",
    "Activation failed": "Aktivierung fehlgeschlagen",

    # ── Local SEO ───────────────────────────────────────────────────
    "Enable Local SEO": "Lokales SEO aktivieren",
    "Business Type": "Unternehmenstyp",
    "Business Name": "Unternehmensname",
    "Phone": "Telefon",
    "Email": "E-Mail",
    "Logo URL": "Logo-URL",
    "Image URL": "Bild-URL",
    "Price Range": "Preisbereich",
    "Street Address": "Straße",
    "City": "Stadt",
    "Region/State": "Region/Bundesland",
    "Postal Code": "Postleitzahl",
    "Country": "Land",
    "Latitude": "Breitengrad",
    "Longitude": "Längengrad",
    "Opening Hours": "Öffnungszeiten",
    "Configure your local business details for Local SEO schema.":
        "Konfigurieren Sie Ihre lokalen Geschäftsdaten für das Local-SEO-Schema.",
    "Output LocalBusiness schema on the frontend":
        "LocalBusiness-Schema im Frontend ausgeben",
    "Example: LocalBusiness, Store, Restaurant, MedicalBusiness":
        "Beispiel: LocalBusiness, Store, Restaurant, MedicalBusiness",
    'One line per rule, e.g. "Mo-Fr 09:00-18:00"':
        'Eine Zeile pro Regel, z. B. „Mo-Fr 09:00-18:00"',

    # ── Meta Titles ─────────────────────────────────────────────────
    "Robots Meta": "Robots-Meta",
    "Robots Meta Tags": "Robots-Meta-Tags",
    "Advanced Robots Meta": "Erweiterte Robots-Meta",
    "Snippet": "Snippet",
    "Video Preview": "Videovorschau",
    "Image Preview Size": "Bildvorschau-Größe",
    "Noindex Empty Archives": "Leere Archive auf Noindex setzen",
    "Empty Archives": "Leere Archive",
    "Title Settings": "Titel-Einstellungen",
    "Title Separator": "Titel-Trennzeichen",
    "Capitalize Titles": "Titel großschreiben",
    "Twitter Card": "Twitter Card",
    "Content Type Templates": "Inhaltstyp-Vorlagen",
    "Templates": "Vorlagen",
    "Twitter Card Type": "Twitter-Card-Typ",
    "Default values for the robots meta tag.":
        "Standardwerte für das Robots-Meta-Tag.",
    "Important:": "Wichtig:",
    "Do not enable %1$s and %2$s at the same time. If both are enabled, %2$s takes priority.":
        "Aktivieren Sie nicht %1$s und %2$s gleichzeitig. Wenn beide aktiviert sind, hat %2$s Vorrang.",
    "Index": "Index",
    "Allow search engines to index and show these pages in results":
        "Suchmaschinen erlauben, diese Seiten zu indexieren und in den Ergebnissen anzuzeigen",
    "NoIndex": "NoIndex",
    "Prevent indexing and showing pages in search results":
        "Indexierung und Anzeige von Seiten in den Suchergebnissen verhindern",
    "NoFollow": "NoFollow",
    "Prevent search engines from following links on the page":
        "Suchmaschinen daran hindern, Links auf der Seite zu folgen",
    "NoArchive": "NoArchive",
    "Prevent cached links in search results":
        "Zwischengespeicherte Links in den Suchergebnissen verhindern",
    "NoImageIndex": "NoImageIndex",
    "Prevent indexing page images by search engines":
        "Indexierung von Seitenbildern durch Suchmaschinen verhindern",
    "NoSnippet": "NoSnippet",
    "Prevents displaying snippets in search results":
        "Verhindert die Anzeige von Snippets in den Suchergebnissen",
    "Additional settings to control content appearance in search results.":
        "Zusätzliche Einstellungen zur Steuerung der Inhaltsdarstellung in den Suchergebnissen.",
    "characters": "Zeichen",
    "Set the maximum snippet length in characters.":
        "Legen Sie die maximale Snippet-Länge in Zeichen fest.",
    "means unlimited.": "bedeutet unbegrenzt.",
    "disables snippets.": "deaktiviert Snippets.",
    "seconds": "Sekunden",
    "Set the maximum video preview length in seconds.":
        "Legen Sie die maximale Videovorschau-Länge in Sekunden fest.",
    "disables video previews.": "deaktiviert Videovorschauen.",
    "None": "Keine",
    "Standard": "Standard",
    "Large": "Groß",
    "Set the maximum image preview size for images on this page.":
        "Legen Sie die maximale Bildvorschau-Größe für Bilder auf dieser Seite fest.",
    "disables image previews.": "deaktiviert Bildvorschauen.",
    "are standard limits.": "sind Standard-Limits.",
    "Adding noindex for empty archives helps avoid indexing empty pages.":
        "Das Hinzufügen von noindex für leere Archive hilft, die Indexierung leerer Seiten zu vermeiden.",
    "Add %s for empty category and tag archives":
        "%s für leere Kategorie- und Schlagwort-Archive hinzufügen",
    "When a post is added, the archive switches back to %s.":
        "Wenn ein Beitrag hinzugefügt wird, wechselt das Archiv zurück zu %s.",
    "Configure how page titles are displayed on your site.":
        "Konfigurieren Sie, wie Seitentitel auf Ihrer Website angezeigt werden.",
    "Use the separator in title templates with %1$s or %2$s.":
        "Verwenden Sie das Trennzeichen in Titelvorlagen mit %1$s oder %2$s.",
    "Preview:": "Vorschau:",
    "Page title": "Seitentitel",
    "Site name": "Website-Name",
    "Automatically capitalize each word in titles":
        "Jedes Wort in Titeln automatisch großschreiben",
    'Example: "%1$s" → "%2$s"': 'Beispiel: „%1$s" → „%2$s"',
    "Configure the Twitter card type for your pages.":
        "Konfigurieren Sie den Twitter-Card-Typ für Ihre Seiten.",
    "Summary with large image": "Zusammenfassung mit großem Bild",
    "Summary": "Zusammenfassung",
    "This card type is used for new posts and for posts without a selected card type.":
        "Dieser Card-Typ wird für neue Beiträge und für Beiträge ohne ausgewählten Card-Typ verwendet.",
    "Set default title and description templates for each content type.":
        "Legen Sie Standard-Titel- und Beschreibungsvorlagen für jeden Inhaltstyp fest.",
    "Available variables:": "Verfügbare Variablen:",
    "Content Type": "Inhaltstyp",
    "Title Template": "Titelvorlage",
    "Description Template": "Beschreibungsvorlage",
    "General Meta": "Allgemeine Meta",
    "Authors": "Autoren",
    "Misc Pages": "Sonstige Seiten",
    "Taxonomies": "Taxonomien",
    "Post Types": "Beitragstypen",
    "Homepage Title": "Startseiten-Titel",
    "Homepage Description": "Startseiten-Beschreibung",
    "Author Archive Title": "Autoren-Archiv-Titel",
    "Author Archive Description": "Autoren-Archiv-Beschreibung",
    "Blog Page Title": "Blog-Seiten-Titel",
    "Blog Page Description": "Blog-Seiten-Beschreibung",
    "Search Results Title": "Suchergebnis-Titel",
    "Search Results Description": "Suchergebnis-Beschreibung",
    "Date Archive Title": "Datumsarchiv-Titel",
    "Date Archive Description": "Datumsarchiv-Beschreibung",
    "404 Title": "404-Titel",
    "404 Description": "404-Beschreibung",
    "%s Title": "%s-Titel",
    "%s Description": "%s-Beschreibung",
    "Page Not Found": "Seite nicht gefunden",

    # ── Post Meta Basic ─────────────────────────────────────────────
    "Google Preview": "Google-Vorschau",
    "Edit Snippet": "Snippet bearbeiten",
    "Focus Keyword": "Fokus-Keyword",
    "e.g. Rank Math SEO": "z. B. Rank Math SEO",
    "Basic SEO": "Basis-SEO",
    "Keyword Density:": "Keyword-Dichte:",
    "Readability": "Lesbarkeit",
    "Readability:": "Lesbarkeit:",
    "Additional SEO": "Zusätzliches SEO",
    "Extra on-page checks to improve visibility.":
        "Zusätzliche On-Page-Prüfungen zur Verbesserung der Sichtbarkeit.",
    "These settings override global robots meta for this page":
        "Diese Einstellungen überschreiben die globalen Robots-Meta-Einstellungen für diese Seite",
    "Prevent indexing of this page": "Indexierung dieser Seite verhindern",
    "Prevent following links": "Link-Verfolgung verhindern",
    "Prevent cached copy": "Zwischengespeicherte Kopie verhindern",
    "Prevent snippet display": "Snippet-Anzeige verhindern",
    "Prevent image indexing": "Bildindexierung verhindern",
    "Max Snippet": "Max. Snippet",
    "Text length (-1 = unlimited)": "Textlänge (-1 = unbegrenzt)",
    "Max Video Preview": "Max. Videovorschau",
    "Video length in seconds": "Videolänge in Sekunden",
    "Max Image Preview": "Max. Bildvorschau",
    "Default": "Standard",
    "Preview size": "Vorschaugröße",
    "Canonical URL": "Kanonische URL",
    "Defaults to current page URL": "Standardmäßig die aktuelle Seiten-URL",

    # ── Post Meta Schema ────────────────────────────────────────────
    "Article": "Artikel",
    "Blog Posting": "Blogbeitrag",
    "News Article": "Nachrichtenartikel",
    "Product": "Produkt",
    "Review": "Bewertung",
    "Recipe": "Rezept",
    "FAQ Page": "FAQ-Seite",
    "How To": "Anleitung",
    "BreadcrumbList": "BreadcrumbList",
    "Table": "Tabelle",
    "Service": "Dienstleistung",
    "Job Posting": "Stellenanzeige",
    "Course": "Kurs",
    "Event": "Veranstaltung",
    "Local Business": "Lokales Unternehmen",
    "Organization": "Organisation",
    "Person": "Person",
    "Video Object": "Video-Objekt",
    "Book": "Buch",
    "Software Application": "Softwareanwendung",
    "Used Schema": "Verwendetes Schema",
    "Custom JSON-LD": "Benutzerdefiniertes JSON-LD",
    "Preview": "Vorschau",
    "Remove": "Entfernen",
    "No schema selected yet. Use Schema Generator to apply.":
        "Noch kein Schema ausgewählt. Verwenden Sie den Schema-Generator zum Anwenden.",
    "Schema Generator": "Schema-Generator",
    "Schema Templates": "Schema-Vorlagen",
    "Import": "Importieren",
    "No schema selected. Choose a template or import JSON-LD.":
        "Kein Schema ausgewählt. Wählen Sie eine Vorlage oder importieren Sie JSON-LD.",
    "Available Schema Types": "Verfügbare Schema-Typen",
    "Apply": "Anwenden",
    "Schema Settings": "Schema-Einstellungen",
    "Schema JSON-LD Preview": "Schema-JSON-LD-Vorschau",
    "Import JSON-LD": "JSON-LD importieren",
    "Paste JSON-LD": "JSON-LD einfügen",
    "Paste valid JSON-LD without the %s tag":
        "Gültiges JSON-LD ohne das %s-Tag einfügen",
    "Apply JSON-LD": "JSON-LD anwenden",
    "Custom JSON-LD Preview": "Benutzerdefinierte JSON-LD-Vorschau",
    "Done": "Fertig",
    "Schema fields for this type will be available soon. You can manually add schema using the JSON-LD editor above.":
        "Schema-Felder für diesen Typ werden bald verfügbar sein. Sie können Schema manuell über den JSON-LD-Editor oben hinzufügen.",

    # ── Article Schema ──────────────────────────────────────────────
    "Article Schema Details": "Artikel-Schema-Details",
    "Headline": "Überschrift",
    "Article headline (defaults to post title)":
        "Artikelüberschrift (standardmäßig der Beitragstitel)",
    "Author Name": "Autorenname",
    "Author of the article": "Autor des Artikels",
    "Publisher Name": "Herausgebername",
    "Publisher organization name": "Name der Herausgeberorganisation",
    "Publisher Logo URL": "Herausgeber-Logo-URL",
    "URL of publisher's logo (recommended: 600x60px)":
        "URL des Herausgeber-Logos (empfohlen: 600x60px)",
    "Featured Image URL": "Beitragsbildurl",
    "Main image for the article": "Hauptbild des Artikels",
    "Date Published": "Veröffentlichungsdatum",
    "When was this article published?": "Wann wurde dieser Artikel veröffentlicht?",
    "Date Modified": "Änderungsdatum",
    "Last modification date": "Datum der letzten Änderung",

    # ── Product Schema ──────────────────────────────────────────────
    "Product Schema Details": "Produkt-Schema-Details",
    "Product Name": "Produktname",
    "Price": "Preis",
    "Currency": "Währung",
    "Availability": "Verfügbarkeit",
    "In Stock": "Auf Lager",
    "Out of Stock": "Nicht auf Lager",
    "Pre Order": "Vorbestellung",
    "Brand": "Marke",
    "SKU": "SKU",

    # ── FAQ Schema ──────────────────────────────────────────────────
    "FAQ Schema Details": "FAQ-Schema-Details",
    "Add frequently asked questions and their answers":
        "Häufig gestellte Fragen und deren Antworten hinzufügen",
    "Question %d": "Frage %d",
    "What is your question?": "Wie lautet Ihre Frage?",
    "Answer": "Antwort",
    "Type the answer here...": "Geben Sie hier die Antwort ein...",
    "Add FAQ Item": "FAQ-Eintrag hinzufügen",

    # ── How-To Schema ───────────────────────────────────────────────
    "How-To Schema Details": "Anleitung-Schema-Details",
    "Guide Name": "Anleitungsname",
    "Description": "Beschreibung",
    "Steps": "Schritte",
    "Step %d Name": "Schritt %d Name",
    "Step Description": "Schrittbeschreibung",
    "Remove Step": "Schritt entfernen",
    "Add Step": "Schritt hinzufügen",

    # ── Review Schema ───────────────────────────────────────────────
    "Review Schema Details": "Bewertung-Schema-Details",
    "Item Reviewed": "Bewerteter Gegenstand",
    "Rating (1-5)": "Bewertung (1-5)",
    "Reviewer Name": "Name des Bewerters",
    "Review Date": "Bewertungsdatum",

    # ── Recipe Schema ───────────────────────────────────────────────
    "Recipe Schema Details": "Rezept-Schema-Details",
    "Recipe Name": "Rezeptname",
    "Prep Time (minutes)": "Vorbereitungszeit (Minuten)",
    "Cook Time (minutes)": "Kochzeit (Minuten)",
    "Servings": "Portionen",
    "4 servings": "4 Portionen",
    "Calories": "Kalorien",
    "Ingredients (one per line)": "Zutaten (eine pro Zeile)",
    "Instructions": "Zubereitung",

    # ── Event Schema ────────────────────────────────────────────────
    "Event Schema Details": "Veranstaltung-Schema-Details",
    "Event Name": "Veranstaltungsname",
    "Start Date & Time": "Startdatum & Uhrzeit",
    "End Date & Time": "Enddatum & Uhrzeit",
    "Location Name": "Ortsname",
    "Address": "Adresse",

    # ── Video Schema ────────────────────────────────────────────────
    "Video Schema Details": "Video-Schema-Details",
    "Video Title": "Videotitel",
    "Video URL": "Video-URL",
    "Thumbnail URL": "Vorschaubild-URL",
    "Upload Date": "Hochladedatum",
    "Duration (ISO 8601)": "Dauer (ISO 8601)",
    "Format: PT1H30M (1 hour 30 minutes)": "Format: PT1H30M (1 Stunde 30 Minuten)",

    # ── BreadcrumbList Schema ───────────────────────────────────────
    "BreadcrumbList Details": "BreadcrumbList-Details",
    "Enter one breadcrumb per line: Label | URL":
        "Geben Sie einen Breadcrumb pro Zeile ein: Bezeichnung | URL",

    # ── Table Schema ────────────────────────────────────────────────
    "Table Schema Details": "Tabellen-Schema-Details",
    "Table Name": "Tabellenname",
    "Rows": "Zeilen",
    "Use one row per line, columns separated by |":
        "Eine Zeile pro Reihe verwenden, Spalten getrennt durch |",

    # ── Service Schema ──────────────────────────────────────────────
    "Service Schema Details": "Dienstleistung-Schema-Details",
    "Service Name": "Dienstleistungsname",
    "Provider Name": "Anbietername",
    "Area Served": "Versorgungsgebiet",
    "Service Type": "Dienstleistungstyp",

    # ── Job Posting Schema ──────────────────────────────────────────
    "Job Posting Details": "Stellenanzeige-Details",
    "Job Title": "Stellenbezeichnung",
    "Date Posted": "Veröffentlichungsdatum",
    "Valid Through": "Gültig bis",
    "Employment Type": "Beschäftigungsart",
    "Full-time": "Vollzeit",
    "Hiring Organization": "Einstellende Organisation",
    "Job Location": "Arbeitsort",
    "City, Country": "Stadt, Land",

    # ── Social Preview / Post Meta Social ───────────────────────────
    "Social Preview": "Soziale Vorschau",
    "Facebook": "Facebook",
    "Twitter": "Twitter",
    "Facebook user": "Facebook-Nutzer",
    "2 hours ago": "Vor 2 Stunden",
    "FB Preview": "FB-Vorschau",
    "Twitter user": "Twitter-Nutzer",
    "2 hours": "2 Stunden",
    "Post with a link!": "Beitrag mit einem Link!",
    "Twitter Preview": "Twitter-Vorschau",
    "Social Settings": "Soziale Einstellungen",
    "All Networks": "Alle Netzwerke",
    "Title": "Titel",
    "Title for all networks": "Titel für alle Netzwerke",
    "Description for all networks": "Beschreibung für alle Netzwerke",
    "Image": "Bild",
    "Choose Image": "Bild auswählen",
    "Values apply to Facebook and Twitter":
        "Werte gelten für Facebook und Twitter",
    "Facebook Title": "Facebook-Titel",
    "Post title": "Beitragstitel",
    "SEO title": "SEO-Titel",
    "Separator —": "Trennzeichen —",
    "Category": "Kategorie",
    "Publish date": "Veröffentlichungsdatum",
    "Facebook Image": "Facebook-Bild",
    "Facebook Description": "Facebook-Beschreibung",
    "Post excerpt": "Beitragsauszug",
    "SEO description": "SEO-Beschreibung",
    "Site description": "Website-Beschreibung",
    "Twitter Title": "Twitter-Titel",
    "Summary Large Image": "Zusammenfassung großes Bild",
    "Twitter Description": "Twitter-Beschreibung",
    "Twitter Image": "Twitter-Bild",
    "OG Title": "OG-Titel",
    "OG Type": "OG-Typ",
    "Website": "Website",
    "Video": "Video",
    "OG Description": "OG-Beschreibung",
    "Product short description": "Produkt-Kurzbeschreibung",
    "OG Image": "OG-Bild",
    "Select image": "Bild auswählen",
    "Facebook Preview": "Facebook-Vorschau",
    "2h": "2 Std.",
    "Facebook Settings": "Facebook-Einstellungen",
    "Twitter (X) Settings": "Twitter (X)-Einstellungen",

    # ── Post Meta checks ────────────────────────────────────────────
    "Focus keyword is set": "Fokus-Keyword ist gesetzt",
    "Add a focus keyword": "Fokus-Keyword hinzufügen",
    "Focus keyword in SEO title": "Fokus-Keyword im SEO-Titel",
    "Add focus keyword to SEO title": "Fokus-Keyword zum SEO-Titel hinzufügen",
    "Focus keyword in meta description": "Fokus-Keyword in der Meta-Beschreibung",
    "Add focus keyword to meta description":
        "Fokus-Keyword zur Meta-Beschreibung hinzufügen",
    "Focus keyword in content": "Fokus-Keyword im Inhalt",
    "Add focus keyword to content": "Fokus-Keyword zum Inhalt hinzufügen",
    "Focus keyword in URL": "Fokus-Keyword in der URL",
    "Add focus keyword to URL": "Fokus-Keyword zur URL hinzufügen",
    "Keyword density is OK (0.5–2.5%)": "Keyword-Dichte ist in Ordnung (0,5–2,5 %)",
    "Keyword density out of range (0.5–2.5%)":
        "Keyword-Dichte außerhalb des Bereichs (0,5–2,5 %)",
    "SEO title length is OK (50–60)": "SEO-Titellänge ist in Ordnung (50–60)",
    "Optimize SEO title length (50–60)": "SEO-Titellänge optimieren (50–60)",
    "Meta description length is OK (120–160)":
        "Meta-Beschreibungslänge ist in Ordnung (120–160)",
    "Optimize meta description length (120–160)":
        "Meta-Beschreibungslänge optimieren (120–160)",
    "Content length is sufficient (300+ words)":
        "Inhaltslänge ist ausreichend (300+ Wörter)",
    "Add more content (minimum 300 words)":
        "Mehr Inhalt hinzufügen (mindestens 300 Wörter)",
    "H1 heading is present": "H1-Überschrift ist vorhanden",
    "Add an H1 heading": "Eine H1-Überschrift hinzufügen",
    "H2 subheadings are present": "H2-Zwischenüberschriften sind vorhanden",
    "Add H2 subheadings": "H2-Zwischenüberschriften hinzufügen",
    "Images have alt attributes": "Bilder haben Alt-Attribute",
    "Add alt attributes to images": "Alt-Attribute zu Bildern hinzufügen",
    "Internal link is present": "Interner Link ist vorhanden",
    "Add an internal link": "Einen internen Link hinzufügen",
    "Enough sentences for readability": "Genügend Sätze für die Lesbarkeit",
    "Add more sentences": "Mehr Sätze hinzufügen",
    "Average sentence length is OK": "Durchschnittliche Satzlänge ist in Ordnung",
    "Make sentences shorter": "Sätze kürzer formulieren",
    "No overly long sentences": "Keine übermäßig langen Sätze",
    "There are overly long sentences": "Es gibt übermäßig lange Sätze",
    "Multiple paragraphs detected": "Mehrere Absätze erkannt",
    "Split text into paragraphs": "Text in Absätze aufteilen",
    "Paragraph length is OK": "Absatzlänge ist in Ordnung",
    "Make paragraphs shorter": "Absätze kürzer formulieren",
    "Lists are present": "Listen sind vorhanden",
    "Add lists (ul/ol)": "Listen hinzufügen (ul/ol)",
    "Excellent": "Hervorragend",
    "Okay": "In Ordnung",
    "Needs work": "Verbesserungsbedarf",
    "Select an image": "Ein Bild auswählen",
    "Use this image": "Dieses Bild verwenden",
    "Keyword in first paragraph": "Keyword im ersten Absatz",
    "Add keyword to first paragraph": "Keyword zum ersten Absatz hinzufügen",
    "URL length is OK": "URL-Länge ist in Ordnung",
    "Shorten URL (up to 75 chars)": "URL kürzen (bis zu 75 Zeichen)",
    "External link is present": "Externer Link ist vorhanden",
    "Add an external link": "Einen externen Link hinzufügen",
    "Images are present in content": "Bilder sind im Inhalt vorhanden",
    "Add an image": "Ein Bild hinzufügen",
    "Scan Content": "Inhalt scannen",
    "Scanning...": "Scannen...",
    "Linked!": "Verlinkt!",
    "Not found": "Nicht gefunden",
    "Untitled": "Ohne Titel",
    "No description available": "Keine Beschreibung verfügbar",

    # ── Post Meta tabs ──────────────────────────────────────────────
    "SEO Basics": "SEO-Grundlagen",
    "Advanced": "Erweitert",
    "Schema": "Schema",
    "Edit SEO Snippet": "SEO-Snippet bearbeiten",
    "General": "Allgemein",
    "Social": "Sozial",
    "SEO Title": "SEO-Titel",
    "Separator -, —": "Trennzeichen -, —",
    "Parent page": "Übergeordnete Seite",
    "Tag": "Schlagwort",
    "Taxonomy term": "Taxonomie-Begriff",
    "Current date": "Aktuelles Datum",
    "Current year": "Aktuelles Jahr",
    "Author name": "Autorenname",
    "Page number (2 of 4)": "Seitenzahl (2 von 4)",
    "Post type (singular)": "Beitragstyp (Singular)",
    "Search query": "Suchanfrage",
    "Meta Description": "Meta-Beschreibung",
    "Excerpt field only": "Nur Auszugsfeld",
    "Term description": "Begriffsbeschreibung",
    "Author bio": "Autorenbiografie",
    "Meta Keywords": "Meta-Keywords",
    "Focus keyword": "Fokus-Keyword",
    "Keywords": "Keywords",
    "Tags": "Schlagwörter",
    "All categories": "Alle Kategorien",
    "Separate keywords with commas": "Keywords mit Kommas trennen",
    "Cancel": "Abbrechen",

    # ── Pro Features ────────────────────────────────────────────────
    "PRO": "PRO",
    "Unlimited Redirects": "Unbegrenzte Weiterleitungen",
    "Unlimited 404 Monitoring": "Unbegrenzte 404-Überwachung",
    "AI Bot Blocking": "KI-Bot-Blockierung",
    "Schema Markup": "Schema-Markup",
    "Social Cards": "Social Cards",
    "FREE": "KOSTENLOS",
    "50 Redirects": "50 Weiterleitungen",
    "100 404 Logs": "100 404-Protokolle",
    "Meta Tags": "Meta-Tags",
    "Upgrade to PRO to unlock %s": "Auf PRO upgraden, um %s freizuschalten",
    "This feature requires a PRO license.":
        "Diese Funktion erfordert eine PRO-Lizenz.",
    "This feature requires %1$sPRO license%2$s.":
        "Diese Funktion erfordert eine %1$sPRO-Lizenz%2$s.",
    "FREE plan limited to %d items. Upgrade to PRO for unlimited.":
        "FREE-Plan auf %d Einträge begrenzt. Auf PRO upgraden für unbegrenzt.",
    "FREE plan limited to %1$d items. %2$sUpgrade to PRO%3$s for unlimited.":
        "FREE-Plan auf %1$d Einträge begrenzt. %2$sAuf PRO upgraden%3$s für unbegrenzt.",

    # ── Redirects class ─────────────────────────────────────────────
    "FREE plan limit reached (%d redirects). Upgrade to PRO for unlimited redirects.":
        "FREE-Plan-Limit erreicht (%d Weiterleitungen). Auf PRO upgraden für unbegrenzte Weiterleitungen.",
    "FREE plan limit reached (%1$d redirects). %2$sUpgrade to PRO%3$s for unlimited redirects.":
        "FREE-Plan-Limit erreicht (%1$d Weiterleitungen). %2$sAuf PRO upgraden%3$s für unbegrenzte Weiterleitungen.",
    "Please fill in all fields.": "Bitte füllen Sie alle Felder aus.",
    "A redirect with this source already exists.":
        "Eine Weiterleitung mit dieser Quelle existiert bereits.",
    "Redirect added successfully.": "Weiterleitung erfolgreich hinzugefügt.",
    "Failed to add redirect.": "Weiterleitung konnte nicht hinzugefügt werden.",
    "Redirect deleted.": "Weiterleitung gelöscht.",
    "Failed to delete redirect.": "Weiterleitung konnte nicht gelöscht werden.",
    "Status updated.": "Status aktualisiert.",
    "Failed to update status.": "Status konnte nicht aktualisiert werden.",
    "Redirects table is not created.": "Weiterleitungstabelle ist nicht erstellt.",
    "Redirect updated.": "Weiterleitung aktualisiert.",
    "Failed to update redirect.": "Weiterleitung konnte nicht aktualisiert werden.",
    "Table created.": "Tabelle erstellt.",
    "CSV file is required.": "CSV-Datei ist erforderlich.",
    "Failed to read CSV file.": "CSV-Datei konnte nicht gelesen werden.",
    "Invalid CSV header.": "Ungültiger CSV-Header.",

    # ── Robots.txt ──────────────────────────────────────────────────
    "Robots.txt Settings": "Robots.txt-Einstellungen",
    "Enable virtual robots.txt": "Virtuelle robots.txt aktivieren",
    "robots.txt Content": "robots.txt-Inhalt",
    "Additional User-agent Blocks": "Zusätzliche User-Agent-Blöcke",
    "Crawl-delay for bots": "Crawl-Delay für Bots",
    "Use dynamic variables": "Dynamische Variablen verwenden",
    "Block AI bots": "KI-Bots blockieren",
    "Block web archive bots": "Webarchiv-Bots blockieren",
    "Reset settings": "Einstellungen zurücksetzen",
    "Current robots.txt": "Aktuelle robots.txt",
    "Warning!": "Warnung!",
    "A physical robots.txt file was found in the site root.":
        "Eine physische robots.txt-Datei wurde im Stammverzeichnis der Website gefunden.",
    "It takes precedence over the virtual WordPress robots.txt.":
        "Sie hat Vorrang vor der virtuellen WordPress-robots.txt.",
    "Show physical file contents": "Inhalt der physischen Datei anzeigen",
    "No physical robots.txt file found in the site root.":
        "Keine physische robots.txt-Datei im Stammverzeichnis der Website gefunden.",
    "The virtual WordPress robots.txt is used.":
        "Die virtuelle WordPress-robots.txt wird verwendet.",
    "robots.txt editor. Available variables:":
        "robots.txt-Editor. Verfügbare Variablen:",
    "Additional rule blocks for specific user agents. Example:":
        "Zusätzliche Regelblöcke für bestimmte User-Agents. Beispiel:",
    "Format: one line = %s, for example:":
        "Format: eine Zeile = %s, zum Beispiel:",
    "Converted to %s directives for the listed bots.":
        "Umgewandelt in %s-Direktiven für die aufgelisteten Bots.",
    "Automatically replace": "Automatisch ersetzen",
    "Block AI crawlers (GPTBot, ChatGPT-User, Google-Extended, Omgilibot, ClaudeBot, Claude-Web)":
        "KI-Crawler blockieren (GPTBot, ChatGPT-User, Google-Extended, Omgilibot, ClaudeBot, Claude-Web)",
    "When enabled, robots.txt will include Disallow rules for popular AI crawlers.":
        "Wenn aktiviert, enthält die robots.txt Disallow-Regeln für beliebte KI-Crawler.",
    "to unlock": "zum Freischalten",
    "Block web archive bots (Wayback Machine, Archive.org, archive.is, and others)":
        "Webarchiv-Bots blockieren (Wayback Machine, Archive.org, archive.is und andere)",
    "When enabled, web archive services cannot store copies of your site.":
        "Wenn aktiviert, können Webarchiv-Dienste keine Kopien Ihrer Website speichern.",
    "This helps protect unique content and prevents unauthorized archiving.":
        "Dies hilft, einzigartige Inhalte zu schützen und unautorisierte Archivierung zu verhindern.",
    "Reset to defaults": "Auf Standardwerte zurücksetzen",
    "Restores robots.txt to default values.":
        "Setzt die robots.txt auf die Standardwerte zurück.",
    "All custom changes will be lost.":
        "Alle benutzerdefinierten Änderungen gehen verloren.",
    "Are you sure? All robots.txt settings will be reset.":
        "Sind Sie sicher? Alle robots.txt-Einstellungen werden zurückgesetzt.",
    "Resetting...": "Zurücksetzen...",
    "Reset complete!": "Zurücksetzen abgeschlossen!",
    "unknown": "unbekannt",
    "AJAX error": "AJAX-Fehler",
    "Settings reset.": "Einstellungen zurückgesetzt.",

    # ── Sitemap ─────────────────────────────────────────────────────
    "XML Sitemap Settings": "XML-Sitemap-Einstellungen",
    "Enable XML Sitemap": "XML-Sitemap aktivieren",
    "Post Types for XML Sitemap": "Beitragstypen für XML-Sitemap",
    "Include Images": "Bilder einbeziehen",
    "Exclude URLs": "URLs ausschließen",
    "Additional URLs": "Zusätzliche URLs",
    "HTML Sitemap Settings": "HTML-Sitemap-Einstellungen",
    "HTML Sitemap Slug": "HTML-Sitemap-Slug",
    "Post Types for HTML Sitemap": "Beitragstypen für HTML-Sitemap",
    "XML sitemap generation settings for search engines.":
        "XML-Sitemap-Generierungseinstellungen für Suchmaschinen.",
    "HTML sitemap settings for site visitors.":
        "HTML-Sitemap-Einstellungen für Website-Besucher.",
    "Enable XML sitemap generation": "XML-Sitemap-Generierung aktivieren",
    "Generates dynamic XML sitemap files for search engines.":
        "Generiert dynamische XML-Sitemap-Dateien für Suchmaschinen.",
    "Select post types to include in the XML sitemap and configure parameters for each type.":
        "Wählen Sie Beitragstypen für die XML-Sitemap aus und konfigurieren Sie die Parameter für jeden Typ.",
    "Priority:": "Priorität:",
    "Changefreq:": "Änderungshäufigkeit:",
    "Always": "Immer",
    "Hourly": "Stündlich",
    "Daily": "Täglich",
    "Weekly": "Wöchentlich",
    "Monthly": "Monatlich",
    "Yearly": "Jährlich",
    "Never": "Nie",
    "Include images in sitemap": "Bilder in die Sitemap einbeziehen",
    "Full or relative URLs to exclude from the XML sitemap (one per line).":
        "Vollständige oder relative URLs, die von der XML-Sitemap ausgeschlossen werden sollen (eine pro Zeile).",
    "Default priority and change frequency for all additional URLs (unless overridden individually below).":
        "Standardpriorität und Änderungshäufigkeit für alle zusätzlichen URLs (sofern nicht unten einzeln überschrieben).",
    "Default Priority:": "Standardpriorität:",
    "Default Changefreq:": "Standard-Änderungshäufigkeit:",
    "Additional URLs to add to the XML sitemap (one per line). These will use the default priority and changefreq above.":
        "Zusätzliche URLs, die zur XML-Sitemap hinzugefügt werden sollen (eine pro Zeile). Diese verwenden die oben angegebene Standardpriorität und Änderungshäufigkeit.",
    "Per-URL Priority & Changefreq": "Priorität & Änderungshäufigkeit pro URL",
    "+ Add URL": "+ URL hinzufügen",
    "Override priority & changefreq per URL":
        "Priorität & Änderungshäufigkeit pro URL überschreiben",
    "Upgrade to PRO to set individual priority and change frequency for each additional URL in your sitemap.":
        "Auf PRO upgraden, um individuelle Priorität und Änderungshäufigkeit für jede zusätzliche URL in Ihrer Sitemap festzulegen.",
    "Priority": "Priorität",
    "Changefreq": "Änderungshäufigkeit",
    'No per-URL overrides yet. Click "+ Add URL" to add one.':
        'Noch keine URL-Überschreibungen. Klicken Sie auf „+ URL hinzufügen", um eine hinzuzufügen.',
    "HTML sitemap slug (e.g., html-sitemap)":
        "HTML-Sitemap-Slug (z. B. html-sitemap)",
    "Select which post types to show in the HTML sitemap.":
        "Wählen Sie aus, welche Beitragstypen in der HTML-Sitemap angezeigt werden sollen.",
    "XML Sitemap": "XML-Sitemap",
    "XML Sitemap Index": "XML-Sitemap-Index",
    "This is the XML sitemap index. Each link below points to a sitemap for a specific content type.":
        "Dies ist der XML-Sitemap-Index. Jeder Link unten verweist auf eine Sitemap für einen bestimmten Inhaltstyp.",
    "Total sitemap files:": "Sitemap-Dateien insgesamt:",
    "Last Modified": "Zuletzt geändert",
    "Back to sitemap index": "Zurück zum Sitemap-Index",
    "This XML sitemap is intended for search engines such as Google, Bing, and Yandex.":
        "Diese XML-Sitemap ist für Suchmaschinen wie Google, Bing und Yandex bestimmt.",
    "URLs": "URLs",
    "Images": "Bilder",
    "Page": "Seite",
    "No entries available to display in the sitemap.":
        "Keine Einträge zur Anzeige in der Sitemap verfügbar.",

    # ── WooCommerce ─────────────────────────────────────────────────
    "SEO": "SEO",
    "Custom SEO title for this taxonomy. Variables: %term_title%, %sitename%, %sep%":
        "Benutzerdefinierter SEO-Titel für diese Taxonomie. Variablen: %term_title%, %sitename%, %sep%",
    "Custom meta description for this taxonomy page.":
        "Benutzerdefinierte Meta-Beschreibung für diese Taxonomie-Seite.",
    "Open Graph Image": "Open-Graph-Bild",
    "Custom social sharing image for this taxonomy page.":
        "Benutzerdefiniertes Social-Sharing-Bild für diese Taxonomie-Seite.",
    "Custom SEO title. Variables: %term_title%, %sitename%, %sep%":
        "Benutzerdefinierter SEO-Titel. Variablen: %term_title%, %sitename%, %sep%",
    "WooCommerce is not installed or activated. This module requires WooCommerce to function.":
        "WooCommerce ist nicht installiert oder aktiviert. Dieses Modul benötigt WooCommerce, um zu funktionieren.",
    "WooCommerce SEO settings saved.": "WooCommerce-SEO-Einstellungen gespeichert.",
    "WooCommerce Overview": "WooCommerce-Übersicht",
    "Products": "Produkte",
    "Categories": "Kategorien",
    "ON": "EIN",
    "OFF": "AUS",
    "Auto Schema": "Auto-Schema",
    "Product Schema (Structured Data)": "Produkt-Schema (Strukturierte Daten)",
    "Automatically generate Product schema markup from WooCommerce product data.":
        "Produkt-Schema-Markup automatisch aus WooCommerce-Produktdaten generieren.",
    "Auto-generate Product Schema": "Produkt-Schema automatisch generieren",
    "Automatically create Product schema from WooCommerce data when saving a product":
        "Produkt-Schema automatisch aus WooCommerce-Daten erstellen, wenn ein Produkt gespeichert wird",
    "Include Price": "Preis einbeziehen",
    "Include product price and currency in schema":
        "Produktpreis und Währung im Schema einbeziehen",
    "Include Reviews": "Bewertungen einbeziehen",
    "Include average rating and review count in schema":
        "Durchschnittsbewertung und Anzahl der Bewertungen im Schema einbeziehen",
    "Include Brand": "Marke einbeziehen",
    "Include brand from product attribute":
        "Marke aus Produktattribut einbeziehen",
    "Brand Attribute": "Markenattribut",
    "Product attribute slug for brand (e.g., %1$s or %2$s)":
        "Produktattribut-Slug für Marke (z. B. %1$s oder %2$s)",
    "Remove WC Default Schema": "WC-Standard-Schema entfernen",
    "Remove WooCommerce's built-in structured data to prevent conflicts":
        "Die integrierten strukturierten Daten von WooCommerce entfernen, um Konflikte zu vermeiden",
    "Warning: Only enable this if you are using SEO Fury to generate all product schema.":
        "Warnung: Aktivieren Sie dies nur, wenn Sie SEO Fury verwenden, um alle Produkt-Schemata zu generieren.",
    "SEO Title Templates": "SEO-Titelvorlagen",
    "Default SEO title/description templates for products and taxonomies. These are used when individual products don't have custom SEO titles set.":
        "Standard-SEO-Titel-/Beschreibungsvorlagen für Produkte und Taxonomien. Diese werden verwendet, wenn für einzelne Produkte keine benutzerdefinierten SEO-Titel festgelegt sind.",
    "Product Title Template": "Produkttitel-Vorlage",
    "Variables: %1$s, %2$s, %3$s, %4$s": "Variablen: %1$s, %2$s, %3$s, %4$s",
    "Product Description Template": "Produktbeschreibungs-Vorlage",
    "Variables: %1$s, %2$s, %3$s": "Variablen: %1$s, %2$s, %3$s",
    "Product Category Title": "Produktkategorie-Titel",
    "Product Tag Title": "Produktschlagwort-Titel",
    "Save WooCommerce Settings": "WooCommerce-Einstellungen speichern",

    # ── seo-fury.php ────────────────────────────────────────────────
    "Manifest updated!": "Manifest aktualisiert!",

    # ── Remaining strings (technical/short) ─────────────────────────
    "AUTO": "AUTO",
    "MANUAL": "MANUELL",
    "N/A": "k. A.",
    "// Paste your JSON-LD here": "// Fügen Sie hier Ihr JSON-LD ein",
    "JSON-LD is empty.": "JSON-LD ist leer.",
    "+ Link": "+ Link",
}


def parse_pot(pot_path):
    """Parse a .pot file and return list of entries.
    Each entry is a dict with keys: comments, msgctxt, msgid, msgid_plural, flags.
    Multi-line msgid strings are concatenated.
    """
    entries = []
    current = None

    with open(pot_path, "r", encoding="utf-8") as f:
        lines = f.readlines()

    last_key = None  # track which key we're appending continuation lines to

    for line in lines:
        stripped = line.rstrip("\n")

        # Comment lines
        if stripped.startswith("#"):
            if current is None:
                current = {"comments": [], "msgctxt": None, "msgid": [],
                           "msgid_plural": [], "msgstr": [], "flags": []}
            current["comments"].append(stripped)
            if stripped.startswith("#,"):
                current["flags"].append(stripped)
            continue

        # msgctxt
        if stripped.startswith("msgctxt "):
            if current is None:
                current = {"comments": [], "msgctxt": None, "msgid": [],
                           "msgid_plural": [], "msgstr": [], "flags": []}
            val = stripped[len("msgctxt "):]
            current["msgctxt"] = _unquote(val)
            last_key = "msgctxt"
            continue

        # msgid_plural
        if stripped.startswith("msgid_plural "):
            val = stripped[len("msgid_plural "):]
            current["msgid_plural"] = [_unquote(val)]
            last_key = "msgid_plural"
            continue

        # msgid
        if stripped.startswith("msgid "):
            if current is None:
                current = {"comments": [], "msgctxt": None, "msgid": [],
                           "msgid_plural": [], "msgstr": [], "flags": []}
            val = stripped[len("msgid "):]
            current["msgid"] = [_unquote(val)]
            last_key = "msgid"
            continue

        # msgstr
        if stripped.startswith("msgstr ") or stripped.startswith("msgstr["):
            val_start = stripped.index('"')
            val = stripped[val_start:]
            current["msgstr"] = [_unquote(val)]
            last_key = "msgstr"
            continue

        # Continuation line (starts with ")
        if stripped.startswith('"') and current is not None:
            unq = _unquote(stripped)
            if last_key == "msgid":
                current["msgid"].append(unq)
            elif last_key == "msgid_plural":
                current["msgid_plural"].append(unq)
            elif last_key == "msgstr":
                current["msgstr"].append(unq)
            elif last_key == "msgctxt":
                current["msgctxt"] = (current["msgctxt"] or "") + unq
            continue

        # Blank line => end of entry
        if stripped == "":
            if current is not None:
                entries.append(current)
                current = None
                last_key = None
            continue

    # Don't forget the last entry if file doesn't end with blank line
    if current is not None:
        entries.append(current)

    return entries


def _unquote(s):
    """Remove surrounding quotes and unescape."""
    s = s.strip()
    if s.startswith('"') and s.endswith('"'):
        s = s[1:-1]
    # Unescape
    s = s.replace('\\"', '"')
    s = s.replace("\\n", "\n")
    s = s.replace("\\t", "\t")
    s = s.replace("\\\\", "\\")
    return s


def _quote(s):
    """Escape and add quotes for .po format."""
    s = s.replace("\\", "\\\\")
    s = s.replace('"', '\\"')
    s = s.replace("\t", "\\t")
    # We handle newlines specially in write_entry
    return s


def write_entry(f, entry, translation):
    """Write a single .po entry to file."""
    # Write comments
    for c in entry.get("comments", []):
        f.write(c + "\n")

    # Write msgctxt if present
    if entry.get("msgctxt"):
        f.write('msgctxt "' + _quote(entry["msgctxt"]) + '"\n')

    # Write msgid (handle multi-line)
    msgid_str = "".join(entry["msgid"])
    _write_po_string(f, "msgid", msgid_str)

    # Write msgstr (the translation)
    _write_po_string(f, "msgstr", translation)


def _write_po_string(f, keyword, value):
    """Write a msgid or msgstr with proper multi-line handling."""
    if "\n" in value and not value.endswith("\n"):
        # No special multi-line needed if \n not present
        pass

    if "\n" in value:
        # Multi-line: empty first line, then each segment
        parts = value.split("\n")
        f.write(keyword + ' ""\n')
        for i, part in enumerate(parts):
            escaped = _quote(part)
            if i < len(parts) - 1:
                f.write('"' + escaped + '\\n"\n')
            else:
                if part:  # Don't write empty trailing line
                    f.write('"' + escaped + '"\n')
    else:
        escaped = _quote(value)
        f.write(keyword + ' "' + escaped + '"\n')


def main():
    print(f"Reading POT file: {POT_FILE}")
    entries = parse_pot(POT_FILE)
    print(f"  Found {len(entries)} entries (including header)")

    # First entry is the header
    header_entry = entries[0] if entries else None
    translatable = entries[1:] if len(entries) > 1 else []
    print(f"  Translatable strings: {len(translatable)}")

    translated_count = 0
    untranslated = []

    with open(PO_FILE, "w", encoding="utf-8") as f:
        # Write header comments
        f.write("# German translation for SEO Fury.\n")
        f.write("# Copyright (C) 2026 SEO Fury Team\n")
        f.write("# This file is distributed under the GPL v2 or later.\n")

        # Write header entry
        f.write('msgid ""\n')
        f.write('msgstr ""\n')
        now = datetime.utcnow().strftime("%Y-%m-%d %H:%M+0000")
        f.write('"Project-Id-Version: SEO Fury 0.1.5\\n"\n')
        f.write('"Report-Msgid-Bugs-To: https://wordpress.org/support/plugin/seo-fury\\n"\n')
        f.write('"Last-Translator: SEO Fury Team <support@seo-fury.com>\\n"\n')
        f.write('"Language-Team: German <de@li.org>\\n"\n')
        f.write('"Language: de_DE\\n"\n')
        f.write('"Plural-Forms: nplurals=2; plural=(n != 1);\\n"\n')
        f.write('"MIME-Version: 1.0\\n"\n')
        f.write('"Content-Type: text/plain; charset=UTF-8\\n"\n')
        f.write('"Content-Transfer-Encoding: 8bit\\n"\n')
        f.write(f'"POT-Creation-Date: 2026-02-08T09:27:12+00:00\\n"\n')
        f.write(f'"PO-Revision-Date: {now}\\n"\n')
        f.write('"X-Generator: generate_de.py\\n"\n')
        f.write('"X-Domain: seo-fury\\n"\n')
        f.write("\n")

        # Write each translatable entry
        for entry in translatable:
            msgid_str = "".join(entry["msgid"])

            # Look up translation
            translation = TRANSLATIONS.get(msgid_str, "")

            if translation:
                translated_count += 1
            else:
                untranslated.append(msgid_str)

            write_entry(f, entry, translation)
            f.write("\n")

    print(f"\nResults:")
    print(f"  Total translatable: {len(translatable)}")
    print(f"  Translated:         {translated_count}")
    print(f"  Untranslated:       {len(untranslated)}")
    if untranslated:
        print(f"\n  Untranslated strings ({len(untranslated)}):")
        for s in untranslated:
            display = s.replace("\n", "\\n")
            if len(display) > 80:
                display = display[:77] + "..."
            print(f"    - \"{display}\"")
    print(f"\nOutput written to: {PO_FILE}")


if __name__ == "__main__":
    main()
