#!/usr/bin/env python3
"""
Generate complete Spanish (es_ES) translation .po file for SEO Fury WordPress plugin.
Reads the .pot file, creates Spanish translations for all strings, and writes the .po file.
"""

import re
import os
import datetime

# Paths
SCRIPT_DIR = os.path.dirname(os.path.abspath(__file__))
POT_FILE = os.path.join(SCRIPT_DIR, "seo-fury.pot")
PO_FILE = os.path.join(SCRIPT_DIR, "seo-fury-es_ES.po")

# ─── Translation dictionary ───────────────────────────────────────────────
# Maps English msgid to Spanish msgstr. Entries are grouped by context.
# Rules:
#   - "SEO Fury" is NOT translated
#   - Preserve all %s, %d, %1$s, %2$s placeholders
#   - Preserve HTML tags
#   - Use formal "usted" form
#   - Keep English: SEO, URL, HTTPS, SSL, HSTS, API, CSV, JSON-LD, Schema,
#     IndexNow, robots.txt, noindex, nofollow, canonical, Open Graph, WooCommerce

TRANSLATIONS = {
    # ── Plugin metadata ──
    "SEO Fury": "SEO Fury",
    "Complete SEO plugin with licensing, robots.txt, sitemaps, redirects, and IndexNow.":
        "Plugin SEO completo con licencias, robots.txt, mapas del sitio, redirecciones e IndexNow.",
    "SEO Fury Team": "SEO Fury Team",

    # ── 404 Monitor Settings ──
    "404 Monitor Settings": "Ajustes del monitor 404",
    "Enable Monitoring": "Activar monitoreo",
    "Ignore Bots": "Ignorar bots",
    "Auto Cleanup": "Limpieza automática",
    "Debug Logging": "Registro de depuración",
    "Track and analyze 404 errors on your site.":
        "Rastree y analice los errores 404 en su sitio.",
    "Enable 404 tracking": "Activar el rastreo de errores 404",
    "Do not log requests from search bots":
        "No registrar solicitudes de bots de búsqueda",
    "Ignores Googlebot, Bingbot, Yandex, and other known bots.":
        "Ignora Googlebot, Bingbot, Yandex y otros bots conocidos.",
    "days": "días",
    "Automatically delete entries older than this number of days. 0 = never delete":
        "Eliminar automáticamente las entradas con más de este número de días. 0 = nunca eliminar",
    "Enable verbose logging for diagnostics":
        "Activar registro detallado para diagnósticos",
    "Writes detailed module logs to debug.log. Use for troubleshooting. Logs are in wp-content/debug.log (when WP_DEBUG_LOG is enabled).":
        "Escribe registros detallados del módulo en debug.log. Úselo para solucionar problemas. Los registros se encuentran en wp-content/debug.log (cuando WP_DEBUG_LOG está activado).",
    "Insufficient permissions": "Permisos insuficientes",
    "Logs cleared": "Registros borrados",
    "URL is required": "La URL es obligatoria",
    "Invalid ID": "ID no válido",
    "Marked as resolved": "Marcado como resuelto",
    "Entry deleted": "Entrada eliminada",
    "Please fill in all fields": "Por favor, complete todos los campos",
    "A redirect with this source already exists":
        "Ya existe una redirección con este origen",
    "Redirect created successfully!": "¡Redirección creada con éxito!",
    "Error creating redirect: ": "Error al crear la redirección: ",
    "URL": "URL",
    "Hits": "Visitas",
    "First Seen": "Visto por primera vez",
    "Last Seen": "Visto por última vez",
    "Status": "Estado",
    "Resolved": "Resuelto",
    "Active": "Activo",

    # ── Admin General ──
    "Loading...": "Cargando...",
    "No redirects found": "No se encontraron redirecciones",
    "Inactive": "Inactivo",
    "Activate": "Activar",
    "Deactivate": "Desactivar",
    "Edit": "Editar",
    "Delete": "Eliminar",
    "Adding...": "Añadiendo...",
    "Deleting...": "Eliminando...",
    "Saving...": "Guardando...",
    "Updating...": "Actualizando...",
    "Please fill all fields": "Por favor, complete todos los campos",
    "Redirect added successfully!": "¡Redirección añadida con éxito!",
    "Redirect deleted!": "¡Redirección eliminada!",
    "Redirect updated!": "¡Redirección actualizada!",
    "Are you sure you want to delete this redirect?":
        "¿Está seguro de que desea eliminar esta redirección?",
    "Error loading redirects": "Error al cargar las redirecciones",
    "Error loading data": "Error al cargar los datos",
    "Error adding redirect": "Error al añadir la redirección",
    "Error deleting redirect": "Error al eliminar la redirección",
    "Error updating redirect": "Error al actualizar la redirección",
    "Error updating status": "Error al actualizar el estado",
    "Please select a CSV file.": "Por favor, seleccione un archivo CSV.",
    "CSV import completed.": "Importación de CSV completada.",
    "Imported": "Importado",
    "Updated": "Actualizado",
    "Skipped": "Omitido",
    "Upload failed.": "La carga falló.",
    "Error": "Error",
    "An error occurred": "Ha ocurrido un error",
    "Please enter at least one URL": "Por favor, introduzca al menos una URL",
    "No valid URLs found": "No se encontraron URLs válidas",
    "Maximum 10,000 URLs per request. You have:":
        "Máximo 10.000 URLs por solicitud. Usted tiene:",
    "Sending...": "Enviando...",
    "Sending in batches...": "Enviando en lotes...",
    "Generating...": "Generando...",
    "Checking...": "Verificando...",
    "Success!": "¡Éxito!",
    "URLs sent:": "URLs enviadas:",
    "Error!": "¡Error!",
    "Unknown error": "Error desconocido",
    "Server connection error": "Error de conexión con el servidor",
    "Settings saved": "Ajustes guardados",
    "Save error": "Error al guardar",
    "Key generated!": "¡Clave generada!",
    "Verify key": "Verificar clave",
    "No history yet": "Aún no hay historial",
    "Are you sure you want to clear the entire history?":
        "¿Está seguro de que desea borrar todo el historial?",
    "History cleared": "Historial borrado",
    "Clear failed": "Error al borrar",
    "Sending batch": "Enviando lote",
    "of": "de",
    "All batches sent successfully!": "¡Todos los lotes enviados con éxito!",
    "Total URLs:": "URLs totales:",
    "Batches:": "Lotes:",
    "Completed with errors": "Completado con errores",
    "Errors:": "Errores:",

    # ── License strings ──
    "Please enter a license key.": "Por favor, introduzca una clave de licencia.",
    "Invalid key format.": "Formato de clave no válido.",
    "Activating...": "Activando...",
    "License activated! The page will reload...":
        "¡Licencia activada! La página se recargará...",
    "License activation failed": "Error en la activación de la licencia",
    "Activation server connection error":
        "Error de conexión con el servidor de activación",
    "Are you sure you want to deactivate the license?\n\nAll PRO features will be disabled.":
        "¿Está seguro de que desea desactivar la licencia?\n\nTodas las funciones PRO se desactivarán.",
    "Deactivating...": "Desactivando...",
    "License deactivated. The page will reload...":
        "Licencia desactivada. La página se recargará...",
    "Deactivation failed": "Error en la desactivación",
    "License is active and valid!": "¡La licencia está activa y es válida!",
    "Plan:": "Plan:",
    "Status:": "Estado:",
    "Expires:": "Expira:",
    "License is inactive or expired.": "La licencia está inactiva o ha expirado.",
    "Could not reach the license server. Using local cache.":
        "No se pudo contactar con el servidor de licencias. Usando caché local.",
    "Key copied to clipboard!": "¡Clave copiada al portapapeles!",
    "Click to copy": "Haga clic para copiar",
    "Load error": "Error de carga",
    "No 404 errors found": "No se encontraron errores 404",
    "Find": "Buscar",
    "Redirect": "Redirección",
    "Resolve": "Resolver",
    "Are you sure? All 404 logs will be deleted!":
        "¿Está seguro? ¡Se eliminarán todos los registros 404!",
    "Searching for similar pages...": "Buscando páginas similares...",
    "Found %d similar pages:": "Se encontraron %d páginas similares:",
    "Use this URL": "Usar esta URL",
    "No similar pages found": "No se encontraron páginas similares",
    "Please provide a target URL": "Por favor, proporcione una URL de destino",
    "Creating...": "Creando...",
    "Error creating redirect": "Error al crear la redirección",
    "Delete this entry?": "¿Eliminar esta entrada?",

    # ── Admin Tabs ──
    "General Settings": "Ajustes generales",
    "Meta Titles": "Meta títulos",
    "Robots.txt": "Robots.txt",
    "Sitemap": "Mapa del sitio",
    "Breadcrumbs": "Migas de pan",
    "Local SEO": "SEO local",
    "SSL & Security": "SSL y seguridad",
    "WooCommerce SEO": "WooCommerce SEO",
    "Redirects": "Redirecciones",
    "404 Monitor": "Monitor 404",
    "IndexNow": "IndexNow",
    "Changelog": "Registro de cambios",
    "License": "Licencia",
    "Version %s": "Versión %s",

    # ── Internal Linking ──
    "Internal Linking": "Enlaces internos",
    "Scan your posts and pages for internal linking opportunities. The module analyzes your content and suggests relevant links to other published pages based on keyword and title matching.":
        "Escanee sus entradas y páginas en busca de oportunidades de enlazado interno. El módulo analiza su contenido y sugiere enlaces relevantes a otras páginas publicadas basándose en la coincidencia de palabras clave y títulos.",
    "Open any post or page in the editor and click the":
        "Abra cualquier entrada o página en el editor y haga clic en la pestaña",
    "Links": "Enlaces",
    "tab in the SEO Fury sidebar.": "en la barra lateral de SEO Fury.",
    "PRO Feature": "Función PRO",
    "Available in all PRO plans. Upgrade to unlock smart internal linking suggestions in the post editor.":
        "Disponible en todos los planes PRO. Actualice para desbloquear sugerencias inteligentes de enlaces internos en el editor de entradas.",
    "Upgrade": "Actualizar",

    # ── Sitemap Links ──
    "Sitemap Links": "Enlaces del mapa del sitio",
    "Index XML Sitemap:": "Mapa del sitio XML de índice:",
    "HTML Sitemap:": "Mapa del sitio HTML:",
    "You can also use the %s shortcode to display the HTML sitemap on any page.":
        "También puede usar el shortcode %s para mostrar el mapa del sitio HTML en cualquier página.",

    # ── Redirects Section ──
    "Create 301, 302 and 307 redirects. Track total hits.":
        "Cree redirecciones 301, 302 y 307. Rastree las visitas totales.",
    "Redirects used: %1$s of %2$s": "Redirecciones usadas: %1$s de %2$s",
    "You are nearing the FREE plan limit.":
        "Se está acercando al límite del plan GRATUITO.",
    "PRO provides unlimited redirects.":
        "PRO proporciona redirecciones ilimitadas.",
    "Upgrade to PRO": "Actualizar a PRO",
    "Add a new redirect": "Añadir una nueva redirección",
    "Source URL": "URL de origen",
    "/old-page": "/pagina-anterior",
    "Relative path, e.g. %s": "Ruta relativa, p. ej. %s",
    "Target URL": "URL de destino",
    "/new-page": "/pagina-nueva",
    "Full URL or relative path": "URL completa o ruta relativa",
    "Redirect Type": "Tipo de redirección",
    "301 (Permanent)": "301 (Permanente)",
    "302 (Temporary)": "302 (Temporal)",
    "307 (Temporary, preserves method)": "307 (Temporal, conserva el método)",
    "Add Redirect": "Añadir redirección",
    "Import / Export CSV": "Importar / Exportar CSV",
    "Export all redirects or import a CSV with columns: %s.":
        "Exporte todas las redirecciones o importe un CSV con las columnas: %s.",
    "Export CSV": "Exportar CSV",
    "Import CSV": "Importar CSV",
    "Redirects List": "Lista de redirecciones",
    "ID": "ID",
    "Source": "Origen",
    "Target": "Destino",
    "Type": "Tipo",
    "Created": "Creado",
    "Actions": "Acciones",
    "Edit Redirect": "Editar redirección",
    "Save Changes": "Guardar cambios",

    # ── IndexNow Section ──
    "Submit URLs directly to the IndexNow API.":
        "Envíe URLs directamente a la API de IndexNow.",
    "Learn more": "Más información",
    "Save Settings": "Guardar ajustes",
    "Submit URLs": "Enviar URLs",
    "URLs to submit": "URLs a enviar",
    "Enter one URL per line...": "Introduzca una URL por línea...",
    "Enter one URL per line. You can submit up to 10,000 URLs at once.":
        "Introduzca una URL por línea. Puede enviar hasta 10.000 URLs a la vez.",
    "Submit to IndexNow": "Enviar a IndexNow",
    "Submission History": "Historial de envíos",
    "Last 100 IndexNow API requests.":
        "Últimas 100 solicitudes a la API de IndexNow.",
    "Load History": "Cargar historial",
    "Clear History": "Borrar historial",
    "Time": "Hora",
    "Response": "Respuesta",
    "Method": "Método",

    # ── 404 Statistics ──
    "404 logs used: %1$s of %2$s": "Registros 404 usados: %1$s de %2$s",
    "PRO removes limits for 404 logging.":
        "PRO elimina los límites del registro de errores 404.",
    "Tracking 404 errors helps find broken links and create redirects.":
        "El rastreo de errores 404 ayuda a encontrar enlaces rotos y crear redirecciones.",
    "404 Statistics": "Estadísticas 404",
    "Total URLs": "URLs totales",
    "Total Hits": "Visitas totales",
    "Refresh": "Actualizar",
    "Clear All": "Borrar todo",
    "Find a Similar Page": "Buscar una página similar",
    "404 URL:": "URL 404:",
    "Create Redirect": "Crear redirección",
    "Source (404 URL)": "Origen (URL 404)",
    "Target (Target URL)": "Destino (URL de destino)",

    # ── License Section ──
    "License Active": "Licencia activa",
    "License Key:": "Clave de licencia:",
    "Free": "Gratuito",
    "Pro Starter": "Pro Starter",
    "Pro Business": "Pro Business",
    "Pro Agency": "Pro Agency",
    "Lifetime": "De por vida",
    "Unknown": "Desconocido",
    "Domain:": "Dominio:",
    "Available Features:": "Funciones disponibles:",
    "Advanced SEO": "SEO avanzado",
    "Advanced SEO features": "Funciones de SEO avanzado",
    "Not available on your plan": "No disponible en su plan",
    "Unlimited redirects": "Redirecciones ilimitadas",
    "Limited to 50": "Limitado a 50",
    "Unlimited 404 logs": "Registros 404 ilimitados",
    "404 Logs": "Registros 404",
    "Limited to 100": "Limitado a 100",
    "Smart link suggestions": "Sugerencias inteligentes de enlaces",
    "White Label": "Marca blanca",
    "Branding": "Marca",
    "Not available": "No disponible",
    "Priority Support": "Soporte prioritario",
    "Priority support": "Soporte prioritario",
    "Support": "Soporte",
    "Standard support": "Soporte estándar",
    "Priority support is active": "El soporte prioritario está activo",
    "Reply within 24 hours": "Respuesta en 24 horas",
    "Direct line to developers": "Línea directa con los desarrolladores",
    "Help with setup and optimization": "Ayuda con la configuración y optimización",
    "Deactivate License": "Desactivar licencia",
    "Check Status": "Comprobar estado",
    "License Not Activated": "Licencia no activada",
    "Enter a license key to activate plugin features.":
        "Introduzca una clave de licencia para activar las funciones del plugin.",
    "Supported formats:": "Formatos admitidos:",
    "License Key": "Clave de licencia",
    "PRO format: %s": "Formato PRO: %s",
    "FREE format: %s": "Formato GRATUITO: %s",
    "Activate License": "Activar licencia",
    "Available plans:": "Planes disponibles:",
    "%s domain": "%s dominio",
    "%s redirects": "%s redirecciones",
    "%s 404 logs": "%s registros 404",
    "month": "mes",
    "%s domains": "%s dominios",
    "Everything in Starter +": "Todo en Starter +",
    "Unlimited domains": "Dominios ilimitados",
    "Everything in Business +": "Todo en Business +",
    "All pro features": "Todas las funciones Pro",
    "one-time": "pago único",
    "All features forever": "Todas las funciones para siempre",
    "Lifetime updates": "Actualizaciones de por vida",
    "Buy a license": "Comprar una licencia",

    # ── SSL / Security ──
    "SSL / HTTPS Security": "Seguridad SSL / HTTPS",
    "Protect your site with HTTPS enforcement, mixed content fixes, and security headers.":
        "Proteja su sitio con la aplicación de HTTPS, corrección de contenido mixto y cabeceras de seguridad.",
    "SSL Certificate": "Certificado SSL",
    "Not detected": "No detectado",
    "HTTPS Redirect": "Redirección HTTPS",
    "Enabled": "Activado",
    "Disabled": "Desactivado",
    "Mixed Content": "Contenido mixto",
    "Auto-fix on": "Corrección automática activada",
    "Not active": "No activo",
    "HSTS Header": "Cabecera HSTS",
    "Save Security Settings": "Guardar ajustes de seguridad",
    "All updates and improvements for the plugin":
        "Todas las actualizaciones y mejoras del plugin",
    "Current version": "Versión actual",
    "Unable to load changelog. Please check your internet connection.":
        "No se pudo cargar el registro de cambios. Por favor, compruebe su conexión a Internet.",
    "Retry": "Reintentar",

    # ── Breadcrumbs ──
    "Enable Breadcrumbs": "Activar migas de pan",
    "Show Home Link": "Mostrar enlace de inicio",
    "Home Label": "Etiqueta de inicio",
    "Home URL": "URL de inicio",
    "Breadcrumb Prefix": "Prefijo de migas de pan",
    "Separator": "Separador",
    "Archive Format": "Formato de archivo",
    "404 Label": "Etiqueta 404",
    "Hide Post Title": "Ocultar título de la entrada",
    "Show Categories": "Mostrar categorías",
    "Hide Taxonomy Name": "Ocultar nombre de la taxonomía",
    "How to display breadcrumbs": "Cómo mostrar las migas de pan",
    "Use this PHP snippet in your theme template:":
        "Use este fragmento de PHP en la plantilla de su tema:",
    "Or use shortcode:": "O use el shortcode:",
    "Enable and configure breadcrumbs for your site.":
        "Active y configure las migas de pan para su sitio.",
    "Show breadcrumbs output": "Mostrar la salida de migas de pan",
    "Show link to the homepage": "Mostrar enlace a la página de inicio",
    "Home": "Inicio",
    "The label used for the homepage link (the first item) in breadcrumb trails.":
        "La etiqueta utilizada para el enlace de la página de inicio (el primer elemento) en las migas de pan.",
    "The homepage link (the first item) in breadcrumb trails. Leave empty to use the default homepage URL.":
        "El enlace de la página de inicio (el primer elemento) en las migas de pan. Déjelo vacío para usar la URL predeterminada.",
    "An element displayed before the breadcrumb trail.":
        "Un elemento que se muestra antes de las migas de pan.",
    "Custom": "Personalizado",
    "Enter custom separator": "Introduzca un separador personalizado",
    'Search results for "%s"': 'Resultados de búsqueda para "%s"',
    "Format the label used for search results pages. Use %s as a placeholder for the search query.":
        "Configure la etiqueta utilizada para las páginas de resultados de búsqueda. Use %s como marcador de posición para la consulta de búsqueda.",
    "Page not found": "Página no encontrada",
    "The label used for the 404 error page in breadcrumb trails.":
        "La etiqueta utilizada para la página de error 404 en las migas de pan.",
    "Hide the post title in the breadcrumb trail":
        "Ocultar el título de la entrada en las migas de pan",
    "If a category is a child, display all parent categories":
        "Si una categoría es hija, mostrar todas las categorías padre",
    "Hide the taxonomy name in the breadcrumb trail":
        "Ocultar el nombre de la taxonomía en las migas de pan",

    # ── Core ──
    "Plugin files have been modified. PRO features disabled for security.":
        "Los archivos del plugin han sido modificados. Las funciones PRO se han desactivado por seguridad.",

    # ── General SEO Settings ──
    "General SEO Settings": "Ajustes generales de SEO",
    "Settings": "Ajustes",
    "URL Transliteration": "Transliteración de URL",
    "Enable White Label": "Activar marca blanca",
    "Plugin Name": "Nombre del plugin",
    "Hide Branding Links": "Ocultar enlaces de marca",
    "Bulk URL Conversion": "Conversión masiva de URLs",
    "Force HTTPS": "Forzar HTTPS",
    "Fix Mixed Content": "Corregir contenido mixto",
    "WWW Redirect": "Redirección WWW",
    "Configure the main SEO settings for your site.":
        "Configure los ajustes principales de SEO para su sitio.",
    "Enable automatic transliteration for non-Latin URLs":
        "Activar la transliteración automática para URLs no latinas",
    "Automatically converts non-Latin characters to Latin in post and page URLs.":
        "Convierte automáticamente los caracteres no latinos a latinos en las URLs de entradas y páginas.",
    "Insufficient permissions.": "Permisos insuficientes.",
    "Convert existing non-Latin URLs to Latin slugs.":
        "Convertir URLs no latinas existentes a slugs latinos.",
    "Loading stats...": "Cargando estadísticas...",
    "Posts": "Entradas",
    "Pages": "Páginas",
    "Refresh Stats": "Actualizar estadísticas",
    "Convert URLs": "Convertir URLs",
    "URL stats:": "Estadísticas de URL:",
    "Total:": "Total:",
    "Non-Latin:": "No latinas:",
    "Latin:": "Latinas:",
    "Are you sure? This will change URLs for all posts with non-Latin slugs.":
        "¿Está seguro? Esto cambiará las URLs de todas las entradas con slugs no latinos.",
    "We recommend backing up the database first.":
        "Le recomendamos hacer una copia de seguridad de la base de datos primero.",
    "Converting...": "Convirtiendo...",
    "Conversion completed!": "¡Conversión completada!",
    "Updated:": "Actualizados:",
    "Skipped (already Latin):": "Omitidos (ya están en latín):",
    "Total checked:": "Total comprobados:",
    "Error:": "Error:",
    "Configure HTTPS enforcement, HSTS headers, and WWW redirect.":
        "Configure la aplicación de HTTPS, las cabeceras HSTS y la redirección WWW.",
    "Redirect all HTTP requests to HTTPS (301)":
        "Redirigir todas las solicitudes HTTP a HTTPS (301)",
    "Requires a valid SSL certificate installed on your server.":
        "Requiere un certificado SSL válido instalado en su servidor.",
    "Automatically replace HTTP with HTTPS in page output":
        "Reemplazar automáticamente HTTP por HTTPS en la salida de la página",
    "Fixes mixed content warnings by rewriting internal HTTP URLs to HTTPS on the frontend.":
        "Corrige las advertencias de contenido mixto reescribiendo las URLs HTTP internas a HTTPS en el frontend.",
    "Send Strict-Transport-Security header":
        "Enviar cabecera Strict-Transport-Security",
    "Max-Age (seconds):": "Max-Age (segundos):",
    "Default: 31536000 (1 year)": "Predeterminado: 31536000 (1 año)",
    "Tells browsers to always use HTTPS for this domain. Only enable if SSL is fully configured.":
        "Indica a los navegadores que siempre usen HTTPS para este dominio. Active solo si SSL está completamente configurado.",
    "No redirect": "Sin redirección",
    "Force www (redirect non-www to www)":
        "Forzar www (redirigir sin www a www)",
    "Force non-www (redirect www to non-www)":
        "Forzar sin www (redirigir www a sin www)",
    "Enforce a canonical www or non-www version of your domain (301 redirect).":
        "Establezca la versión canonical www o sin www de su dominio (redirección 301).",

    # ── White Label ──
    "White Label is a PRO feature": "Marca blanca es una función PRO",
    "Rename the plugin and remove branding. Perfect for agencies and resellers.":
        "Renombre el plugin y elimine la marca. Perfecto para agencias y revendedores.",
    "Customize the plugin branding for your product.":
        "Personalice la marca del plugin para su producto.",
    "Enable white label": "Activar marca blanca",
    "When enabled, the plugin name changes across the admin UI.":
        "Cuando está activado, el nombre del plugin cambia en toda la interfaz de administración.",
    "New plugin name used across the UI.":
        "Nuevo nombre del plugin utilizado en toda la interfaz.",
    "Hide all branding links": "Ocultar todos los enlaces de marca",
    "Removes upgrade links and branding references.":
        "Elimina los enlaces de actualización y las referencias de marca.",

    # ── IndexNow Settings ──
    "IndexNow Settings": "Ajustes de IndexNow",
    "IndexNow API Key": "Clave API de IndexNow",
    "Search Engine": "Motor de búsqueda",
    "Automatic Submission": "Envío automático",
    "Submit on Delete": "Enviar al eliminar",
    "Instant indexing module settings.":
        "Ajustes del módulo de indexación instantánea.",
    "Generate Key": "Generar clave",
    "Verify Key": "Verificar clave",
    "API key for IndexNow. It will be saved in the site root.":
        "Clave API para IndexNow. Se guardará en la raíz del sitio.",
    "IndexNow (all search engines)": "IndexNow (todos los motores de búsqueda)",
    "Bing": "Bing",
    "Yandex": "Yandex",
    "Seznam": "Seznam",
    "Select the search engine to notify.":
        "Seleccione el motor de búsqueda a notificar.",
    "Automatically submit URLs on publish/update":
        "Enviar URLs automáticamente al publicar/actualizar",
    "Automatically notify on deletion":
        "Notificar automáticamente al eliminar",
    "Please provide URLs to submit":
        "Por favor, proporcione URLs para enviar",
    "No valid URLs provided": "No se proporcionaron URLs válidas",
    "Submission completed": "Envío completado",
    "Failed to create key file. Check permissions.":
        "Error al crear el archivo de clave. Compruebe los permisos.",
    "API key is not configured": "La clave API no está configurada",
    "Key file not found on the server":
        "Archivo de clave no encontrado en el servidor",
    "Key file content does not match":
        "El contenido del archivo de clave no coincide",
    "Failed to check file availability: %s":
        "Error al comprobar la disponibilidad del archivo: %s",
    "Key file is not accessible via URL (code: %d)":
        "El archivo de clave no es accesible mediante URL (código: %d)",
    "Key file content via URL does not match":
        "El contenido del archivo de clave a través de la URL no coincide",
    "Key verified successfully!": "¡Clave verificada con éxito!",
    "Failed to clear history": "Error al borrar el historial",
    "URL sent successfully": "URL enviada con éxito",
    "Error: %d": "Error: %d",

    # ── License class ──
    "Invalid license key format": "Formato de clave de licencia no válido",
    "Error: invalid API response format":
        "Error: formato de respuesta de la API no válido",
    "License activated successfully!": "¡Licencia activada con éxito!",
    "License deactivated": "Licencia desactivada",
    "Invalid response": "Respuesta no válida",
    "License key is required": "La clave de licencia es obligatoria",
    "Invalid response format": "Formato de respuesta no válido",
    "License activated": "Licencia activada",
    "Activation failed": "Error en la activación",

    # ── Local SEO ──
    "Enable Local SEO": "Activar SEO local",
    "Business Type": "Tipo de negocio",
    "Business Name": "Nombre del negocio",
    "Phone": "Teléfono",
    "Email": "Correo electrónico",
    "Logo URL": "URL del logotipo",
    "Image URL": "URL de imagen",
    "Price Range": "Rango de precios",
    "Street Address": "Dirección",
    "City": "Ciudad",
    "Region/State": "Región/Estado",
    "Postal Code": "Código postal",
    "Country": "País",
    "Latitude": "Latitud",
    "Longitude": "Longitud",
    "Opening Hours": "Horario de apertura",
    "Configure your local business details for Local SEO schema.":
        "Configure los datos de su negocio local para el Schema de SEO local.",
    "Output LocalBusiness schema on the frontend":
        "Mostrar el Schema LocalBusiness en el frontend",
    'Example: LocalBusiness, Store, Restaurant, MedicalBusiness':
        'Ejemplo: LocalBusiness, Store, Restaurant, MedicalBusiness',
    'One line per rule, e.g. "Mo-Fr 09:00-18:00"':
        'Una línea por regla, p. ej. "Mo-Fr 09:00-18:00"',

    # ── Meta Titles ──
    "Robots Meta": "Robots Meta",
    "Robots Meta Tags": "Etiquetas Robots Meta",
    "Advanced Robots Meta": "Robots Meta avanzado",
    "Snippet": "Fragmento",
    "Video Preview": "Vista previa de vídeo",
    "Image Preview Size": "Tamaño de vista previa de imagen",
    "Noindex Empty Archives": "Noindex en archivos vacíos",
    "Empty Archives": "Archivos vacíos",
    "Title Settings": "Ajustes de título",
    "Title Separator": "Separador de título",
    "Capitalize Titles": "Capitalizar títulos",
    "Twitter Card": "Twitter Card",
    "Content Type Templates": "Plantillas de tipo de contenido",
    "Templates": "Plantillas",
    "Twitter Card Type": "Tipo de Twitter Card",
    "Default values for the robots meta tag.":
        "Valores predeterminados para la etiqueta robots meta.",
    "Important:": "Importante:",
    "Do not enable %1$s and %2$s at the same time. If both are enabled, %2$s takes priority.":
        "No active %1$s y %2$s al mismo tiempo. Si ambos están activados, %2$s tiene prioridad.",
    "Index": "Index",
    "Allow search engines to index and show these pages in results":
        "Permitir que los motores de búsqueda indexen y muestren estas páginas en los resultados",
    "NoIndex": "NoIndex",
    "Prevent indexing and showing pages in search results":
        "Impedir la indexación y la aparición de páginas en los resultados de búsqueda",
    "NoFollow": "NoFollow",
    "Prevent search engines from following links on the page":
        "Impedir que los motores de búsqueda sigan los enlaces de la página",
    "NoArchive": "NoArchive",
    "Prevent cached links in search results":
        "Impedir enlaces en caché en los resultados de búsqueda",
    "NoImageIndex": "NoImageIndex",
    "Prevent indexing page images by search engines":
        "Impedir la indexación de imágenes de la página por los motores de búsqueda",
    "NoSnippet": "NoSnippet",
    "Prevents displaying snippets in search results":
        "Impide mostrar fragmentos en los resultados de búsqueda",
    "Additional settings to control content appearance in search results.":
        "Ajustes adicionales para controlar la apariencia del contenido en los resultados de búsqueda.",
    "characters": "caracteres",
    "Set the maximum snippet length in characters.":
        "Establezca la longitud máxima del fragmento en caracteres.",
    "means unlimited.": "significa ilimitado.",
    "disables snippets.": "desactiva los fragmentos.",
    "seconds": "segundos",
    "Set the maximum video preview length in seconds.":
        "Establezca la duración máxima de la vista previa de vídeo en segundos.",
    "disables video previews.": "desactiva las vistas previas de vídeo.",
    "None": "Ninguno",
    "Standard": "Estándar",
    "Large": "Grande",
    "Set the maximum image preview size for images on this page.":
        "Establezca el tamaño máximo de vista previa de imagen para las imágenes de esta página.",
    "disables image previews.": "desactiva las vistas previas de imágenes.",
    "are standard limits.": "son límites estándar.",
    "Adding noindex for empty archives helps avoid indexing empty pages.":
        "Añadir noindex a los archivos vacíos ayuda a evitar la indexación de páginas vacías.",
    "Add %s for empty category and tag archives":
        "Añadir %s para archivos de categorías y etiquetas vacíos",
    "When a post is added, the archive switches back to %s.":
        "Cuando se añade una entrada, el archivo vuelve a %s.",
    "Configure how page titles are displayed on your site.":
        "Configure cómo se muestran los títulos de las páginas en su sitio.",
    "Use the separator in title templates with %1$s or %2$s.":
        "Use el separador en las plantillas de título con %1$s o %2$s.",
    "Preview:": "Vista previa:",
    "Page title": "Título de página",
    "Site name": "Nombre del sitio",
    "Automatically capitalize each word in titles":
        "Capitalizar automáticamente cada palabra en los títulos",
    'Example: "%1$s" → "%2$s"': 'Ejemplo: "%1$s" → "%2$s"',
    "Configure the Twitter card type for your pages.":
        "Configure el tipo de Twitter Card para sus páginas.",
    "Summary with large image": "Resumen con imagen grande",
    "Summary": "Resumen",
    "This card type is used for new posts and for posts without a selected card type.":
        "Este tipo de tarjeta se usa para nuevas entradas y para entradas sin un tipo de tarjeta seleccionado.",
    "Set default title and description templates for each content type.":
        "Establezca plantillas predeterminadas de título y descripción para cada tipo de contenido.",
    "Available variables:": "Variables disponibles:",
    "Content Type": "Tipo de contenido",
    "Title Template": "Plantilla de título",
    "Description Template": "Plantilla de descripción",
    "General Meta": "Meta general",
    "Authors": "Autores",
    "Misc Pages": "Páginas varias",
    "Taxonomies": "Taxonomías",
    "Post Types": "Tipos de entrada",
    "Homepage Title": "Título de la página de inicio",
    "Homepage Description": "Descripción de la página de inicio",
    "Author Archive Title": "Título del archivo de autor",
    "Author Archive Description": "Descripción del archivo de autor",
    "Blog Page Title": "Título de la página del blog",
    "Blog Page Description": "Descripción de la página del blog",
    "Search Results Title": "Título de resultados de búsqueda",
    "Search Results Description": "Descripción de resultados de búsqueda",
    "Date Archive Title": "Título del archivo por fecha",
    "Date Archive Description": "Descripción del archivo por fecha",
    "404 Title": "Título 404",
    "404 Description": "Descripción 404",
    "%s Title": "Título de %s",
    "%s Description": "Descripción de %s",
    "Page Not Found": "Página no encontrada",

    # ── Post Meta Basic ──
    "Google Preview": "Vista previa de Google",
    "Edit Snippet": "Editar fragmento",
    "Focus Keyword": "Palabra clave principal",
    "e.g. Rank Math SEO": "p. ej. Rank Math SEO",
    "Basic SEO": "SEO básico",
    "Keyword Density:": "Densidad de palabras clave:",
    "Readability": "Legibilidad",
    "Readability:": "Legibilidad:",
    "Additional SEO": "SEO adicional",
    "Extra on-page checks to improve visibility.":
        "Comprobaciones adicionales en la página para mejorar la visibilidad.",
    "These settings override global robots meta for this page":
        "Estos ajustes anulan los robots meta globales para esta página",
    "Prevent indexing of this page":
        "Impedir la indexación de esta página",
    "Prevent following links":
        "Impedir el seguimiento de enlaces",
    "Prevent cached copy":
        "Impedir la copia en caché",
    "Prevent snippet display":
        "Impedir la visualización del fragmento",
    "Prevent image indexing":
        "Impedir la indexación de imágenes",
    "Max Snippet": "Fragmento máximo",
    "Text length (-1 = unlimited)": "Longitud de texto (-1 = ilimitado)",
    "Max Video Preview": "Vista previa máxima de vídeo",
    "Video length in seconds": "Duración del vídeo en segundos",
    "Max Image Preview": "Vista previa máxima de imagen",
    "Default": "Predeterminado",
    "Preview size": "Tamaño de vista previa",
    "Canonical URL": "URL canonical",
    "Defaults to current page URL":
        "Se establece por defecto a la URL de la página actual",

    # ── Post Meta Schema ──
    "Article": "Artículo",
    "Blog Posting": "Publicación de blog",
    "News Article": "Artículo de noticias",
    "Product": "Producto",
    "Review": "Reseña",
    "Recipe": "Receta",
    "FAQ Page": "Página de preguntas frecuentes",
    "How To": "Cómo hacer",
    "BreadcrumbList": "BreadcrumbList",
    "Table": "Tabla",
    "Service": "Servicio",
    "Job Posting": "Oferta de empleo",
    "Course": "Curso",
    "Event": "Evento",
    "Local Business": "Negocio local",
    "Organization": "Organización",
    "Person": "Persona",
    "Video Object": "Objeto de vídeo",
    "Book": "Libro",
    "Software Application": "Aplicación de software",
    "Used Schema": "Schema utilizado",
    "Custom JSON-LD": "JSON-LD personalizado",
    "Preview": "Vista previa",
    "Remove": "Eliminar",
    "No schema selected yet. Use Schema Generator to apply.":
        "Aún no se ha seleccionado ningún Schema. Use el generador de Schema para aplicar.",
    "Schema Generator": "Generador de Schema",
    "Schema Templates": "Plantillas de Schema",
    "Import": "Importar",
    "No schema selected. Choose a template or import JSON-LD.":
        "No se ha seleccionado ningún Schema. Elija una plantilla o importe JSON-LD.",
    "Available Schema Types": "Tipos de Schema disponibles",
    "Apply": "Aplicar",
    "Schema Settings": "Ajustes de Schema",
    "Schema JSON-LD Preview": "Vista previa de Schema JSON-LD",
    "Import JSON-LD": "Importar JSON-LD",
    "Paste JSON-LD": "Pegar JSON-LD",
    "Paste valid JSON-LD without the %s tag":
        "Pegue JSON-LD válido sin la etiqueta %s",
    "Apply JSON-LD": "Aplicar JSON-LD",
    "Custom JSON-LD Preview": "Vista previa de JSON-LD personalizado",
    "Done": "Hecho",
    "Schema fields for this type will be available soon. You can manually add schema using the JSON-LD editor above.":
        "Los campos de Schema para este tipo estarán disponibles pronto. Puede añadir Schema manualmente usando el editor JSON-LD de arriba.",

    # ── Article Schema ──
    "Article Schema Details": "Detalles de Schema de artículo",
    "Headline": "Titular",
    "Article headline (defaults to post title)":
        "Titular del artículo (por defecto, el título de la entrada)",
    "Author Name": "Nombre del autor",
    "Author of the article": "Autor del artículo",
    "Publisher Name": "Nombre del editor",
    "Publisher organization name": "Nombre de la organización editora",
    "Publisher Logo URL": "URL del logotipo del editor",
    "URL of publisher's logo (recommended: 600x60px)":
        "URL del logotipo del editor (recomendado: 600x60px)",
    "Featured Image URL": "URL de la imagen destacada",
    "Main image for the article": "Imagen principal del artículo",
    "Date Published": "Fecha de publicación",
    "When was this article published?": "¿Cuándo fue publicado este artículo?",
    "Date Modified": "Fecha de modificación",
    "Last modification date": "Fecha de la última modificación",

    # ── Product Schema ──
    "Product Schema Details": "Detalles de Schema de producto",
    "Product Name": "Nombre del producto",
    "Price": "Precio",
    "Currency": "Moneda",
    "Availability": "Disponibilidad",
    "In Stock": "En stock",
    "Out of Stock": "Sin stock",
    "Pre Order": "Preventa",
    "Brand": "Marca",
    "SKU": "SKU",

    # ── FAQ Schema ──
    "FAQ Schema Details": "Detalles de Schema de preguntas frecuentes",
    "Add frequently asked questions and their answers":
        "Añada preguntas frecuentes y sus respuestas",
    "Question %d": "Pregunta %d",
    "What is your question?": "¿Cuál es su pregunta?",
    "Answer": "Respuesta",
    "Type the answer here...": "Escriba la respuesta aquí...",
    "Add FAQ Item": "Añadir elemento de FAQ",

    # ── How-To Schema ──
    "How-To Schema Details": "Detalles de Schema de Cómo hacer",
    "Guide Name": "Nombre de la guía",
    "Description": "Descripción",
    "Steps": "Pasos",
    "Step %d Name": "Nombre del paso %d",
    "Step Description": "Descripción del paso",
    "Remove Step": "Eliminar paso",
    "Add Step": "Añadir paso",

    # ── Review Schema ──
    "Review Schema Details": "Detalles de Schema de reseña",
    "Item Reviewed": "Elemento reseñado",
    "Rating (1-5)": "Puntuación (1-5)",
    "Reviewer Name": "Nombre del revisor",
    "Review Date": "Fecha de la reseña",

    # ── Recipe Schema ──
    "Recipe Schema Details": "Detalles de Schema de receta",
    "Recipe Name": "Nombre de la receta",
    "Prep Time (minutes)": "Tiempo de preparación (minutos)",
    "Cook Time (minutes)": "Tiempo de cocción (minutos)",
    "Servings": "Porciones",
    "4 servings": "4 porciones",
    "Calories": "Calorías",
    "Ingredients (one per line)": "Ingredientes (uno por línea)",
    "Instructions": "Instrucciones",

    # ── Event Schema ──
    "Event Schema Details": "Detalles de Schema de evento",
    "Event Name": "Nombre del evento",
    "Start Date & Time": "Fecha y hora de inicio",
    "End Date & Time": "Fecha y hora de finalización",
    "Location Name": "Nombre del lugar",
    "Address": "Dirección",

    # ── Video Schema ──
    "Video Schema Details": "Detalles de Schema de vídeo",
    "Video Title": "Título del vídeo",
    "Video URL": "URL del vídeo",
    "Thumbnail URL": "URL de la miniatura",
    "Upload Date": "Fecha de subida",
    "Duration (ISO 8601)": "Duración (ISO 8601)",
    "Format: PT1H30M (1 hour 30 minutes)":
        "Formato: PT1H30M (1 hora 30 minutos)",

    # ── BreadcrumbList Schema ──
    "BreadcrumbList Details": "Detalles de BreadcrumbList",
    "Enter one breadcrumb per line: Label | URL":
        "Introduzca una miga de pan por línea: Etiqueta | URL",

    # ── Table Schema ──
    "Table Schema Details": "Detalles de Schema de tabla",
    "Table Name": "Nombre de la tabla",
    "Rows": "Filas",
    "Use one row per line, columns separated by |":
        "Use una fila por línea, columnas separadas por |",

    # ── Service Schema ──
    "Service Schema Details": "Detalles de Schema de servicio",
    "Service Name": "Nombre del servicio",
    "Provider Name": "Nombre del proveedor",
    "Area Served": "Área de servicio",
    "Service Type": "Tipo de servicio",

    # ── Job Posting Schema ──
    "Job Posting Details": "Detalles de oferta de empleo",
    "Job Title": "Título del puesto",
    "Date Posted": "Fecha de publicación",
    "Valid Through": "Válido hasta",
    "Employment Type": "Tipo de empleo",
    "Full-time": "Tiempo completo",
    "Hiring Organization": "Organización contratante",
    "Job Location": "Ubicación del puesto",
    "City, Country": "Ciudad, País",

    # ── Social Preview ──
    "Social Preview": "Vista previa social",
    "Facebook": "Facebook",
    "Twitter": "Twitter",
    "Facebook user": "Usuario de Facebook",
    "2 hours ago": "Hace 2 horas",
    "FB Preview": "Vista previa de FB",
    "Twitter user": "Usuario de Twitter",
    "2 hours": "2 horas",
    "Post with a link!": "¡Publicación con enlace!",
    "Twitter Preview": "Vista previa de Twitter",
    "Social Settings": "Ajustes sociales",
    "All Networks": "Todas las redes",
    "Title": "Título",
    "Title for all networks": "Título para todas las redes",
    "Description for all networks": "Descripción para todas las redes",
    "Image": "Imagen",
    "Choose Image": "Elegir imagen",
    "Values apply to Facebook and Twitter":
        "Los valores se aplican a Facebook y Twitter",
    "Facebook Title": "Título de Facebook",
    "Post title": "Título de la entrada",
    "SEO title": "Título SEO",
    "Separator —": "Separador —",
    "Category": "Categoría",
    "Publish date": "Fecha de publicación",
    "Facebook Image": "Imagen de Facebook",
    "Facebook Description": "Descripción de Facebook",
    "Post excerpt": "Extracto de la entrada",
    "SEO description": "Descripción SEO",
    "Site description": "Descripción del sitio",
    "Twitter Title": "Título de Twitter",
    "Summary Large Image": "Resumen con imagen grande",
    "Twitter Description": "Descripción de Twitter",
    "Twitter Image": "Imagen de Twitter",
    "OG Title": "Título OG",
    "OG Type": "Tipo OG",
    "Website": "Sitio web",
    "Video": "Vídeo",
    "OG Description": "Descripción OG",
    "Product short description": "Descripción corta del producto",
    "OG Image": "Imagen OG",
    "Select image": "Seleccionar imagen",
    "Facebook Preview": "Vista previa de Facebook",
    "2h": "2h",
    "Facebook Settings": "Ajustes de Facebook",
    "Twitter (X) Settings": "Ajustes de Twitter (X)",

    # ── Post Meta checks ──
    "Focus keyword is set": "La palabra clave principal está configurada",
    "Add a focus keyword": "Añadir una palabra clave principal",
    "Focus keyword in SEO title": "Palabra clave principal en el título SEO",
    "Add focus keyword to SEO title": "Añadir la palabra clave principal al título SEO",
    "Focus keyword in meta description": "Palabra clave principal en la meta descripción",
    "Add focus keyword to meta description": "Añadir la palabra clave principal a la meta descripción",
    "Focus keyword in content": "Palabra clave principal en el contenido",
    "Add focus keyword to content": "Añadir la palabra clave principal al contenido",
    "Focus keyword in URL": "Palabra clave principal en la URL",
    "Add focus keyword to URL": "Añadir la palabra clave principal a la URL",
    "Keyword density is OK (0.5–2.5%)": "La densidad de palabras clave es correcta (0,5–2,5%)",
    "Keyword density out of range (0.5–2.5%)": "La densidad de palabras clave está fuera de rango (0,5–2,5%)",
    "SEO title length is OK (50–60)": "La longitud del título SEO es correcta (50–60)",
    "Optimize SEO title length (50–60)": "Optimizar la longitud del título SEO (50–60)",
    "Meta description length is OK (120–160)": "La longitud de la meta descripción es correcta (120–160)",
    "Optimize meta description length (120–160)": "Optimizar la longitud de la meta descripción (120–160)",
    "Content length is sufficient (300+ words)": "La longitud del contenido es suficiente (más de 300 palabras)",
    "Add more content (minimum 300 words)": "Añadir más contenido (mínimo 300 palabras)",
    "H1 heading is present": "El encabezado H1 está presente",
    "Add an H1 heading": "Añadir un encabezado H1",
    "H2 subheadings are present": "Los subencabezados H2 están presentes",
    "Add H2 subheadings": "Añadir subencabezados H2",
    "Images have alt attributes": "Las imágenes tienen atributos alt",
    "Add alt attributes to images": "Añadir atributos alt a las imágenes",
    "Internal link is present": "Hay un enlace interno presente",
    "Add an internal link": "Añadir un enlace interno",
    "Enough sentences for readability": "Suficientes oraciones para la legibilidad",
    "Add more sentences": "Añadir más oraciones",
    "Average sentence length is OK": "La longitud promedio de las oraciones es correcta",
    "Make sentences shorter": "Acortar las oraciones",
    "No overly long sentences": "No hay oraciones demasiado largas",
    "There are overly long sentences": "Hay oraciones demasiado largas",
    "Multiple paragraphs detected": "Se detectaron múltiples párrafos",
    "Split text into paragraphs": "Dividir el texto en párrafos",
    "Paragraph length is OK": "La longitud del párrafo es correcta",
    "Make paragraphs shorter": "Acortar los párrafos",
    "Lists are present": "Hay listas presentes",
    "Add lists (ul/ol)": "Añadir listas (ul/ol)",
    "Excellent": "Excelente",
    "Okay": "Aceptable",
    "Needs work": "Necesita mejoras",
    "Select an image": "Seleccionar una imagen",
    "Use this image": "Usar esta imagen",
    "Keyword in first paragraph": "Palabra clave en el primer párrafo",
    "Add keyword to first paragraph": "Añadir la palabra clave al primer párrafo",
    "URL length is OK": "La longitud de la URL es correcta",
    "Shorten URL (up to 75 chars)": "Acortar la URL (hasta 75 caracteres)",
    "External link is present": "Hay un enlace externo presente",
    "Add an external link": "Añadir un enlace externo",
    "Images are present in content": "Hay imágenes presentes en el contenido",
    "Add an image": "Añadir una imagen",
    "Scan Content": "Escanear contenido",
    "Scanning...": "Escaneando...",
    "Linked!": "¡Enlazado!",
    "Not found": "No encontrado",
    "Untitled": "Sin título",
    "No description available": "No hay descripción disponible",

    # ── Post Meta Tabs ──
    "SEO Basics": "Fundamentos de SEO",
    "Advanced": "Avanzado",
    "Schema": "Schema",
    "Edit SEO Snippet": "Editar fragmento SEO",
    "General": "General",
    "Social": "Social",
    "SEO Title": "Título SEO",
    "Separator -, —": "Separador -, —",
    "Parent page": "Página padre",
    "Tag": "Etiqueta",
    "Taxonomy term": "Término de taxonomía",
    "Current date": "Fecha actual",
    "Current year": "Año actual",
    "Author name": "Nombre del autor",
    "Page number (2 of 4)": "Número de página (2 de 4)",
    "Post type (singular)": "Tipo de entrada (singular)",
    "Search query": "Consulta de búsqueda",
    "Meta Description": "Meta descripción",
    "Excerpt field only": "Solo campo de extracto",
    "Term description": "Descripción del término",
    "Author bio": "Biografía del autor",
    "Meta Keywords": "Meta palabras clave",
    "Focus keyword": "Palabra clave principal",
    "Keywords": "Palabras clave",
    "Tags": "Etiquetas",
    "All categories": "Todas las categorías",
    "Separate keywords with commas": "Separe las palabras clave con comas",
    "Cancel": "Cancelar",

    # ── PRO Features ──
    "PRO": "PRO",
    "Unlimited Redirects": "Redirecciones ilimitadas",
    "Unlimited 404 Monitoring": "Monitoreo 404 ilimitado",
    "AI Bot Blocking": "Bloqueo de bots de IA",
    "Schema Markup": "Marcado Schema",
    "Social Cards": "Tarjetas sociales",
    "FREE": "GRATUITO",
    "50 Redirects": "50 redirecciones",
    "100 404 Logs": "100 registros 404",
    "Meta Tags": "Meta etiquetas",
    "Upgrade to PRO to unlock %s": "Actualizar a PRO para desbloquear %s",
    "This feature requires a PRO license.":
        "Esta función requiere una licencia PRO.",
    "This feature requires %1$sPRO license%2$s.":
        "Esta función requiere una %1$slicencia PRO%2$s.",
    "FREE plan limited to %d items. Upgrade to PRO for unlimited.":
        "El plan GRATUITO está limitado a %d elementos. Actualice a PRO para ilimitados.",
    "FREE plan limited to %1$d items. %2$sUpgrade to PRO%3$s for unlimited.":
        "El plan GRATUITO está limitado a %1$d elementos. %2$sActualice a PRO%3$s para ilimitados.",

    # ── Redirects class ──
    "FREE plan limit reached (%d redirects). Upgrade to PRO for unlimited redirects.":
        "Límite del plan GRATUITO alcanzado (%d redirecciones). Actualice a PRO para redirecciones ilimitadas.",
    "FREE plan limit reached (%1$d redirects). %2$sUpgrade to PRO%3$s for unlimited redirects.":
        "Límite del plan GRATUITO alcanzado (%1$d redirecciones). %2$sActualice a PRO%3$s para redirecciones ilimitadas.",
    "Please fill in all fields.": "Por favor, complete todos los campos.",
    "A redirect with this source already exists.":
        "Ya existe una redirección con este origen.",
    "Redirect added successfully.": "Redirección añadida con éxito.",
    "Failed to add redirect.": "Error al añadir la redirección.",
    "Redirect deleted.": "Redirección eliminada.",
    "Failed to delete redirect.": "Error al eliminar la redirección.",
    "Status updated.": "Estado actualizado.",
    "Failed to update status.": "Error al actualizar el estado.",
    "Redirects table is not created.":
        "La tabla de redirecciones no ha sido creada.",
    "Redirect updated.": "Redirección actualizada.",
    "Failed to update redirect.": "Error al actualizar la redirección.",
    "Table created.": "Tabla creada.",
    "CSV file is required.": "Se requiere un archivo CSV.",
    "Failed to read CSV file.": "Error al leer el archivo CSV.",
    "Invalid CSV header.": "Encabezado de CSV no válido.",

    # ── Robots.txt ──
    "Robots.txt Settings": "Ajustes de Robots.txt",
    "Enable virtual robots.txt": "Activar robots.txt virtual",
    "robots.txt Content": "Contenido de robots.txt",
    "Additional User-agent Blocks": "Bloques adicionales de User-agent",
    "Crawl-delay for bots": "Crawl-delay para bots",
    "Use dynamic variables": "Usar variables dinámicas",
    "Block AI bots": "Bloquear bots de IA",
    "Block web archive bots": "Bloquear bots de archivos web",
    "Reset settings": "Restablecer ajustes",
    "Current robots.txt": "robots.txt actual",
    "Warning!": "¡Advertencia!",
    "A physical robots.txt file was found in the site root.":
        "Se encontró un archivo robots.txt físico en la raíz del sitio.",
    "It takes precedence over the virtual WordPress robots.txt.":
        "Tiene prioridad sobre el robots.txt virtual de WordPress.",
    "Show physical file contents": "Mostrar contenido del archivo físico",
    "No physical robots.txt file found in the site root.":
        "No se encontró un archivo robots.txt físico en la raíz del sitio.",
    "The virtual WordPress robots.txt is used.":
        "Se utiliza el robots.txt virtual de WordPress.",
    "robots.txt editor. Available variables:":
        "Editor de robots.txt. Variables disponibles:",
    "Additional rule blocks for specific user agents. Example:":
        "Bloques de reglas adicionales para agentes de usuario específicos. Ejemplo:",
    "Format: one line = %s, for example:":
        "Formato: una línea = %s, por ejemplo:",
    "Converted to %s directives for the listed bots.":
        "Convertido a directivas %s para los bots listados.",
    "Automatically replace": "Reemplazar automáticamente",
    "Block AI crawlers (GPTBot, ChatGPT-User, Google-Extended, Omgilibot, ClaudeBot, Claude-Web)":
        "Bloquear rastreadores de IA (GPTBot, ChatGPT-User, Google-Extended, Omgilibot, ClaudeBot, Claude-Web)",
    "When enabled, robots.txt will include Disallow rules for popular AI crawlers.":
        "Cuando está activado, robots.txt incluirá reglas Disallow para rastreadores de IA populares.",
    "to unlock": "para desbloquear",
    "Block web archive bots (Wayback Machine, Archive.org, archive.is, and others)":
        "Bloquear bots de archivos web (Wayback Machine, Archive.org, archive.is y otros)",
    "When enabled, web archive services cannot store copies of your site.":
        "Cuando está activado, los servicios de archivo web no pueden almacenar copias de su sitio.",
    "This helps protect unique content and prevents unauthorized archiving.":
        "Esto ayuda a proteger el contenido único y previene el archivado no autorizado.",
    "Reset to defaults": "Restablecer valores predeterminados",
    "Restores robots.txt to default values.":
        "Restaura robots.txt a los valores predeterminados.",
    "All custom changes will be lost.":
        "Todos los cambios personalizados se perderán.",
    "Are you sure? All robots.txt settings will be reset.":
        "¿Está seguro? Todos los ajustes de robots.txt se restablecerán.",
    "Resetting...": "Restableciendo...",
    "Reset complete!": "¡Restablecimiento completado!",
    "unknown": "desconocido",
    "AJAX error": "Error AJAX",
    "Settings reset.": "Ajustes restablecidos.",

    # ── XML Sitemap ──
    "XML Sitemap Settings": "Ajustes del mapa del sitio XML",
    "Enable XML Sitemap": "Activar mapa del sitio XML",
    "Post Types for XML Sitemap": "Tipos de entrada para el mapa del sitio XML",
    "Include Images": "Incluir imágenes",
    "Exclude URLs": "Excluir URLs",
    "Additional URLs": "URLs adicionales",
    "HTML Sitemap Settings": "Ajustes del mapa del sitio HTML",
    "HTML Sitemap Slug": "Slug del mapa del sitio HTML",
    "Post Types for HTML Sitemap": "Tipos de entrada para el mapa del sitio HTML",
    "XML sitemap generation settings for search engines.":
        "Ajustes de generación del mapa del sitio XML para motores de búsqueda.",
    "HTML sitemap settings for site visitors.":
        "Ajustes del mapa del sitio HTML para visitantes del sitio.",
    "Enable XML sitemap generation": "Activar la generación del mapa del sitio XML",
    "Generates dynamic XML sitemap files for search engines.":
        "Genera archivos dinámicos de mapa del sitio XML para motores de búsqueda.",
    "Select post types to include in the XML sitemap and configure parameters for each type.":
        "Seleccione los tipos de entrada para incluir en el mapa del sitio XML y configure los parámetros para cada tipo.",
    "Priority:": "Prioridad:",
    "Changefreq:": "Frecuencia de cambio:",
    "Always": "Siempre",
    "Hourly": "Cada hora",
    "Daily": "Diariamente",
    "Weekly": "Semanalmente",
    "Monthly": "Mensualmente",
    "Yearly": "Anualmente",
    "Never": "Nunca",
    "Include images in sitemap": "Incluir imágenes en el mapa del sitio",
    "Full or relative URLs to exclude from the XML sitemap (one per line).":
        "URLs completas o relativas para excluir del mapa del sitio XML (una por línea).",
    "Default priority and change frequency for all additional URLs (unless overridden individually below).":
        "Prioridad y frecuencia de cambio predeterminadas para todas las URLs adicionales (a menos que se modifiquen individualmente a continuación).",
    "Default Priority:": "Prioridad predeterminada:",
    "Default Changefreq:": "Frecuencia de cambio predeterminada:",
    "Additional URLs to add to the XML sitemap (one per line). These will use the default priority and changefreq above.":
        "URLs adicionales para añadir al mapa del sitio XML (una por línea). Usarán la prioridad y frecuencia de cambio predeterminadas de arriba.",
    "Per-URL Priority & Changefreq": "Prioridad y frecuencia de cambio por URL",
    "+ Add URL": "+ Añadir URL",
    "Override priority & changefreq per URL":
        "Anular la prioridad y frecuencia de cambio por URL",
    "Upgrade to PRO to set individual priority and change frequency for each additional URL in your sitemap.":
        "Actualice a PRO para establecer la prioridad y la frecuencia de cambio individual para cada URL adicional en su mapa del sitio.",
    "Priority": "Prioridad",
    "Changefreq": "Frecuencia de cambio",
    'No per-URL overrides yet. Click "+ Add URL" to add one.':
        'Aún no hay modificaciones por URL. Haga clic en "+ Añadir URL" para añadir una.',
    "HTML sitemap slug (e.g., html-sitemap)":
        "Slug del mapa del sitio HTML (p. ej., html-sitemap)",
    "Select which post types to show in the HTML sitemap.":
        "Seleccione qué tipos de entrada mostrar en el mapa del sitio HTML.",
    "XML Sitemap": "Mapa del sitio XML",
    "XML Sitemap Index": "Índice del mapa del sitio XML",
    "This is the XML sitemap index. Each link below points to a sitemap for a specific content type.":
        "Este es el índice del mapa del sitio XML. Cada enlace a continuación apunta a un mapa del sitio para un tipo de contenido específico.",
    "Total sitemap files:": "Total de archivos del mapa del sitio:",
    "Last Modified": "Última modificación",
    "Back to sitemap index": "Volver al índice del mapa del sitio",
    "This XML sitemap is intended for search engines such as Google, Bing, and Yandex.":
        "Este mapa del sitio XML está destinado a motores de búsqueda como Google, Bing y Yandex.",
    "URLs": "URLs",
    "Images": "Imágenes",
    "Page": "Página",
    "No entries available to display in the sitemap.":
        "No hay entradas disponibles para mostrar en el mapa del sitio.",

    # ── WooCommerce ──
    "SEO": "SEO",
    "Custom SEO title for this taxonomy. Variables: %term_title%, %sitename%, %sep%":
        "Título SEO personalizado para esta taxonomía. Variables: %term_title%, %sitename%, %sep%",
    "Custom meta description for this taxonomy page.":
        "Meta descripción personalizada para esta página de taxonomía.",
    "Open Graph Image": "Imagen de Open Graph",
    "Custom social sharing image for this taxonomy page.":
        "Imagen personalizada para compartir en redes sociales para esta página de taxonomía.",
    "Custom SEO title. Variables: %term_title%, %sitename%, %sep%":
        "Título SEO personalizado. Variables: %term_title%, %sitename%, %sep%",
    "WooCommerce is not installed or activated. This module requires WooCommerce to function.":
        "WooCommerce no está instalado o activado. Este módulo requiere WooCommerce para funcionar.",
    "WooCommerce SEO settings saved.":
        "Ajustes de WooCommerce SEO guardados.",
    "WooCommerce Overview": "Resumen de WooCommerce",
    "Products": "Productos",
    "Categories": "Categorías",
    "ON": "ACTIVADO",
    "OFF": "DESACTIVADO",
    "Auto Schema": "Schema automático",
    "Product Schema (Structured Data)": "Schema de producto (datos estructurados)",
    "Automatically generate Product schema markup from WooCommerce product data.":
        "Generar automáticamente el marcado Schema de producto a partir de los datos de producto de WooCommerce.",
    "Auto-generate Product Schema": "Generar Schema de producto automáticamente",
    "Automatically create Product schema from WooCommerce data when saving a product":
        "Crear automáticamente el Schema de producto a partir de los datos de WooCommerce al guardar un producto",
    "Include Price": "Incluir precio",
    "Include product price and currency in schema":
        "Incluir el precio del producto y la moneda en el Schema",
    "Include Reviews": "Incluir reseñas",
    "Include average rating and review count in schema":
        "Incluir la puntuación media y el número de reseñas en el Schema",
    "Include Brand": "Incluir marca",
    "Include brand from product attribute":
        "Incluir la marca desde el atributo del producto",
    "Brand Attribute": "Atributo de marca",
    "Product attribute slug for brand (e.g., %1$s or %2$s)":
        "Slug del atributo de producto para la marca (p. ej., %1$s o %2$s)",
    "Remove WC Default Schema": "Eliminar Schema predeterminado de WC",
    "Remove WooCommerce's built-in structured data to prevent conflicts":
        "Eliminar los datos estructurados integrados de WooCommerce para evitar conflictos",
    "Warning: Only enable this if you are using SEO Fury to generate all product schema.":
        "Advertencia: Active esto solo si está usando SEO Fury para generar todo el Schema de productos.",
    "SEO Title Templates": "Plantillas de título SEO",
    "Default SEO title/description templates for products and taxonomies. These are used when individual products don't have custom SEO titles set.":
        "Plantillas predeterminadas de título/descripción SEO para productos y taxonomías. Se utilizan cuando los productos individuales no tienen títulos SEO personalizados configurados.",
    "Product Title Template": "Plantilla de título de producto",
    "Variables: %1$s, %2$s, %3$s, %4$s": "Variables: %1$s, %2$s, %3$s, %4$s",
    "Product Description Template": "Plantilla de descripción de producto",
    "Variables: %1$s, %2$s, %3$s": "Variables: %1$s, %2$s, %3$s",
    "Product Category Title": "Título de categoría de producto",
    "Product Tag Title": "Título de etiqueta de producto",
    "Save WooCommerce Settings": "Guardar ajustes de WooCommerce",

    # ── seo-fury.php ──
    "Manifest updated!": "¡Manifiesto actualizado!",

    # ── Additional strings ──
    "AUTO": "AUTO",
    "MANUAL": "MANUAL",
    "N/A": "N/A",
    "// Paste your JSON-LD here": "// Pegue su JSON-LD aquí",
    "JSON-LD is empty.": "JSON-LD está vacío.",
    "+ Link": "+ Enlace",
}


def parse_pot_file(pot_path):
    """Parse a .pot file and return a list of entries.
    Each entry is a dict with keys: comments, msgid, msgstr, flags, msgid_lines.
    Handles multiline msgid strings.
    """
    entries = []
    current_entry = {"comments": [], "msgid": "", "msgstr": "", "flags": [], "msgid_lines": []}
    in_msgid = False
    in_msgstr = False

    with open(pot_path, "r", encoding="utf-8") as f:
        lines = f.readlines()

    for line in lines:
        line = line.rstrip("\n")

        # Comment lines
        if line.startswith("#"):
            if in_msgid or in_msgstr:
                # Save previous entry
                if current_entry["msgid"] is not None:
                    entries.append(current_entry)
                current_entry = {"comments": [], "msgid": "", "msgstr": "", "flags": [], "msgid_lines": []}
                in_msgid = False
                in_msgstr = False

            current_entry["comments"].append(line)
            if line.startswith("#,"):
                current_entry["flags"].append(line)
            continue

        # msgid line
        if line.startswith("msgid "):
            if in_msgstr:
                # Save previous entry
                entries.append(current_entry)
                current_entry = {"comments": [], "msgid": "", "msgstr": "", "flags": [], "msgid_lines": []}
            in_msgid = True
            in_msgstr = False
            # Extract the string
            val = extract_string(line[6:])
            current_entry["msgid"] = val
            current_entry["msgid_lines"] = [line]
            continue

        # msgstr line
        if line.startswith("msgstr "):
            in_msgid = False
            in_msgstr = True
            val = extract_string(line[7:])
            current_entry["msgstr"] = val
            continue

        # Continuation line (starts with ")
        if line.startswith('"'):
            val = extract_string(line)
            if in_msgid:
                current_entry["msgid"] += val
                current_entry["msgid_lines"].append(line)
            elif in_msgstr:
                current_entry["msgstr"] += val
            continue

        # Empty line - save entry
        if line.strip() == "":
            if current_entry["msgid"] is not None and (current_entry["msgid"] != "" or current_entry["comments"]):
                entries.append(current_entry)
                current_entry = {"comments": [], "msgid": "", "msgstr": "", "flags": [], "msgid_lines": []}
                in_msgid = False
                in_msgstr = False
            continue

    # Don't forget last entry
    if current_entry["msgid"] is not None and (current_entry["msgid"] != "" or current_entry["comments"]):
        entries.append(current_entry)

    return entries


def extract_string(s):
    """Extract string content from a .po quoted string like '"Hello world"'."""
    s = s.strip()
    if s.startswith('"') and s.endswith('"'):
        s = s[1:-1]
    # Unescape
    s = s.replace('\\"', '"')
    # Convert \n escape to actual newline
    s = s.replace('\\n', '\n')
    return s


def escape_po_string(s):
    """Escape a string for .po file format. Does NOT handle newlines (those are handled separately)."""
    s = s.replace('"', '\\"')
    return s


def format_msgstr(msgstr_value):
    """Format a msgstr value, handling multiline strings with actual newlines."""
    if "\n" in msgstr_value:
        # Multiline: empty first line, then each line piece
        parts = msgstr_value.split("\n")
        lines = ['msgstr ""']
        for i, part in enumerate(parts):
            escaped = escape_po_string(part)
            if i < len(parts) - 1:
                lines.append(f'"{escaped}\\n"')
            else:
                lines.append(f'"{escaped}"')
        return "\n".join(lines)
    else:
        return f'msgstr "{escape_po_string(msgstr_value)}"'


def format_msgid(msgid_value):
    """Format a msgid value, handling multiline strings with actual newlines."""
    if "\n" in msgid_value:
        parts = msgid_value.split("\n")
        lines = ['msgid ""']
        for i, part in enumerate(parts):
            escaped = escape_po_string(part)
            if i < len(parts) - 1:
                lines.append(f'"{escaped}\\n"')
            else:
                lines.append(f'"{escaped}"')
        return "\n".join(lines)
    else:
        return f'msgid "{escape_po_string(msgid_value)}"'


def write_po_file(po_path, entries, translations):
    """Write the .po file with Spanish translations."""
    now = datetime.datetime.now().strftime("%Y-%m-%d %H:%M+0000")

    header = f'''# Translation of SEO Fury in Spanish (Spain)
# This file is distributed under the GPL v2 or later.
msgid ""
msgstr ""
"Project-Id-Version: SEO Fury 0.1.5\\n"
"Report-Msgid-Bugs-To: https://wordpress.org/support/plugin/seo-fury\\n"
"Last-Translator: SEO Fury Team <support@seo-fury.com>\\n"
"Language-Team: Spanish (Spain) <es_ES@li.org>\\n"
"Language: es_ES\\n"
"Plural-Forms: nplurals=2; plural=(n != 1);\\n"
"MIME-Version: 1.0\\n"
"Content-Type: text/plain; charset=UTF-8\\n"
"Content-Transfer-Encoding: 8bit\\n"
"POT-Creation-Date: 2026-02-08T09:27:12+00:00\\n"
"PO-Revision-Date: {now}\\n"
"X-Generator: SEO Fury Translation Script 1.0\\n"
"X-Domain: seo-fury\\n"
'''

    translated_count = 0
    untranslated_count = 0
    total_strings = 0

    with open(po_path, "w", encoding="utf-8") as f:
        f.write(header)
        f.write("\n")

        for entry in entries:
            msgid = entry["msgid"]

            # Skip the header entry (empty msgid)
            if msgid == "":
                continue

            total_strings += 1

            # Write comments
            for comment in entry["comments"]:
                f.write(comment + "\n")

            # Write msgid (handle multiline)
            f.write(format_msgid(msgid) + "\n")

            # Look up translation
            if msgid in translations:
                translation = translations[msgid]
                f.write(format_msgstr(translation) + "\n")
                translated_count += 1
            else:
                f.write('msgstr ""\n')
                untranslated_count += 1

            f.write("\n")

    return total_strings, translated_count, untranslated_count


def main():
    print(f"Reading .pot file: {POT_FILE}")
    entries = parse_pot_file(POT_FILE)
    print(f"Total entries parsed: {len(entries)}")

    # Count non-header entries
    string_entries = [e for e in entries if e["msgid"] != ""]
    print(f"Translatable strings: {len(string_entries)}")
    print(f"Translations available: {len(TRANSLATIONS)}")

    print(f"\nWriting .po file: {PO_FILE}")
    total, translated, untranslated = write_po_file(PO_FILE, entries, TRANSLATIONS)

    print(f"\n{'='*50}")
    print(f"Results:")
    print(f"  Total strings:    {total}")
    print(f"  Translated:       {translated}")
    print(f"  Untranslated:     {untranslated}")
    print(f"  Coverage:         {translated/total*100:.1f}%")
    print(f"{'='*50}")

    if untranslated > 0:
        print(f"\nMissing translations ({untranslated}):")
        for entry in entries:
            if entry["msgid"] != "" and entry["msgid"] not in TRANSLATIONS:
                print(f"  - \"{entry['msgid'][:80]}{'...' if len(entry['msgid']) > 80 else ''}\"")


if __name__ == "__main__":
    main()
