#!/usr/bin/env python3
"""
Generate complete French (fr_FR) translation .po file for SEO Fury WordPress plugin.
Reads the .pot template and produces a fully translated .po file.
"""

import re
import os
import sys
from datetime import datetime

# ─── Configuration ───────────────────────────────────────────────────────────

SCRIPT_DIR = os.path.dirname(os.path.abspath(__file__))
POT_FILE = os.path.join(SCRIPT_DIR, "seo-fury.pot")
PO_FILE = os.path.join(SCRIPT_DIR, "seo-fury-fr_FR.po")

# ─── French Translation Dictionary ──────────────────────────────────────────
# Every msgid from the .pot file mapped to its French translation.
# Rules:
#   - "SEO Fury" is NOT translated
#   - Technical terms kept in English: SEO, URL, HTTPS, SSL, HSTS, API, CSV,
#     JSON-LD, Schema, IndexNow, robots.txt, noindex, nofollow, canonical,
#     Open Graph, WooCommerce, HTML, XML, PHP, HTTP, SKU, OG, RSS
#   - All %s, %d, %1$s, %2$s placeholders preserved exactly
#   - HTML tags preserved exactly
#   - Formal "vous" form used throughout

TRANSLATIONS = {
    # ── Plugin metadata ──────────────────────────────────────────────────
    "SEO Fury": "SEO Fury",
    "Complete SEO plugin with licensing, robots.txt, sitemaps, redirects, and IndexNow.":
        "Extension SEO compl\u00e8te avec gestion de licence, robots.txt, plans du site, redirections et IndexNow.",
    "SEO Fury Team": "SEO Fury Team",

    # ── 404 Monitor Settings ─────────────────────────────────────────────
    "404 Monitor Settings": "R\u00e9glages du moniteur 404",
    "Enable Monitoring": "Activer la surveillance",
    "Ignore Bots": "Ignorer les robots",
    "Auto Cleanup": "Nettoyage automatique",
    "Debug Logging": "Journalisation de d\u00e9bogage",
    "Track and analyze 404 errors on your site.":
        "Suivez et analysez les erreurs 404 sur votre site.",
    "Enable 404 tracking": "Activer le suivi des erreurs 404",
    "Do not log requests from search bots":
        "Ne pas enregistrer les requ\u00eates des robots de recherche",
    "Ignores Googlebot, Bingbot, Yandex, and other known bots.":
        "Ignore Googlebot, Bingbot, Yandex et les autres robots connus.",
    "days": "jours",
    "Automatically delete entries older than this number of days. 0 = never delete":
        "Supprimer automatiquement les entr\u00e9es plus anciennes que ce nombre de jours. 0 = ne jamais supprimer",
    "Enable verbose logging for diagnostics":
        "Activer la journalisation d\u00e9taill\u00e9e pour le diagnostic",
    "Writes detailed module logs to debug.log. Use for troubleshooting. Logs are in wp-content/debug.log (when WP_DEBUG_LOG is enabled).":
        "\u00c9crit des journaux d\u00e9taill\u00e9s dans debug.log. \u00c0 utiliser pour le d\u00e9pannage. Les journaux se trouvent dans wp-content/debug.log (lorsque WP_DEBUG_LOG est activ\u00e9).",
    "Insufficient permissions": "Permissions insuffisantes",
    "Logs cleared": "Journaux effac\u00e9s",
    "URL is required": "L\u2019URL est requise",
    "Invalid ID": "ID invalide",
    "Marked as resolved": "Marqu\u00e9 comme r\u00e9solu",
    "Entry deleted": "Entr\u00e9e supprim\u00e9e",
    "Please fill in all fields": "Veuillez remplir tous les champs",
    "A redirect with this source already exists":
        "Une redirection avec cette source existe d\u00e9j\u00e0",
    "Redirect created successfully!": "Redirection cr\u00e9\u00e9e avec succ\u00e8s\u00a0!",
    "Error creating redirect: ": "Erreur lors de la cr\u00e9ation de la redirection\u00a0: ",
    "URL": "URL",
    "Hits": "Visites",
    "First Seen": "Premi\u00e8re occurrence",
    "Last Seen": "Derni\u00e8re occurrence",
    "Status": "Statut",
    "Resolved": "R\u00e9solu",
    "Active": "Actif",
    "Loading...": "Chargement...",
    "No redirects found": "Aucune redirection trouv\u00e9e",
    "Inactive": "Inactif",
    "Activate": "Activer",
    "Deactivate": "D\u00e9sactiver",
    "Edit": "Modifier",
    "Delete": "Supprimer",
    "Adding...": "Ajout en cours...",
    "Deleting...": "Suppression en cours...",
    "Saving...": "Enregistrement...",
    "Updating...": "Mise \u00e0 jour en cours...",
    "Please fill all fields": "Veuillez remplir tous les champs",
    "Redirect added successfully!": "Redirection ajout\u00e9e avec succ\u00e8s\u00a0!",
    "Redirect deleted!": "Redirection supprim\u00e9e\u00a0!",
    "Redirect updated!": "Redirection mise \u00e0 jour\u00a0!",
    "Are you sure you want to delete this redirect?":
        "\u00cates-vous s\u00fbr de vouloir supprimer cette redirection\u00a0?",
    "Error loading redirects": "Erreur lors du chargement des redirections",
    "Error loading data": "Erreur lors du chargement des donn\u00e9es",
    "Error adding redirect": "Erreur lors de l\u2019ajout de la redirection",
    "Error deleting redirect": "Erreur lors de la suppression de la redirection",
    "Error updating redirect": "Erreur lors de la mise \u00e0 jour de la redirection",
    "Error updating status": "Erreur lors de la mise \u00e0 jour du statut",
    "Please select a CSV file.": "Veuillez s\u00e9lectionner un fichier CSV.",
    "CSV import completed.": "Importation CSV termin\u00e9e.",
    "Imported": "Import\u00e9",
    "Updated": "Mis \u00e0 jour",
    "Skipped": "Ignor\u00e9",
    "Upload failed.": "\u00c9chec de l\u2019envoi.",
    "Error": "Erreur",
    "An error occurred": "Une erreur est survenue",

    # ── IndexNow JS strings ──────────────────────────────────────────────
    "Please enter at least one URL": "Veuillez saisir au moins une URL",
    "No valid URLs found": "Aucune URL valide trouv\u00e9e",
    "Maximum 10,000 URLs per request. You have:":
        "Maximum 10\u00a0000 URL par requ\u00eate. Vous avez\u00a0:",
    "Sending...": "Envoi en cours...",
    "Sending in batches...": "Envoi par lots...",
    "Generating...": "G\u00e9n\u00e9ration en cours...",
    "Checking...": "V\u00e9rification en cours...",
    "Success!": "Succ\u00e8s\u00a0!",
    "URLs sent:": "URL envoy\u00e9es\u00a0:",
    "Error!": "Erreur\u00a0!",
    "Unknown error": "Erreur inconnue",
    "Server connection error": "Erreur de connexion au serveur",
    "Settings saved": "R\u00e9glages enregistr\u00e9s",
    "Save error": "Erreur d\u2019enregistrement",
    "Key generated!": "Cl\u00e9 g\u00e9n\u00e9r\u00e9e\u00a0!",
    "Verify key": "V\u00e9rifier la cl\u00e9",
    "No history yet": "Aucun historique pour le moment",
    "Are you sure you want to clear the entire history?":
        "\u00cates-vous s\u00fbr de vouloir effacer tout l\u2019historique\u00a0?",
    "History cleared": "Historique effac\u00e9",
    "Clear failed": "\u00c9chec de l\u2019effacement",
    "Sending batch": "Envoi du lot",
    "of": "de",
    "All batches sent successfully!": "Tous les lots ont \u00e9t\u00e9 envoy\u00e9s avec succ\u00e8s\u00a0!",
    "Total URLs:": "Total des URL\u00a0:",
    "Batches:": "Lots\u00a0:",
    "Completed with errors": "Termin\u00e9 avec des erreurs",
    "Errors:": "Erreurs\u00a0:",

    # ── License JS strings ───────────────────────────────────────────────
    "Please enter a license key.": "Veuillez saisir une cl\u00e9 de licence.",
    "Invalid key format.": "Format de cl\u00e9 invalide.",
    "Activating...": "Activation en cours...",
    "License activated! The page will reload...":
        "Licence activ\u00e9e\u00a0! La page va se recharger...",
    "License activation failed": "\u00c9chec de l\u2019activation de la licence",
    "Activation server connection error":
        "Erreur de connexion au serveur d\u2019activation",
    "Are you sure you want to deactivate the license?\n\nAll PRO features will be disabled.":
        "\u00cates-vous s\u00fbr de vouloir d\u00e9sactiver la licence\u00a0?\n\nToutes les fonctionnalit\u00e9s PRO seront d\u00e9sactiv\u00e9es.",
    "Deactivating...": "D\u00e9sactivation en cours...",
    "License deactivated. The page will reload...":
        "Licence d\u00e9sactiv\u00e9e. La page va se recharger...",
    "Deactivation failed": "\u00c9chec de la d\u00e9sactivation",
    "License is active and valid!": "La licence est active et valide\u00a0!",
    "Plan:": "Forfait\u00a0:",
    "Status:": "Statut\u00a0:",
    "Expires:": "Expiration\u00a0:",
    "License is inactive or expired.": "La licence est inactive ou expir\u00e9e.",
    "Could not reach the license server. Using local cache.":
        "Impossible de contacter le serveur de licence. Utilisation du cache local.",
    "Key copied to clipboard!": "Cl\u00e9 copi\u00e9e dans le presse-papiers\u00a0!",
    "Click to copy": "Cliquez pour copier",

    # ── 404 Monitor JS strings ───────────────────────────────────────────
    "Load error": "Erreur de chargement",
    "No 404 errors found": "Aucune erreur 404 trouv\u00e9e",
    "Find": "Rechercher",
    "Redirect": "Redirection",
    "Resolve": "R\u00e9soudre",
    "Are you sure? All 404 logs will be deleted!":
        "\u00cates-vous s\u00fbr\u00a0? Tous les journaux 404 seront supprim\u00e9s\u00a0!",
    "Searching for similar pages...": "Recherche de pages similaires...",
    "Found %d similar pages:": "%d pages similaires trouv\u00e9es\u00a0:",
    "Use this URL": "Utiliser cette URL",
    "No similar pages found": "Aucune page similaire trouv\u00e9e",
    "Please provide a target URL": "Veuillez fournir une URL cible",
    "Creating...": "Cr\u00e9ation en cours...",
    "Redirect created successfully!": "Redirection cr\u00e9\u00e9e avec succ\u00e8s\u00a0!",
    "Error creating redirect": "Erreur lors de la cr\u00e9ation de la redirection",
    "Delete this entry?": "Supprimer cette entr\u00e9e\u00a0?",

    # ── Admin menu / tabs ────────────────────────────────────────────────
    "General Settings": "R\u00e9glages g\u00e9n\u00e9raux",
    "Meta Titles": "M\u00e9ta-titres",
    "Robots.txt": "Robots.txt",
    "Sitemap": "Plan du site",
    "Breadcrumbs": "Fil d\u2019Ariane",
    "Local SEO": "SEO local",
    "SSL & Security": "SSL et s\u00e9curit\u00e9",
    "WooCommerce SEO": "SEO WooCommerce",
    "Redirects": "Redirections",
    "404 Monitor": "Moniteur 404",
    "IndexNow": "IndexNow",
    "Changelog": "Journal des modifications",
    "License": "Licence",
    "Version %s": "Version %s",

    # ── Internal Linking ─────────────────────────────────────────────────
    "Internal Linking": "Maillage interne",
    "Scan your posts and pages for internal linking opportunities. The module analyzes your content and suggests relevant links to other published pages based on keyword and title matching.":
        "Analysez vos articles et pages \u00e0 la recherche d\u2019opportunit\u00e9s de maillage interne. Le module analyse votre contenu et sugg\u00e8re des liens pertinents vers d\u2019autres pages publi\u00e9es en fonction des mots-cl\u00e9s et des titres.",
    "Open any post or page in the editor and click the":
        "Ouvrez n\u2019importe quel article ou page dans l\u2019\u00e9diteur et cliquez sur l\u2019onglet",
    "Links": "Liens",
    "tab in the SEO Fury sidebar.": "dans la barre lat\u00e9rale SEO Fury.",
    "PRO Feature": "Fonctionnalit\u00e9 PRO",
    "Available in all PRO plans. Upgrade to unlock smart internal linking suggestions in the post editor.":
        "Disponible dans tous les forfaits PRO. Mettez \u00e0 niveau pour d\u00e9bloquer les suggestions de maillage interne intelligent dans l\u2019\u00e9diteur d\u2019articles.",
    "Upgrade": "Mettre \u00e0 niveau",

    # ── Sitemap Links section ────────────────────────────────────────────
    "Sitemap Links": "Liens du plan du site",
    "Index XML Sitemap:": "Plan du site XML (index)\u00a0:",
    "HTML Sitemap:": "Plan du site HTML\u00a0:",
    "You can also use the %s shortcode to display the HTML sitemap on any page.":
        "Vous pouvez \u00e9galement utiliser le shortcode %s pour afficher le plan du site HTML sur n\u2019importe quelle page.",

    # ── Redirects section ────────────────────────────────────────────────
    "Create 301, 302 and 307 redirects. Track total hits.":
        "Cr\u00e9ez des redirections 301, 302 et 307. Suivez le nombre total de visites.",
    "Redirects used: %1$s of %2$s": "Redirections utilis\u00e9es\u00a0: %1$s sur %2$s",
    "You are nearing the FREE plan limit.":
        "Vous approchez de la limite du forfait GRATUIT.",
    "PRO provides unlimited redirects.":
        "Le forfait PRO offre des redirections illimit\u00e9es.",
    "Upgrade to PRO": "Passer au PRO",
    "Add a new redirect": "Ajouter une nouvelle redirection",
    "Source URL": "URL source",
    "/old-page": "/ancienne-page",
    "Relative path, e.g. %s": "Chemin relatif, par ex. %s",
    "Target URL": "URL cible",
    "/new-page": "/nouvelle-page",
    "Full URL or relative path": "URL compl\u00e8te ou chemin relatif",
    "Redirect Type": "Type de redirection",
    "301 (Permanent)": "301 (Permanente)",
    "302 (Temporary)": "302 (Temporaire)",
    "307 (Temporary, preserves method)": "307 (Temporaire, pr\u00e9serve la m\u00e9thode)",
    "Add Redirect": "Ajouter une redirection",
    "Import / Export CSV": "Import / Export CSV",
    "Export all redirects or import a CSV with columns: %s.":
        "Exportez toutes les redirections ou importez un fichier CSV avec les colonnes\u00a0: %s.",
    "Export CSV": "Exporter en CSV",
    "Import CSV": "Importer un CSV",
    "Redirects List": "Liste des redirections",
    "ID": "ID",
    "Source": "Source",
    "Target": "Cible",
    "Type": "Type",
    "Created": "Cr\u00e9\u00e9",
    "Actions": "Actions",
    "Edit Redirect": "Modifier la redirection",
    "Save Changes": "Enregistrer les modifications",

    # ── IndexNow section ─────────────────────────────────────────────────
    "Submit URLs directly to the IndexNow API.":
        "Soumettez des URL directement \u00e0 l\u2019API IndexNow.",
    "Learn more": "En savoir plus",
    "Save Settings": "Enregistrer les r\u00e9glages",
    "Submit URLs": "Soumettre des URL",
    "URLs to submit": "URL \u00e0 soumettre",
    "Enter one URL per line...": "Saisissez une URL par ligne...",
    "Enter one URL per line. You can submit up to 10,000 URLs at once.":
        "Saisissez une URL par ligne. Vous pouvez soumettre jusqu\u2019\u00e0 10\u00a0000 URL \u00e0 la fois.",
    "Submit to IndexNow": "Soumettre \u00e0 IndexNow",
    "Submission History": "Historique des soumissions",
    "Last 100 IndexNow API requests.": "Les 100 derni\u00e8res requ\u00eates API IndexNow.",
    "Load History": "Charger l\u2019historique",
    "Clear History": "Effacer l\u2019historique",
    "Time": "Heure",
    "Response": "R\u00e9ponse",
    "Method": "M\u00e9thode",

    # ── 404 Monitor page ─────────────────────────────────────────────────
    "404 logs used: %1$s of %2$s": "Journaux 404 utilis\u00e9s\u00a0: %1$s sur %2$s",
    "PRO removes limits for 404 logging.":
        "Le forfait PRO supprime les limites de journalisation 404.",
    "Tracking 404 errors helps find broken links and create redirects.":
        "Le suivi des erreurs 404 aide \u00e0 trouver les liens bris\u00e9s et \u00e0 cr\u00e9er des redirections.",
    "404 Statistics": "Statistiques 404",
    "Total URLs": "Total des URL",
    "Total Hits": "Total des visites",
    "Refresh": "Actualiser",
    "Clear All": "Tout effacer",
    "Find a Similar Page": "Trouver une page similaire",
    "404 URL:": "URL 404\u00a0:",
    "Create Redirect": "Cr\u00e9er une redirection",
    "Source (404 URL)": "Source (URL 404)",
    "Target (Target URL)": "Cible (URL de destination)",

    # ── License page ─────────────────────────────────────────────────────
    "License Active": "Licence active",
    "License Key:": "Cl\u00e9 de licence\u00a0:",
    "Free": "Gratuit",
    "Pro Starter": "Pro Starter",
    "Pro Business": "Pro Business",
    "Pro Agency": "Pro Agency",
    "Lifetime": "\u00c0 vie",
    "Unknown": "Inconnu",
    "Domain:": "Domaine\u00a0:",
    "Available Features:": "Fonctionnalit\u00e9s disponibles\u00a0:",
    "Advanced SEO": "SEO avanc\u00e9",
    "Advanced SEO features": "Fonctionnalit\u00e9s SEO avanc\u00e9es",
    "Not available on your plan": "Non disponible avec votre forfait",
    "Unlimited redirects": "Redirections illimit\u00e9es",
    "Limited to 50": "Limit\u00e9 \u00e0 50",
    "Unlimited 404 logs": "Journaux 404 illimit\u00e9s",
    "404 Logs": "Journaux 404",
    "Limited to 100": "Limit\u00e9 \u00e0 100",
    "Smart link suggestions": "Suggestions de liens intelligentes",
    "White Label": "Marque blanche",
    "Branding": "Image de marque",
    "Not available": "Non disponible",
    "Priority Support": "Support prioritaire",
    "Priority support": "Support prioritaire",
    "Support": "Support",
    "Standard support": "Support standard",
    "Priority support is active": "Le support prioritaire est actif",
    "Reply within 24 hours": "R\u00e9ponse sous 24 heures",
    "Direct line to developers": "Ligne directe avec les d\u00e9veloppeurs",
    "Help with setup and optimization": "Aide \u00e0 la configuration et \u00e0 l\u2019optimisation",
    "Deactivate License": "D\u00e9sactiver la licence",
    "Check Status": "V\u00e9rifier le statut",
    "License Not Activated": "Licence non activ\u00e9e",
    "Enter a license key to activate plugin features.":
        "Saisissez une cl\u00e9 de licence pour activer les fonctionnalit\u00e9s de l\u2019extension.",
    "Supported formats:": "Formats pris en charge\u00a0:",
    "License Key": "Cl\u00e9 de licence",
    "PRO format: %s": "Format PRO\u00a0: %s",
    "FREE format: %s": "Format GRATUIT\u00a0: %s",
    "Activate License": "Activer la licence",
    "Available plans:": "Forfaits disponibles\u00a0:",
    "%s domain": "%s domaine",
    "%s redirects": "%s redirections",
    "%s 404 logs": "%s journaux 404",
    "month": "mois",
    "%s domains": "%s domaines",
    "Everything in Starter +": "Tout ce qui est dans Starter +",
    "Everything in Business +": "Tout ce qui est dans Business +",
    "All pro features": "Toutes les fonctionnalit\u00e9s Pro",
    "Unlimited domains": "Domaines illimit\u00e9s",
    "All features forever": "Toutes les fonctionnalit\u00e9s \u00e0 vie",
    "Lifetime updates": "Mises \u00e0 jour \u00e0 vie",
    "one-time": "unique",
    "Buy a license": "Acheter une licence",

    # ── SSL / Security ───────────────────────────────────────────────────
    "SSL / HTTPS Security": "S\u00e9curit\u00e9 SSL / HTTPS",
    "Protect your site with HTTPS enforcement, mixed content fixes, and security headers.":
        "Prot\u00e9gez votre site avec l\u2019application de HTTPS, la correction du contenu mixte et les en-t\u00eates de s\u00e9curit\u00e9.",
    "SSL Certificate": "Certificat SSL",
    "Not detected": "Non d\u00e9tect\u00e9",
    "HTTPS Redirect": "Redirection HTTPS",
    "Enabled": "Activ\u00e9",
    "Disabled": "D\u00e9sactiv\u00e9",
    "Mixed Content": "Contenu mixte",
    "Auto-fix on": "Correction automatique activ\u00e9e",
    "Not active": "Non actif",
    "HSTS Header": "En-t\u00eate HSTS",
    "Save Security Settings": "Enregistrer les r\u00e9glages de s\u00e9curit\u00e9",

    # ── Changelog ────────────────────────────────────────────────────────
    "All updates and improvements for the plugin":
        "Toutes les mises \u00e0 jour et am\u00e9liorations de l\u2019extension",
    "Current version": "Version actuelle",
    "Unable to load changelog. Please check your internet connection.":
        "Impossible de charger le journal des modifications. Veuillez v\u00e9rifier votre connexion Internet.",
    "Retry": "R\u00e9essayer",

    # ── Breadcrumbs ──────────────────────────────────────────────────────
    "Enable Breadcrumbs": "Activer le fil d\u2019Ariane",
    "Show Home Link": "Afficher le lien d\u2019accueil",
    "Home Label": "Libell\u00e9 de l\u2019accueil",
    "Home URL": "URL de l\u2019accueil",
    "Breadcrumb Prefix": "Pr\u00e9fixe du fil d\u2019Ariane",
    "Separator": "S\u00e9parateur",
    "Archive Format": "Format de l\u2019archive",
    "404 Label": "Libell\u00e9 de la page 404",
    "Hide Post Title": "Masquer le titre de l\u2019article",
    "Show Categories": "Afficher les cat\u00e9gories",
    "Hide Taxonomy Name": "Masquer le nom de la taxonomie",
    "How to display breadcrumbs": "Comment afficher le fil d\u2019Ariane",
    "Use this PHP snippet in your theme template:":
        "Utilisez cet extrait PHP dans votre mod\u00e8le de th\u00e8me\u00a0:",
    "Or use shortcode:": "Ou utilisez le shortcode\u00a0:",
    "Enable and configure breadcrumbs for your site.":
        "Activez et configurez le fil d\u2019Ariane pour votre site.",
    "Show breadcrumbs output": "Afficher la sortie du fil d\u2019Ariane",
    "Show link to the homepage": "Afficher le lien vers la page d\u2019accueil",
    "Home": "Accueil",
    "The label used for the homepage link (the first item) in breadcrumb trails.":
        "Le libell\u00e9 utilis\u00e9 pour le lien de la page d\u2019accueil (le premier \u00e9l\u00e9ment) dans le fil d\u2019Ariane.",
    "The homepage link (the first item) in breadcrumb trails. Leave empty to use the default homepage URL.":
        "Le lien de la page d\u2019accueil (le premier \u00e9l\u00e9ment) dans le fil d\u2019Ariane. Laissez vide pour utiliser l\u2019URL par d\u00e9faut.",
    "An element displayed before the breadcrumb trail.":
        "Un \u00e9l\u00e9ment affich\u00e9 avant le fil d\u2019Ariane.",
    "Custom": "Personnalis\u00e9",
    "Enter custom separator": "Saisissez un s\u00e9parateur personnalis\u00e9",
    'Search results for "%s"': 'R\u00e9sultats de recherche pour \u00ab\u00a0%s\u00a0\u00bb',
    "Format the label used for search results pages. Use %s as a placeholder for the search query.":
        "Formatez le libell\u00e9 utilis\u00e9 pour les pages de r\u00e9sultats de recherche. Utilisez %s comme espace r\u00e9serv\u00e9 pour la requ\u00eate de recherche.",
    "Page not found": "Page non trouv\u00e9e",
    "The label used for the 404 error page in breadcrumb trails.":
        "Le libell\u00e9 utilis\u00e9 pour la page d\u2019erreur 404 dans le fil d\u2019Ariane.",
    "Hide the post title in the breadcrumb trail":
        "Masquer le titre de l\u2019article dans le fil d\u2019Ariane",
    "If a category is a child, display all parent categories":
        "Si une cat\u00e9gorie est enfant, afficher toutes les cat\u00e9gories parentes",
    "Hide the taxonomy name in the breadcrumb trail":
        "Masquer le nom de la taxonomie dans le fil d\u2019Ariane",

    # ── Core ─────────────────────────────────────────────────────────────
    "Plugin files have been modified. PRO features disabled for security.":
        "Les fichiers de l\u2019extension ont \u00e9t\u00e9 modifi\u00e9s. Les fonctionnalit\u00e9s PRO sont d\u00e9sactiv\u00e9es par s\u00e9curit\u00e9.",

    # ── General Settings ─────────────────────────────────────────────────
    "General SEO Settings": "R\u00e9glages SEO g\u00e9n\u00e9raux",
    "Settings": "R\u00e9glages",
    "URL Transliteration": "Translitt\u00e9ration des URL",
    "Enable White Label": "Activer la marque blanche",
    "Plugin Name": "Nom de l\u2019extension",
    "Hide Branding Links": "Masquer les liens de marque",
    "Bulk URL Conversion": "Conversion d\u2019URL en masse",
    "Force HTTPS": "Forcer HTTPS",
    "Fix Mixed Content": "Corriger le contenu mixte",
    "WWW Redirect": "Redirection WWW",
    "Configure the main SEO settings for your site.":
        "Configurez les principaux r\u00e9glages SEO de votre site.",
    "Enable automatic transliteration for non-Latin URLs":
        "Activer la translitt\u00e9ration automatique pour les URL non latines",
    "Automatically converts non-Latin characters to Latin in post and page URLs.":
        "Convertit automatiquement les caract\u00e8res non latins en caract\u00e8res latins dans les URL des articles et pages.",
    "Insufficient permissions.": "Permissions insuffisantes.",
    "Convert existing non-Latin URLs to Latin slugs.":
        "Convertir les URL non latines existantes en slugs latins.",
    "Loading stats...": "Chargement des statistiques...",
    "Posts": "Articles",
    "Pages": "Pages",
    "Refresh Stats": "Actualiser les statistiques",
    "Convert URLs": "Convertir les URL",
    "URL stats:": "Statistiques des URL\u00a0:",
    "Total:": "Total\u00a0:",
    "Non-Latin:": "Non latin\u00a0:",
    "Latin:": "Latin\u00a0:",
    "Are you sure? This will change URLs for all posts with non-Latin slugs.":
        "\u00cates-vous s\u00fbr\u00a0? Cela modifiera les URL de tous les articles avec des slugs non latins.",
    "We recommend backing up the database first.":
        "Nous vous recommandons de sauvegarder la base de donn\u00e9es au pr\u00e9alable.",
    "Converting...": "Conversion en cours...",
    "Conversion completed!": "Conversion termin\u00e9e\u00a0!",
    "Updated:": "Mis \u00e0 jour\u00a0:",
    "Skipped (already Latin):": "Ignor\u00e9 (d\u00e9j\u00e0 en latin)\u00a0:",
    "Total checked:": "Total v\u00e9rifi\u00e9\u00a0:",
    "Error:": "Erreur\u00a0:",
    "Configure HTTPS enforcement, HSTS headers, and WWW redirect.":
        "Configurez l\u2019application de HTTPS, les en-t\u00eates HSTS et la redirection WWW.",
    "Redirect all HTTP requests to HTTPS (301)":
        "Rediriger toutes les requ\u00eates HTTP vers HTTPS (301)",
    "Requires a valid SSL certificate installed on your server.":
        "N\u00e9cessite un certificat SSL valide install\u00e9 sur votre serveur.",
    "Automatically replace HTTP with HTTPS in page output":
        "Remplacer automatiquement HTTP par HTTPS dans le rendu de la page",
    "Fixes mixed content warnings by rewriting internal HTTP URLs to HTTPS on the frontend.":
        "Corrige les avertissements de contenu mixte en r\u00e9\u00e9crivant les URL HTTP internes en HTTPS sur le frontend.",
    "Send Strict-Transport-Security header":
        "Envoyer l\u2019en-t\u00eate Strict-Transport-Security",
    "Max-Age (seconds):": "Dur\u00e9e maximale (secondes)\u00a0:",
    "Default: 31536000 (1 year)": "Par d\u00e9faut\u00a0: 31536000 (1 an)",
    "Tells browsers to always use HTTPS for this domain. Only enable if SSL is fully configured.":
        "Indique aux navigateurs de toujours utiliser HTTPS pour ce domaine. N\u2019activez que si SSL est enti\u00e8rement configur\u00e9.",
    "No redirect": "Aucune redirection",
    "Force www (redirect non-www to www)":
        "Forcer www (rediriger non-www vers www)",
    "Force non-www (redirect www to non-www)":
        "Forcer non-www (rediriger www vers non-www)",
    "Enforce a canonical www or non-www version of your domain (301 redirect).":
        "Imposer une version canonique www ou non-www de votre domaine (redirection 301).",

    # ── White Label ──────────────────────────────────────────────────────
    "White Label is a PRO feature":
        "La marque blanche est une fonctionnalit\u00e9 PRO",
    "Rename the plugin and remove branding. Perfect for agencies and resellers.":
        "Renommez l\u2019extension et supprimez l\u2019image de marque. Id\u00e9al pour les agences et les revendeurs.",
    "Customize the plugin branding for your product.":
        "Personnalisez l\u2019image de marque de l\u2019extension pour votre produit.",
    "Enable white label": "Activer la marque blanche",
    "When enabled, the plugin name changes across the admin UI.":
        "Lorsque cette option est activ\u00e9e, le nom de l\u2019extension change dans toute l\u2019interface d\u2019administration.",
    "New plugin name used across the UI.":
        "Nouveau nom de l\u2019extension utilis\u00e9 dans toute l\u2019interface.",
    "Hide all branding links": "Masquer tous les liens de marque",
    "Removes upgrade links and branding references.":
        "Supprime les liens de mise \u00e0 niveau et les r\u00e9f\u00e9rences de marque.",

    # ── IndexNow Settings ────────────────────────────────────────────────
    "IndexNow Settings": "R\u00e9glages IndexNow",
    "IndexNow API Key": "Cl\u00e9 API IndexNow",
    "Search Engine": "Moteur de recherche",
    "Automatic Submission": "Soumission automatique",
    "Submit on Delete": "Soumettre \u00e0 la suppression",
    "Instant indexing module settings.":
        "R\u00e9glages du module d\u2019indexation instantan\u00e9e.",
    "Generate Key": "G\u00e9n\u00e9rer la cl\u00e9",
    "Verify Key": "V\u00e9rifier la cl\u00e9",
    "API key for IndexNow. It will be saved in the site root.":
        "Cl\u00e9 API pour IndexNow. Elle sera enregistr\u00e9e \u00e0 la racine du site.",
    "IndexNow (all search engines)": "IndexNow (tous les moteurs de recherche)",
    "Bing": "Bing",
    "Yandex": "Yandex",
    "Seznam": "Seznam",
    "Select the search engine to notify.":
        "S\u00e9lectionnez le moteur de recherche \u00e0 notifier.",
    "Automatically submit URLs on publish/update":
        "Soumettre automatiquement les URL lors de la publication/mise \u00e0 jour",
    "Automatically notify on deletion":
        "Notifier automatiquement lors de la suppression",
    "Please provide URLs to submit": "Veuillez fournir des URL \u00e0 soumettre",
    "No valid URLs provided": "Aucune URL valide fournie",
    "Submission completed": "Soumission termin\u00e9e",
    "Failed to create key file. Check permissions.":
        "\u00c9chec de la cr\u00e9ation du fichier cl\u00e9. V\u00e9rifiez les permissions.",
    "API key is not configured": "La cl\u00e9 API n\u2019est pas configur\u00e9e",
    "Key file not found on the server":
        "Fichier cl\u00e9 introuvable sur le serveur",
    "Key file content does not match":
        "Le contenu du fichier cl\u00e9 ne correspond pas",
    "Failed to check file availability: %s":
        "\u00c9chec de la v\u00e9rification de la disponibilit\u00e9 du fichier\u00a0: %s",
    "Key file is not accessible via URL (code: %d)":
        "Le fichier cl\u00e9 n\u2019est pas accessible via l\u2019URL (code\u00a0: %d)",
    "Key file content via URL does not match":
        "Le contenu du fichier cl\u00e9 via l\u2019URL ne correspond pas",
    "Key verified successfully!": "Cl\u00e9 v\u00e9rifi\u00e9e avec succ\u00e8s\u00a0!",
    "Failed to clear history": "\u00c9chec de l\u2019effacement de l\u2019historique",
    "URL sent successfully": "URL envoy\u00e9e avec succ\u00e8s",
    "Error: %d": "Erreur\u00a0: %d",

    # ── License backend ──────────────────────────────────────────────────
    "Invalid license key format": "Format de cl\u00e9 de licence invalide",
    "Error: invalid API response format":
        "Erreur\u00a0: format de r\u00e9ponse API invalide",
    "License activated successfully!": "Licence activ\u00e9e avec succ\u00e8s\u00a0!",
    "License deactivated": "Licence d\u00e9sactiv\u00e9e",
    "Invalid response": "R\u00e9ponse invalide",
    "License key is required": "La cl\u00e9 de licence est requise",
    "Invalid response format": "Format de r\u00e9ponse invalide",
    "License activated": "Licence activ\u00e9e",
    "Activation failed": "\u00c9chec de l\u2019activation",

    # ── Local SEO ────────────────────────────────────────────────────────
    "Enable Local SEO": "Activer le SEO local",
    "Business Type": "Type d\u2019entreprise",
    "Business Name": "Nom de l\u2019entreprise",
    "Phone": "T\u00e9l\u00e9phone",
    "Email": "E-mail",
    "Logo URL": "URL du logo",
    "Image URL": "URL de l\u2019image",
    "Price Range": "Fourchette de prix",
    "Street Address": "Adresse",
    "City": "Ville",
    "Region/State": "R\u00e9gion / \u00c9tat",
    "Postal Code": "Code postal",
    "Country": "Pays",
    "Latitude": "Latitude",
    "Longitude": "Longitude",
    "Opening Hours": "Heures d\u2019ouverture",
    "Configure your local business details for Local SEO schema.":
        "Configurez les d\u00e9tails de votre entreprise locale pour le sch\u00e9ma SEO local.",
    "Output LocalBusiness schema on the frontend":
        "Afficher le sch\u00e9ma LocalBusiness sur le frontend",
    "Example: LocalBusiness, Store, Restaurant, MedicalBusiness":
        "Exemple\u00a0: LocalBusiness, Store, Restaurant, MedicalBusiness",
    'One line per rule, e.g. "Mo-Fr 09:00-18:00"':
        'Une ligne par r\u00e8gle, par ex. \u00ab\u00a0Mo-Fr 09:00-18:00\u00a0\u00bb',

    # ── Meta Titles ──────────────────────────────────────────────────────
    "Robots Meta": "M\u00e9ta Robots",
    "Robots Meta Tags": "Balises m\u00e9ta Robots",
    "Advanced Robots Meta": "M\u00e9ta Robots avanc\u00e9es",
    "Snippet": "Extrait",
    "Video Preview": "Aper\u00e7u vid\u00e9o",
    "Image Preview Size": "Taille de l\u2019aper\u00e7u de l\u2019image",
    "Noindex Empty Archives": "Noindex pour les archives vides",
    "Empty Archives": "Archives vides",
    "Title Settings": "R\u00e9glages des titres",
    "Title Separator": "S\u00e9parateur de titre",
    "Capitalize Titles": "Capitaliser les titres",
    "Twitter Card": "Twitter Card",
    "Content Type Templates": "Mod\u00e8les par type de contenu",
    "Templates": "Mod\u00e8les",
    "Twitter Card Type": "Type de Twitter Card",
    "Default values for the robots meta tag.":
        "Valeurs par d\u00e9faut pour la balise m\u00e9ta robots.",
    "Important:": "Important\u00a0:",
    "Do not enable %1$s and %2$s at the same time. If both are enabled, %2$s takes priority.":
        "N\u2019activez pas %1$s et %2$s en m\u00eame temps. Si les deux sont activ\u00e9s, %2$s est prioritaire.",
    "Index": "Index",
    "Allow search engines to index and show these pages in results":
        "Autoriser les moteurs de recherche \u00e0 indexer et afficher ces pages dans les r\u00e9sultats",
    "NoIndex": "NoIndex",
    "Prevent indexing and showing pages in search results":
        "Emp\u00eacher l\u2019indexation et l\u2019affichage des pages dans les r\u00e9sultats de recherche",
    "NoFollow": "NoFollow",
    "Prevent search engines from following links on the page":
        "Emp\u00eacher les moteurs de recherche de suivre les liens de la page",
    "NoArchive": "NoArchive",
    "Prevent cached links in search results":
        "Emp\u00eacher les liens mis en cache dans les r\u00e9sultats de recherche",
    "NoImageIndex": "NoImageIndex",
    "Prevent indexing page images by search engines":
        "Emp\u00eacher l\u2019indexation des images de la page par les moteurs de recherche",
    "NoSnippet": "NoSnippet",
    "Prevents displaying snippets in search results":
        "Emp\u00eache l\u2019affichage des extraits dans les r\u00e9sultats de recherche",
    "Additional settings to control content appearance in search results.":
        "Param\u00e8tres suppl\u00e9mentaires pour contr\u00f4ler l\u2019apparence du contenu dans les r\u00e9sultats de recherche.",
    "characters": "caract\u00e8res",
    "Set the maximum snippet length in characters.":
        "D\u00e9finissez la longueur maximale de l\u2019extrait en caract\u00e8res.",
    "means unlimited.": "signifie illimit\u00e9.",
    "disables snippets.": "d\u00e9sactive les extraits.",
    "seconds": "secondes",
    "Set the maximum video preview length in seconds.":
        "D\u00e9finissez la dur\u00e9e maximale de l\u2019aper\u00e7u vid\u00e9o en secondes.",
    "disables video previews.": "d\u00e9sactive les aper\u00e7us vid\u00e9o.",
    "None": "Aucun",
    "Standard": "Standard",
    "Large": "Grand",
    "Set the maximum image preview size for images on this page.":
        "D\u00e9finissez la taille maximale de l\u2019aper\u00e7u des images sur cette page.",
    "disables image previews.": "d\u00e9sactive les aper\u00e7us d\u2019images.",
    "are standard limits.": "sont les limites standard.",
    "Adding noindex for empty archives helps avoid indexing empty pages.":
        "Ajouter noindex pour les archives vides aide \u00e0 \u00e9viter l\u2019indexation des pages vides.",
    "Add %s for empty category and tag archives":
        "Ajouter %s pour les archives de cat\u00e9gories et d\u2019\u00e9tiquettes vides",
    "When a post is added, the archive switches back to %s.":
        "Lorsqu\u2019un article est ajout\u00e9, l\u2019archive repasse \u00e0 %s.",
    "Configure how page titles are displayed on your site.":
        "Configurez l\u2019affichage des titres de page sur votre site.",
    "Use the separator in title templates with %1$s or %2$s.":
        "Utilisez le s\u00e9parateur dans les mod\u00e8les de titre avec %1$s ou %2$s.",
    "Preview:": "Aper\u00e7u\u00a0:",
    "Page title": "Titre de la page",
    "Site name": "Nom du site",
    "Automatically capitalize each word in titles":
        "Capitaliser automatiquement chaque mot dans les titres",
    'Example: "%1$s" \u2192 "%2$s"': 'Exemple\u00a0: \u00ab\u00a0%1$s\u00a0\u00bb \u2192 \u00ab\u00a0%2$s\u00a0\u00bb',
    "Configure the Twitter card type for your pages.":
        "Configurez le type de Twitter Card pour vos pages.",
    "Summary with large image": "R\u00e9sum\u00e9 avec grande image",
    "Summary": "R\u00e9sum\u00e9",
    "This card type is used for new posts and for posts without a selected card type.":
        "Ce type de carte est utilis\u00e9 pour les nouveaux articles et les articles sans type de carte s\u00e9lectionn\u00e9.",
    "Set default title and description templates for each content type.":
        "D\u00e9finissez les mod\u00e8les de titre et de description par d\u00e9faut pour chaque type de contenu.",
    "Available variables:": "Variables disponibles\u00a0:",
    "Content Type": "Type de contenu",
    "Title Template": "Mod\u00e8le de titre",
    "Description Template": "Mod\u00e8le de description",
    "General Meta": "M\u00e9ta g\u00e9n\u00e9rales",
    "Authors": "Auteurs",
    "Misc Pages": "Pages diverses",
    "Taxonomies": "Taxonomies",
    "Post Types": "Types d\u2019articles",
    "Homepage Title": "Titre de la page d\u2019accueil",
    "Homepage Description": "Description de la page d\u2019accueil",
    "Author Archive Title": "Titre de l\u2019archive auteur",
    "Author Archive Description": "Description de l\u2019archive auteur",
    "Blog Page Title": "Titre de la page du blog",
    "Blog Page Description": "Description de la page du blog",
    "Search Results Title": "Titre des r\u00e9sultats de recherche",
    "Search Results Description": "Description des r\u00e9sultats de recherche",
    "Date Archive Title": "Titre de l\u2019archive par date",
    "Date Archive Description": "Description de l\u2019archive par date",
    "404 Title": "Titre 404",
    "404 Description": "Description 404",
    "%s Title": "Titre %s",
    "%s Description": "Description %s",
    "Page Not Found": "Page non trouv\u00e9e",

    # ── Post Meta Basic ──────────────────────────────────────────────────
    "Google Preview": "Aper\u00e7u Google",
    "Edit Snippet": "Modifier l\u2019extrait",
    "Focus Keyword": "Mot-cl\u00e9 principal",
    "e.g. Rank Math SEO": "par ex. Rank Math SEO",
    "Basic SEO": "SEO de base",
    "Keyword Density:": "Densit\u00e9 du mot-cl\u00e9\u00a0:",
    "Readability": "Lisibilit\u00e9",
    "Readability:": "Lisibilit\u00e9\u00a0:",
    "Additional SEO": "SEO suppl\u00e9mentaire",
    "Extra on-page checks to improve visibility.":
        "V\u00e9rifications suppl\u00e9mentaires sur la page pour am\u00e9liorer la visibilit\u00e9.",
    "These settings override global robots meta for this page":
        "Ces r\u00e9glages remplacent les m\u00e9ta robots globales pour cette page",
    "Prevent indexing of this page": "Emp\u00eacher l\u2019indexation de cette page",
    "Prevent following links": "Emp\u00eacher le suivi des liens",
    "Prevent cached copy": "Emp\u00eacher la copie en cache",
    "Prevent snippet display": "Emp\u00eacher l\u2019affichage de l\u2019extrait",
    "Prevent image indexing": "Emp\u00eacher l\u2019indexation des images",
    "Max Snippet": "Extrait maximum",
    "Text length (-1 = unlimited)": "Longueur du texte (-1 = illimit\u00e9)",
    "Max Video Preview": "Aper\u00e7u vid\u00e9o maximum",
    "Video length in seconds": "Dur\u00e9e de la vid\u00e9o en secondes",
    "Max Image Preview": "Aper\u00e7u image maximum",
    "Default": "Par d\u00e9faut",
    "Preview size": "Taille de l\u2019aper\u00e7u",
    "Canonical URL": "URL canonique",
    "Defaults to current page URL": "Par d\u00e9faut l\u2019URL de la page actuelle",

    # ── Post Meta Schema ─────────────────────────────────────────────────
    "Article": "Article",
    "Blog Posting": "Article de blog",
    "News Article": "Article d\u2019actualit\u00e9",
    "Product": "Produit",
    "Review": "Avis",
    "Recipe": "Recette",
    "FAQ Page": "Page FAQ",
    "How To": "Comment faire",
    "BreadcrumbList": "BreadcrumbList",
    "Table": "Tableau",
    "Service": "Service",
    "Job Posting": "Offre d\u2019emploi",
    "Course": "Cours",
    "Event": "\u00c9v\u00e9nement",
    "Local Business": "Entreprise locale",
    "Organization": "Organisation",
    "Person": "Personne",
    "Video Object": "Objet vid\u00e9o",
    "Book": "Livre",
    "Software Application": "Application logicielle",
    "Used Schema": "Schema utilis\u00e9",
    "Custom JSON-LD": "JSON-LD personnalis\u00e9",
    "Preview": "Aper\u00e7u",
    "Remove": "Supprimer",
    "No schema selected yet. Use Schema Generator to apply.":
        "Aucun sch\u00e9ma s\u00e9lectionn\u00e9. Utilisez le g\u00e9n\u00e9rateur de sch\u00e9ma pour en appliquer un.",
    "Schema Generator": "G\u00e9n\u00e9rateur de sch\u00e9ma",
    "Schema Templates": "Mod\u00e8les de sch\u00e9ma",
    "Import": "Importer",
    "No schema selected. Choose a template or import JSON-LD.":
        "Aucun sch\u00e9ma s\u00e9lectionn\u00e9. Choisissez un mod\u00e8le ou importez du JSON-LD.",
    "Available Schema Types": "Types de sch\u00e9ma disponibles",
    "Apply": "Appliquer",
    "Schema Settings": "R\u00e9glages du sch\u00e9ma",
    "Schema JSON-LD Preview": "Aper\u00e7u JSON-LD du sch\u00e9ma",
    "Import JSON-LD": "Importer du JSON-LD",
    "Paste JSON-LD": "Coller le JSON-LD",
    "Paste valid JSON-LD without the %s tag":
        "Collez un JSON-LD valide sans la balise %s",
    "Apply JSON-LD": "Appliquer le JSON-LD",
    "Custom JSON-LD Preview": "Aper\u00e7u du JSON-LD personnalis\u00e9",
    "Done": "Termin\u00e9",
    "Schema fields for this type will be available soon. You can manually add schema using the JSON-LD editor above.":
        "Les champs de sch\u00e9ma pour ce type seront bient\u00f4t disponibles. Vous pouvez ajouter manuellement un sch\u00e9ma en utilisant l\u2019\u00e9diteur JSON-LD ci-dessus.",

    # ── Article Schema ───────────────────────────────────────────────────
    "Article Schema Details": "D\u00e9tails du sch\u00e9ma Article",
    "Headline": "Titre",
    "Article headline (defaults to post title)":
        "Titre de l\u2019article (par d\u00e9faut le titre de l\u2019article)",
    "Author Name": "Nom de l\u2019auteur",
    "Author of the article": "Auteur de l\u2019article",
    "Publisher Name": "Nom de l\u2019\u00e9diteur",
    "Publisher organization name": "Nom de l\u2019organisation \u00e9ditrice",
    "Publisher Logo URL": "URL du logo de l\u2019\u00e9diteur",
    "URL of publisher's logo (recommended: 600x60px)":
        "URL du logo de l\u2019\u00e9diteur (recommand\u00e9\u00a0: 600x60px)",
    "Featured Image URL": "URL de l\u2019image mise en avant",
    "Main image for the article": "Image principale de l\u2019article",
    "Date Published": "Date de publication",
    "When was this article published?": "Quand cet article a-t-il \u00e9t\u00e9 publi\u00e9\u00a0?",
    "Date Modified": "Date de modification",
    "Last modification date": "Date de derni\u00e8re modification",

    # ── Product Schema ───────────────────────────────────────────────────
    "Product Schema Details": "D\u00e9tails du sch\u00e9ma Produit",
    "Product Name": "Nom du produit",
    "Price": "Prix",
    "Currency": "Devise",
    "Availability": "Disponibilit\u00e9",
    "In Stock": "En stock",
    "Out of Stock": "Rupture de stock",
    "Pre Order": "Pr\u00e9commande",
    "Brand": "Marque",
    "SKU": "SKU",

    # ── FAQ Schema ───────────────────────────────────────────────────────
    "FAQ Schema Details": "D\u00e9tails du sch\u00e9ma FAQ",
    "Add frequently asked questions and their answers":
        "Ajoutez des questions fr\u00e9quemment pos\u00e9es et leurs r\u00e9ponses",
    "Question %d": "Question %d",
    "What is your question?": "Quelle est votre question\u00a0?",
    "Answer": "R\u00e9ponse",
    "Type the answer here...": "Saisissez la r\u00e9ponse ici...",
    "Add FAQ Item": "Ajouter un \u00e9l\u00e9ment FAQ",

    # ── How-To Schema ────────────────────────────────────────────────────
    "How-To Schema Details": "D\u00e9tails du sch\u00e9ma Comment faire",
    "Guide Name": "Nom du guide",
    "Description": "Description",
    "Steps": "\u00c9tapes",
    "Step %d Name": "Nom de l\u2019\u00e9tape %d",
    "Step Description": "Description de l\u2019\u00e9tape",
    "Remove Step": "Supprimer l\u2019\u00e9tape",
    "Add Step": "Ajouter une \u00e9tape",

    # ── Review Schema ────────────────────────────────────────────────────
    "Review Schema Details": "D\u00e9tails du sch\u00e9ma Avis",
    "Item Reviewed": "\u00c9l\u00e9ment \u00e9valu\u00e9",
    "Rating (1-5)": "Note (1-5)",
    "Reviewer Name": "Nom de l\u2019\u00e9valuateur",
    "Review Date": "Date de l\u2019avis",

    # ── Recipe Schema ────────────────────────────────────────────────────
    "Recipe Schema Details": "D\u00e9tails du sch\u00e9ma Recette",
    "Recipe Name": "Nom de la recette",
    "Prep Time (minutes)": "Temps de pr\u00e9paration (minutes)",
    "Cook Time (minutes)": "Temps de cuisson (minutes)",
    "Servings": "Portions",
    "4 servings": "4 portions",
    "Calories": "Calories",
    "Ingredients (one per line)": "Ingr\u00e9dients (un par ligne)",
    "Instructions": "Instructions",

    # ── Event Schema ─────────────────────────────────────────────────────
    "Event Schema Details": "D\u00e9tails du sch\u00e9ma \u00c9v\u00e9nement",
    "Event Name": "Nom de l\u2019\u00e9v\u00e9nement",
    "Start Date & Time": "Date et heure de d\u00e9but",
    "End Date & Time": "Date et heure de fin",
    "Location Name": "Nom du lieu",
    "Address": "Adresse",

    # ── Video Schema ─────────────────────────────────────────────────────
    "Video Schema Details": "D\u00e9tails du sch\u00e9ma Vid\u00e9o",
    "Video Title": "Titre de la vid\u00e9o",
    "Video URL": "URL de la vid\u00e9o",
    "Thumbnail URL": "URL de la miniature",
    "Upload Date": "Date de mise en ligne",
    "Duration (ISO 8601)": "Dur\u00e9e (ISO 8601)",
    "Format: PT1H30M (1 hour 30 minutes)": "Format\u00a0: PT1H30M (1 heure 30 minutes)",

    # ── BreadcrumbList Schema ────────────────────────────────────────────
    "BreadcrumbList Details": "D\u00e9tails de BreadcrumbList",
    "Enter one breadcrumb per line: Label | URL":
        "Saisissez un \u00e9l\u00e9ment par ligne\u00a0: Libell\u00e9 | URL",

    # ── Table Schema ─────────────────────────────────────────────────────
    "Table Schema Details": "D\u00e9tails du sch\u00e9ma Tableau",
    "Table Name": "Nom du tableau",
    "Rows": "Lignes",
    "Use one row per line, columns separated by |":
        "Utilisez une ligne par rang\u00e9e, colonnes s\u00e9par\u00e9es par |",

    # ── Service Schema ───────────────────────────────────────────────────
    "Service Schema Details": "D\u00e9tails du sch\u00e9ma Service",
    "Service Name": "Nom du service",
    "Provider Name": "Nom du prestataire",
    "Area Served": "Zone desservie",
    "Service Type": "Type de service",

    # ── Job Posting Schema ───────────────────────────────────────────────
    "Job Posting Details": "D\u00e9tails de l\u2019offre d\u2019emploi",
    "Job Title": "Titre du poste",
    "Date Posted": "Date de publication",
    "Valid Through": "Valide jusqu\u2019au",
    "Employment Type": "Type de contrat",
    "Full-time": "Temps plein",
    "Hiring Organization": "Organisme recruteur",
    "Job Location": "Lieu de travail",
    "City, Country": "Ville, Pays",

    # ── Social Preview / Post Meta Social ────────────────────────────────
    "Social Preview": "Aper\u00e7u social",
    "Facebook": "Facebook",
    "Twitter": "Twitter",
    "Facebook user": "Utilisateur Facebook",
    "2 hours ago": "Il y a 2 heures",
    "FB Preview": "Aper\u00e7u FB",
    "Twitter user": "Utilisateur Twitter",
    "2 hours": "2 heures",
    "Post with a link!": "Article avec un lien\u00a0!",
    "Twitter Preview": "Aper\u00e7u Twitter",
    "Social Settings": "R\u00e9glages sociaux",
    "All Networks": "Tous les r\u00e9seaux",
    "Title": "Titre",
    "Title for all networks": "Titre pour tous les r\u00e9seaux",
    "Description for all networks": "Description pour tous les r\u00e9seaux",
    "Image": "Image",
    "Choose Image": "Choisir une image",
    "Values apply to Facebook and Twitter":
        "Les valeurs s\u2019appliquent \u00e0 Facebook et Twitter",
    "Facebook Title": "Titre Facebook",
    "Post title": "Titre de l\u2019article",
    "SEO title": "Titre SEO",
    "Separator \u2014": "S\u00e9parateur \u2014",
    "Category": "Cat\u00e9gorie",
    "Publish date": "Date de publication",
    "Facebook Image": "Image Facebook",
    "Facebook Description": "Description Facebook",
    "Post excerpt": "Extrait de l\u2019article",
    "SEO description": "Description SEO",
    "Site description": "Description du site",
    "Twitter Title": "Titre Twitter",
    "Summary Large Image": "R\u00e9sum\u00e9 avec grande image",
    "Twitter Description": "Description Twitter",
    "Twitter Image": "Image Twitter",
    "OG Title": "Titre OG",
    "OG Type": "Type OG",
    "Website": "Site web",
    "Video": "Vid\u00e9o",
    "OG Description": "Description OG",
    "Product short description": "Description courte du produit",
    "OG Image": "Image OG",
    "Select image": "S\u00e9lectionner une image",
    "Facebook Preview": "Aper\u00e7u Facebook",
    "2h": "2h",
    "Facebook Settings": "R\u00e9glages Facebook",
    "Twitter (X) Settings": "R\u00e9glages Twitter (X)",

    # ── Post Meta analysis strings ───────────────────────────────────────
    "Focus keyword is set": "Le mot-cl\u00e9 principal est d\u00e9fini",
    "Add a focus keyword": "Ajoutez un mot-cl\u00e9 principal",
    "Focus keyword in SEO title": "Mot-cl\u00e9 principal dans le titre SEO",
    "Add focus keyword to SEO title": "Ajoutez le mot-cl\u00e9 principal au titre SEO",
    "Focus keyword in meta description":
        "Mot-cl\u00e9 principal dans la m\u00e9ta description",
    "Add focus keyword to meta description":
        "Ajoutez le mot-cl\u00e9 principal \u00e0 la m\u00e9ta description",
    "Focus keyword in content": "Mot-cl\u00e9 principal dans le contenu",
    "Add focus keyword to content": "Ajoutez le mot-cl\u00e9 principal au contenu",
    "Focus keyword in URL": "Mot-cl\u00e9 principal dans l\u2019URL",
    "Add focus keyword to URL": "Ajoutez le mot-cl\u00e9 principal \u00e0 l\u2019URL",
    "Keyword density is OK (0.5\u20132.5%)":
        "La densit\u00e9 du mot-cl\u00e9 est correcte (0,5\u20132,5\u00a0%)",
    "Keyword density out of range (0.5\u20132.5%)":
        "La densit\u00e9 du mot-cl\u00e9 est hors limites (0,5\u20132,5\u00a0%)",
    "SEO title length is OK (50\u201360)":
        "La longueur du titre SEO est correcte (50\u201360)",
    "Optimize SEO title length (50\u201360)":
        "Optimisez la longueur du titre SEO (50\u201360)",
    "Meta description length is OK (120\u2013160)":
        "La longueur de la m\u00e9ta description est correcte (120\u2013160)",
    "Optimize meta description length (120\u2013160)":
        "Optimisez la longueur de la m\u00e9ta description (120\u2013160)",
    "Content length is sufficient (300+ words)":
        "La longueur du contenu est suffisante (300+ mots)",
    "Add more content (minimum 300 words)":
        "Ajoutez plus de contenu (minimum 300 mots)",
    "H1 heading is present": "Le titre H1 est pr\u00e9sent",
    "Add an H1 heading": "Ajoutez un titre H1",
    "H2 subheadings are present": "Les sous-titres H2 sont pr\u00e9sents",
    "Add H2 subheadings": "Ajoutez des sous-titres H2",
    "Images have alt attributes": "Les images ont des attributs alt",
    "Add alt attributes to images": "Ajoutez des attributs alt aux images",
    "Internal link is present": "Un lien interne est pr\u00e9sent",
    "Add an internal link": "Ajoutez un lien interne",
    "Enough sentences for readability":
        "Assez de phrases pour la lisibilit\u00e9",
    "Add more sentences": "Ajoutez plus de phrases",
    "Average sentence length is OK":
        "La longueur moyenne des phrases est correcte",
    "Make sentences shorter": "Raccourcissez les phrases",
    "No overly long sentences": "Pas de phrases trop longues",
    "There are overly long sentences": "Il y a des phrases trop longues",
    "Multiple paragraphs detected": "Plusieurs paragraphes d\u00e9tect\u00e9s",
    "Split text into paragraphs": "D\u00e9coupez le texte en paragraphes",
    "Paragraph length is OK": "La longueur des paragraphes est correcte",
    "Make paragraphs shorter": "Raccourcissez les paragraphes",
    "Lists are present": "Des listes sont pr\u00e9sentes",
    "Add lists (ul/ol)": "Ajoutez des listes (ul/ol)",
    "Excellent": "Excellent",
    "Okay": "Correct",
    "Needs work": "\u00c0 am\u00e9liorer",
    "Select an image": "S\u00e9lectionner une image",
    "Use this image": "Utiliser cette image",
    "Keyword in first paragraph": "Mot-cl\u00e9 dans le premier paragraphe",
    "Add keyword to first paragraph":
        "Ajoutez le mot-cl\u00e9 au premier paragraphe",
    "URL length is OK": "La longueur de l\u2019URL est correcte",
    "Shorten URL (up to 75 chars)": "Raccourcissez l\u2019URL (75 caract\u00e8res max.)",
    "External link is present": "Un lien externe est pr\u00e9sent",
    "Add an external link": "Ajoutez un lien externe",
    "Images are present in content": "Des images sont pr\u00e9sentes dans le contenu",
    "Add an image": "Ajoutez une image",
    "Scan Content": "Analyser le contenu",
    "Scanning...": "Analyse en cours...",
    "Linked!": "Li\u00e9\u00a0!",
    "Not found": "Non trouv\u00e9",
    "Untitled": "Sans titre",
    "No description available": "Aucune description disponible",

    # ── Post Meta tabs ───────────────────────────────────────────────────
    "SEO Basics": "Bases du SEO",
    "Advanced": "Avanc\u00e9",
    "Schema": "Schema",
    "Edit SEO Snippet": "Modifier l\u2019extrait SEO",
    "General": "G\u00e9n\u00e9ral",
    "Social": "Social",
    "SEO Title": "Titre SEO",
    "Separator -, \u2014": "S\u00e9parateur -, \u2014",
    "Parent page": "Page parente",
    "Tag": "\u00c9tiquette",
    "Taxonomy term": "Terme de taxonomie",
    "Current date": "Date actuelle",
    "Current year": "Ann\u00e9e actuelle",
    "Author name": "Nom de l\u2019auteur",
    "Page number (2 of 4)": "Num\u00e9ro de page (2 sur 4)",
    "Post type (singular)": "Type d\u2019article (singulier)",
    "Search query": "Requ\u00eate de recherche",
    "Meta Description": "M\u00e9ta description",
    "Excerpt field only": "Champ extrait uniquement",
    "Term description": "Description du terme",
    "Author bio": "Biographie de l\u2019auteur",
    "Meta Keywords": "M\u00e9ta mots-cl\u00e9s",
    "Focus keyword": "Mot-cl\u00e9 principal",
    "Keywords": "Mots-cl\u00e9s",
    "Tags": "\u00c9tiquettes",
    "All categories": "Toutes les cat\u00e9gories",
    "Separate keywords with commas": "S\u00e9parez les mots-cl\u00e9s par des virgules",
    "Cancel": "Annuler",

    # ── PRO Features ─────────────────────────────────────────────────────
    "PRO": "PRO",
    "Unlimited Redirects": "Redirections illimit\u00e9es",
    "Unlimited 404 Monitoring": "Surveillance 404 illimit\u00e9e",
    "AI Bot Blocking": "Blocage des robots IA",
    "Schema Markup": "Balisage Schema",
    "Social Cards": "Cartes sociales",
    "FREE": "GRATUIT",
    "50 Redirects": "50 redirections",
    "100 404 Logs": "100 journaux 404",
    "Meta Tags": "Balises m\u00e9ta",
    "Upgrade to PRO to unlock %s":
        "Passez au PRO pour d\u00e9bloquer %s",
    "This feature requires a PRO license.":
        "Cette fonctionnalit\u00e9 n\u00e9cessite une licence PRO.",
    "This feature requires %1$sPRO license%2$s.":
        "Cette fonctionnalit\u00e9 n\u00e9cessite une %1$slicence PRO%2$s.",
    "FREE plan limited to %d items. Upgrade to PRO for unlimited.":
        "Le forfait GRATUIT est limit\u00e9 \u00e0 %d \u00e9l\u00e9ments. Passez au PRO pour un acc\u00e8s illimit\u00e9.",
    "FREE plan limited to %1$d items. %2$sUpgrade to PRO%3$s for unlimited.":
        "Le forfait GRATUIT est limit\u00e9 \u00e0 %1$d \u00e9l\u00e9ments. %2$sPassez au PRO%3$s pour un acc\u00e8s illimit\u00e9.",

    # ── Redirects backend ────────────────────────────────────────────────
    "FREE plan limit reached (%d redirects). Upgrade to PRO for unlimited redirects.":
        "Limite du forfait GRATUIT atteinte (%d redirections). Passez au PRO pour des redirections illimit\u00e9es.",
    "FREE plan limit reached (%1$d redirects). %2$sUpgrade to PRO%3$s for unlimited redirects.":
        "Limite du forfait GRATUIT atteinte (%1$d redirections). %2$sPassez au PRO%3$s pour des redirections illimit\u00e9es.",
    "Please fill in all fields.": "Veuillez remplir tous les champs.",
    "A redirect with this source already exists.":
        "Une redirection avec cette source existe d\u00e9j\u00e0.",
    "Redirect added successfully.": "Redirection ajout\u00e9e avec succ\u00e8s.",
    "Failed to add redirect.": "\u00c9chec de l\u2019ajout de la redirection.",
    "Redirect deleted.": "Redirection supprim\u00e9e.",
    "Failed to delete redirect.": "\u00c9chec de la suppression de la redirection.",
    "Status updated.": "Statut mis \u00e0 jour.",
    "Failed to update status.": "\u00c9chec de la mise \u00e0 jour du statut.",
    "Redirects table is not created.":
        "La table des redirections n\u2019est pas cr\u00e9\u00e9e.",
    "Redirect updated.": "Redirection mise \u00e0 jour.",
    "Failed to update redirect.": "\u00c9chec de la mise \u00e0 jour de la redirection.",
    "Table created.": "Table cr\u00e9\u00e9e.",
    "CSV file is required.": "Un fichier CSV est requis.",
    "Failed to read CSV file.": "\u00c9chec de la lecture du fichier CSV.",
    "Invalid CSV header.": "En-t\u00eate CSV invalide.",

    # ── Robots.txt Settings ──────────────────────────────────────────────
    "Robots.txt Settings": "R\u00e9glages Robots.txt",
    "Enable virtual robots.txt": "Activer le robots.txt virtuel",
    "robots.txt Content": "Contenu du robots.txt",
    "Additional User-agent Blocks": "Blocs User-agent suppl\u00e9mentaires",
    "Crawl-delay for bots": "Crawl-delay pour les robots",
    "Use dynamic variables": "Utiliser des variables dynamiques",
    "Block AI bots": "Bloquer les robots IA",
    "Block web archive bots": "Bloquer les robots d\u2019archivage web",
    "Reset settings": "R\u00e9initialiser les r\u00e9glages",
    "Current robots.txt": "Robots.txt actuel",
    "Warning!": "Attention\u00a0!",
    "A physical robots.txt file was found in the site root.":
        "Un fichier robots.txt physique a \u00e9t\u00e9 trouv\u00e9 \u00e0 la racine du site.",
    "It takes precedence over the virtual WordPress robots.txt.":
        "Il a la priorit\u00e9 sur le robots.txt virtuel de WordPress.",
    "Show physical file contents": "Afficher le contenu du fichier physique",
    "No physical robots.txt file found in the site root.":
        "Aucun fichier robots.txt physique trouv\u00e9 \u00e0 la racine du site.",
    "The virtual WordPress robots.txt is used.":
        "Le robots.txt virtuel de WordPress est utilis\u00e9.",
    "robots.txt editor. Available variables:":
        "\u00c9diteur robots.txt. Variables disponibles\u00a0:",
    "Additional rule blocks for specific user agents. Example:":
        "Blocs de r\u00e8gles suppl\u00e9mentaires pour des agents utilisateurs sp\u00e9cifiques. Exemple\u00a0:",
    "Format: one line = %s, for example:":
        "Format\u00a0: une ligne = %s, par exemple\u00a0:",
    "Converted to %s directives for the listed bots.":
        "Converti en directives %s pour les robots list\u00e9s.",
    "Automatically replace": "Remplacer automatiquement",
    "Block AI crawlers (GPTBot, ChatGPT-User, Google-Extended, Omgilibot, ClaudeBot, Claude-Web)":
        "Bloquer les robots IA (GPTBot, ChatGPT-User, Google-Extended, Omgilibot, ClaudeBot, Claude-Web)",
    "When enabled, robots.txt will include Disallow rules for popular AI crawlers.":
        "Lorsque cette option est activ\u00e9e, le robots.txt inclura des r\u00e8gles Disallow pour les robots IA populaires.",
    "to unlock": "pour d\u00e9bloquer",
    "Block web archive bots (Wayback Machine, Archive.org, archive.is, and others)":
        "Bloquer les robots d\u2019archivage web (Wayback Machine, Archive.org, archive.is et autres)",
    "When enabled, web archive services cannot store copies of your site.":
        "Lorsque cette option est activ\u00e9e, les services d\u2019archivage web ne peuvent pas stocker de copies de votre site.",
    "This helps protect unique content and prevents unauthorized archiving.":
        "Cela aide \u00e0 prot\u00e9ger le contenu unique et emp\u00eache l\u2019archivage non autoris\u00e9.",
    "Reset to defaults": "R\u00e9initialiser par d\u00e9faut",
    "Restores robots.txt to default values.":
        "Restaure le robots.txt aux valeurs par d\u00e9faut.",
    "All custom changes will be lost.":
        "Toutes les modifications personnalis\u00e9es seront perdues.",
    "Are you sure? All robots.txt settings will be reset.":
        "\u00cates-vous s\u00fbr\u00a0? Tous les r\u00e9glages du robots.txt seront r\u00e9initialis\u00e9s.",
    "Resetting...": "R\u00e9initialisation en cours...",
    "Reset complete!": "R\u00e9initialisation termin\u00e9e\u00a0!",
    "unknown": "inconnu",
    "AJAX error": "Erreur AJAX",
    "Settings reset.": "R\u00e9glages r\u00e9initialis\u00e9s.",

    # ── XML Sitemap Settings ─────────────────────────────────────────────
    "XML Sitemap Settings": "R\u00e9glages du plan du site XML",
    "Enable XML Sitemap": "Activer le plan du site XML",
    "Post Types for XML Sitemap": "Types d\u2019articles pour le plan du site XML",
    "Include Images": "Inclure les images",
    "Exclude URLs": "Exclure des URL",
    "Additional URLs": "URL suppl\u00e9mentaires",
    "HTML Sitemap Settings": "R\u00e9glages du plan du site HTML",
    "HTML Sitemap Slug": "Slug du plan du site HTML",
    "Post Types for HTML Sitemap": "Types d\u2019articles pour le plan du site HTML",
    "XML sitemap generation settings for search engines.":
        "R\u00e9glages de g\u00e9n\u00e9ration du plan du site XML pour les moteurs de recherche.",
    "HTML sitemap settings for site visitors.":
        "R\u00e9glages du plan du site HTML pour les visiteurs du site.",
    "Enable XML sitemap generation": "Activer la g\u00e9n\u00e9ration du plan du site XML",
    "Generates dynamic XML sitemap files for search engines.":
        "G\u00e9n\u00e8re des fichiers plan du site XML dynamiques pour les moteurs de recherche.",
    "Select post types to include in the XML sitemap and configure parameters for each type.":
        "S\u00e9lectionnez les types d\u2019articles \u00e0 inclure dans le plan du site XML et configurez les param\u00e8tres pour chaque type.",
    "Priority:": "Priorit\u00e9\u00a0:",
    "Changefreq:": "Fr\u00e9quence de modification\u00a0:",
    "Always": "Toujours",
    "Hourly": "Toutes les heures",
    "Daily": "Quotidien",
    "Weekly": "Hebdomadaire",
    "Monthly": "Mensuel",
    "Yearly": "Annuel",
    "Never": "Jamais",
    "Include images in sitemap": "Inclure les images dans le plan du site",
    "Full or relative URLs to exclude from the XML sitemap (one per line).":
        "URL compl\u00e8tes ou relatives \u00e0 exclure du plan du site XML (une par ligne).",
    "Default priority and change frequency for all additional URLs (unless overridden individually below).":
        "Priorit\u00e9 et fr\u00e9quence de modification par d\u00e9faut pour toutes les URL suppl\u00e9mentaires (sauf remplacement individuel ci-dessous).",
    "Default Priority:": "Priorit\u00e9 par d\u00e9faut\u00a0:",
    "Default Changefreq:": "Fr\u00e9quence de modification par d\u00e9faut\u00a0:",
    "Additional URLs to add to the XML sitemap (one per line). These will use the default priority and changefreq above.":
        "URL suppl\u00e9mentaires \u00e0 ajouter au plan du site XML (une par ligne). Elles utiliseront la priorit\u00e9 et la fr\u00e9quence de modification par d\u00e9faut ci-dessus.",
    "Per-URL Priority & Changefreq":
        "Priorit\u00e9 et fr\u00e9quence par URL",
    "+ Add URL": "+ Ajouter une URL",
    "Override priority & changefreq per URL":
        "Remplacer la priorit\u00e9 et la fr\u00e9quence par URL",
    "Upgrade to PRO to set individual priority and change frequency for each additional URL in your sitemap.":
        "Passez au PRO pour d\u00e9finir la priorit\u00e9 et la fr\u00e9quence de modification individuelles pour chaque URL suppl\u00e9mentaire de votre plan du site.",
    "Priority": "Priorit\u00e9",
    "Changefreq": "Fr\u00e9quence",
    'No per-URL overrides yet. Click "+ Add URL" to add one.':
        'Aucun remplacement par URL pour le moment. Cliquez sur \u00ab\u00a0+ Ajouter une URL\u00a0\u00bb pour en ajouter un.',
    "HTML sitemap slug (e.g., html-sitemap)":
        "Slug du plan du site HTML (par ex., html-sitemap)",
    "Select which post types to show in the HTML sitemap.":
        "S\u00e9lectionnez les types d\u2019articles \u00e0 afficher dans le plan du site HTML.",
    "XML Sitemap": "Plan du site XML",
    "XML Sitemap Index": "Index du plan du site XML",
    "This is the XML sitemap index. Each link below points to a sitemap for a specific content type.":
        "Ceci est l\u2019index du plan du site XML. Chaque lien ci-dessous pointe vers un plan du site pour un type de contenu sp\u00e9cifique.",
    "Total sitemap files:": "Total des fichiers de plan du site\u00a0:",
    "Last Modified": "Derni\u00e8re modification",
    "Back to sitemap index": "Retour \u00e0 l\u2019index du plan du site",
    "This XML sitemap is intended for search engines such as Google, Bing, and Yandex.":
        "Ce plan du site XML est destin\u00e9 aux moteurs de recherche tels que Google, Bing et Yandex.",
    "URLs": "URL",
    "Images": "Images",
    "Page": "Page",
    "No entries available to display in the sitemap.":
        "Aucune entr\u00e9e disponible \u00e0 afficher dans le plan du site.",

    # ── WooCommerce ──────────────────────────────────────────────────────
    "SEO": "SEO",
    "Custom SEO title for this taxonomy. Variables: %term_title%, %sitename%, %sep%":
        "Titre SEO personnalis\u00e9 pour cette taxonomie. Variables\u00a0: %term_title%, %sitename%, %sep%",
    "Custom meta description for this taxonomy page.":
        "M\u00e9ta description personnalis\u00e9e pour cette page de taxonomie.",
    "Open Graph Image": "Image Open Graph",
    "Custom social sharing image for this taxonomy page.":
        "Image de partage social personnalis\u00e9e pour cette page de taxonomie.",
    "Custom SEO title. Variables: %term_title%, %sitename%, %sep%":
        "Titre SEO personnalis\u00e9. Variables\u00a0: %term_title%, %sitename%, %sep%",
    "WooCommerce is not installed or activated. This module requires WooCommerce to function.":
        "WooCommerce n\u2019est pas install\u00e9 ou activ\u00e9. Ce module n\u00e9cessite WooCommerce pour fonctionner.",
    "WooCommerce SEO settings saved.":
        "R\u00e9glages SEO WooCommerce enregistr\u00e9s.",
    "WooCommerce Overview": "Aper\u00e7u WooCommerce",
    "Products": "Produits",
    "Categories": "Cat\u00e9gories",
    "ON": "ACTIV\u00c9",
    "OFF": "D\u00c9SACTIV\u00c9",
    "Auto Schema": "Sch\u00e9ma automatique",
    "Product Schema (Structured Data)":
        "Sch\u00e9ma Produit (donn\u00e9es structur\u00e9es)",
    "Automatically generate Product schema markup from WooCommerce product data.":
        "G\u00e9n\u00e9rer automatiquement le balisage Schema Produit \u00e0 partir des donn\u00e9es produit WooCommerce.",
    "Auto-generate Product Schema":
        "G\u00e9n\u00e9ration automatique du sch\u00e9ma Produit",
    "Automatically create Product schema from WooCommerce data when saving a product":
        "Cr\u00e9er automatiquement le sch\u00e9ma Produit \u00e0 partir des donn\u00e9es WooCommerce lors de l\u2019enregistrement d\u2019un produit",
    "Include Price": "Inclure le prix",
    "Include product price and currency in schema":
        "Inclure le prix et la devise du produit dans le sch\u00e9ma",
    "Include Reviews": "Inclure les avis",
    "Include average rating and review count in schema":
        "Inclure la note moyenne et le nombre d\u2019avis dans le sch\u00e9ma",
    "Include Brand": "Inclure la marque",
    "Include brand from product attribute":
        "Inclure la marque \u00e0 partir de l\u2019attribut du produit",
    "Brand Attribute": "Attribut de marque",
    "Product attribute slug for brand (e.g., %1$s or %2$s)":
        "Slug de l\u2019attribut produit pour la marque (par ex., %1$s ou %2$s)",
    "Remove WC Default Schema": "Supprimer le sch\u00e9ma WooCommerce par d\u00e9faut",
    "Remove WooCommerce's built-in structured data to prevent conflicts":
        "Supprimer les donn\u00e9es structur\u00e9es int\u00e9gr\u00e9es de WooCommerce pour \u00e9viter les conflits",
    "Warning: Only enable this if you are using SEO Fury to generate all product schema.":
        "Attention\u00a0: N\u2019activez cette option que si vous utilisez SEO Fury pour g\u00e9n\u00e9rer tout le sch\u00e9ma produit.",
    "SEO Title Templates": "Mod\u00e8les de titre SEO",
    "Default SEO title/description templates for products and taxonomies. These are used when individual products don't have custom SEO titles set.":
        "Mod\u00e8les de titre/description SEO par d\u00e9faut pour les produits et les taxonomies. Utilis\u00e9s lorsque les produits individuels n\u2019ont pas de titres SEO personnalis\u00e9s.",
    "Product Title Template": "Mod\u00e8le de titre produit",
    "Variables: %1$s, %2$s, %3$s, %4$s": "Variables\u00a0: %1$s, %2$s, %3$s, %4$s",
    "Product Description Template": "Mod\u00e8le de description produit",
    "Variables: %1$s, %2$s, %3$s": "Variables\u00a0: %1$s, %2$s, %3$s",
    "Product Category Title": "Titre de cat\u00e9gorie produit",
    "Product Tag Title": "Titre d\u2019\u00e9tiquette produit",
    "Save WooCommerce Settings": "Enregistrer les r\u00e9glages WooCommerce",

    # ── seo-fury.php ─────────────────────────────────────────────────────
    "Manifest updated!": "Manifeste mis \u00e0 jour\u00a0!",

    # ── Missed / additional strings ──────────────────────────────────────
    "AUTO": "AUTO",
    "MANUAL": "MANUEL",
    "N/A": "N/A",
    "// Paste your JSON-LD here": "// Collez votre JSON-LD ici",
    "JSON-LD is empty.": "Le JSON-LD est vide.",
    "+ Link": "+ Lien",
}


# ─── .pot File Parser ────────────────────────────────────────────────────────

def parse_pot(path):
    """Parse a .pot file and return a list of (comments, msgid, is_plural) entries.
    Each entry is a dict with keys: comments (list of str), msgid (str), msgid_plural (str or None).
    Multi-line msgid strings are concatenated.
    """
    entries = []
    current_comments = []
    current_key = None   # 'msgid' or 'msgstr' or 'msgid_plural'
    current_msgid = ""
    current_msgid_plural = None
    in_header = True
    flags = []

    with open(path, "r", encoding="utf-8") as f:
        lines = f.readlines()

    def flush():
        nonlocal current_msgid, current_msgid_plural, current_comments, flags
        if current_msgid:  # skip empty header msgid
            entries.append({
                "comments": current_comments,
                "msgid": current_msgid,
                "msgid_plural": current_msgid_plural,
                "flags": flags,
            })
        current_comments = []
        current_msgid = ""
        current_msgid_plural = None
        flags = []

    for line in lines:
        line = line.rstrip("\n")

        # Comment lines
        if line.startswith("#"):
            if current_key == "msgstr" or (current_key is None and current_msgid):
                flush()
            if line.startswith("#,"):
                flags.append(line)
            current_comments.append(line)
            current_key = None
            continue

        # Empty line = end of entry
        if line.strip() == "":
            if current_msgid or current_key:
                flush()
                current_key = None
                in_header = False
            continue

        # msgid line
        m = re.match(r'^msgid\s+"(.*)"$', line)
        if m:
            if current_key == "msgstr":
                flush()
            if in_header and m.group(1) == "":
                current_key = "msgid"
                current_msgid = ""
                continue
            current_key = "msgid"
            current_msgid = unescape(m.group(1))
            in_header = False
            continue

        # msgid_plural line
        m = re.match(r'^msgid_plural\s+"(.*)"$', line)
        if m:
            current_key = "msgid_plural"
            current_msgid_plural = unescape(m.group(1))
            continue

        # msgstr line (we skip these for template parsing)
        m = re.match(r'^msgstr(\[\d+\])?\s+"(.*)"$', line)
        if m:
            current_key = "msgstr"
            continue

        # Continuation string line
        m = re.match(r'^"(.*)"$', line)
        if m:
            if current_key == "msgid":
                current_msgid += unescape(m.group(1))
            elif current_key == "msgid_plural":
                current_msgid_plural = (current_msgid_plural or "") + unescape(m.group(1))
            # For msgstr / header, we just skip
            continue

    # Flush last entry
    if current_msgid:
        flush()

    return entries


def unescape(s):
    """Unescape .po file escape sequences."""
    s = s.replace("\\n", "\n")
    s = s.replace("\\t", "\t")
    s = s.replace('\\"', '"')
    s = s.replace("\\\\", "\\")
    return s


def escape(s):
    """Escape a string for .po file format."""
    s = s.replace("\\", "\\\\")
    s = s.replace('"', '\\"')
    s = s.replace("\t", "\\t")
    # handle newlines: split into multi-line format
    return s


def format_po_string(key, value):
    """Format a msgid or msgstr line, handling multi-line strings."""
    if "\n" in value:
        parts = value.split("\n")
        lines = [f'{key} ""']
        for i, part in enumerate(parts):
            escaped = escape(part)
            if i < len(parts) - 1:
                lines.append(f'"{escaped}\\n"')
            else:
                if escaped:  # Don't add empty trailing line
                    lines.append(f'"{escaped}"')
        return "\n".join(lines)
    else:
        return f'{key} "{escape(value)}"'


# ─── Main Generation ────────────────────────────────────────────────────────

def main():
    print(f"Reading .pot file: {POT_FILE}")
    entries = parse_pot(POT_FILE)
    print(f"Found {len(entries)} translatable entries")

    # Build output
    now = datetime.utcnow().strftime("%Y-%m-%d %H:%M+0000")

    header = f'''# French (France) translation for SEO Fury
# Copyright (C) 2026 SEO Fury Team
# This file is distributed under the GPL v2 or later.
msgid ""
msgstr ""
"Project-Id-Version: SEO Fury 0.1.5\\n"
"Report-Msgid-Bugs-To: https://wordpress.org/support/plugin/seo-fury\\n"
"Last-Translator: SEO Fury Team <support@seo-fury.com>\\n"
"Language-Team: French <fr@li.org>\\n"
"Language: fr_FR\\n"
"Plural-Forms: nplurals=2; plural=(n > 1);\\n"
"MIME-Version: 1.0\\n"
"Content-Type: text/plain; charset=UTF-8\\n"
"Content-Transfer-Encoding: 8bit\\n"
"POT-Creation-Date: 2026-02-08T09:27:12+00:00\\n"
"PO-Revision-Date: {now}\\n"
"X-Generator: generate_fr.py\\n"
"X-Domain: seo-fury\\n"
'''

    output_lines = [header]
    translated_count = 0
    untranslated = []

    for entry in entries:
        msgid = entry["msgid"]
        comments = entry["comments"]
        flags = entry["flags"]

        # Write comments
        for c in comments:
            # flags are already in comments
            output_lines.append(c)

        # Look up translation
        translation = TRANSLATIONS.get(msgid, "")

        if translation:
            translated_count += 1
        else:
            untranslated.append(msgid)

        # Write msgid
        output_lines.append(format_po_string("msgid", msgid))

        # Write msgstr
        output_lines.append(format_po_string("msgstr", translation))

        # Blank line between entries
        output_lines.append("")

    # Write the file
    content = "\n".join(output_lines)
    with open(PO_FILE, "w", encoding="utf-8") as f:
        f.write(content)

    print(f"\nWrote: {PO_FILE}")
    print(f"Total entries: {len(entries)}")
    print(f"Translated:    {translated_count}")
    print(f"Untranslated:  {len(untranslated)}")

    if untranslated:
        print("\n--- Untranslated strings ---")
        for s in untranslated:
            preview = s[:80].replace("\n", "\\n")
            print(f"  - {preview}")

    return len(untranslated)


if __name__ == "__main__":
    remaining = main()
    # Exit with code 0 if all translated, 1 otherwise
    # (informational only, don't fail)
    sys.exit(0)
