#!/usr/bin/env python3
"""
Generate complete Russian translation .po file for SEO Fury WordPress plugin.
Reads the .pot file, applies translations, and writes seo-fury-ru_RU.po.
"""

import re
import os
from datetime import datetime

SCRIPT_DIR = os.path.dirname(os.path.abspath(__file__))
POT_FILE = os.path.join(SCRIPT_DIR, "seo-fury.pot")
PO_FILE = os.path.join(SCRIPT_DIR, "seo-fury-ru_RU.po")

# ============================================================
# COMPLETE TRANSLATION DICTIONARY: English -> Russian
# ============================================================
TRANSLATIONS = {
    # --- Plugin metadata ---
    "SEO Fury": "SEO Fury",
    "Complete SEO plugin with licensing, robots.txt, sitemaps, redirects, and IndexNow.":
        "Комплексный SEO-плагин с лицензированием, robots.txt, картами сайта, редиректами и IndexNow.",
    "SEO Fury Team": "Команда SEO Fury",

    # --- 404 Monitor Settings ---
    "404 Monitor Settings": "Настройки мониторинга 404",
    "Enable Monitoring": "Включить мониторинг",
    "Ignore Bots": "Игнорировать ботов",
    "Auto Cleanup": "Автоочистка",
    "Debug Logging": "Журнал отладки",
    "Track and analyze 404 errors on your site.":
        "Отслеживайте и анализируйте ошибки 404 на вашем сайте.",
    "Enable 404 tracking": "Включить отслеживание 404",
    "Do not log requests from search bots":
        "Не записывать запросы от поисковых ботов",
    "Ignores Googlebot, Bingbot, Yandex, and other known bots.":
        "Игнорирует Googlebot, Bingbot, Yandex и других известных ботов.",
    "days": "дней",
    "Automatically delete entries older than this number of days. 0 = never delete":
        "Автоматически удалять записи старше указанного количества дней. 0 = никогда не удалять",
    "Enable verbose logging for diagnostics":
        "Включить подробное логирование для диагностики",
    "Writes detailed module logs to debug.log. Use for troubleshooting. Logs are in wp-content/debug.log (when WP_DEBUG_LOG is enabled).":
        "Записывает подробные логи модулей в debug.log. Используйте для устранения неполадок. Логи находятся в wp-content/debug.log (когда WP_DEBUG_LOG включён).",

    # --- Common messages ---
    "Insufficient permissions": "Недостаточно прав",
    "Logs cleared": "Логи очищены",
    "URL is required": "URL обязателен",
    "Invalid ID": "Неверный ID",
    "Marked as resolved": "Отмечено как решённое",
    "Entry deleted": "Запись удалена",
    "Please fill in all fields": "Пожалуйста, заполните все поля",
    "A redirect with this source already exists":
        "Редирект с таким источником уже существует",
    "Redirect created successfully!": "Редирект успешно создан!",
    "Error creating redirect: ": "Ошибка создания редиректа: ",

    # --- Table headers ---
    "URL": "URL",
    "Hits": "Хиты",
    "First Seen": "Первое обнаружение",
    "Last Seen": "Последнее обнаружение",
    "Status": "Статус",
    "Resolved": "Решено",
    "Active": "Активно",

    # --- Admin UI ---
    "Loading...": "Загрузка...",
    "No redirects found": "Редиректы не найдены",
    "Inactive": "Неактивно",
    "Activate": "Активировать",
    "Deactivate": "Деактивировать",
    "Edit": "Редактировать",
    "Delete": "Удалить",
    "Adding...": "Добавление...",
    "Deleting...": "Удаление...",
    "Saving...": "Сохранение...",
    "Updating...": "Обновление...",
    "Please fill all fields": "Пожалуйста, заполните все поля",
    "Redirect added successfully!": "Редирект успешно добавлен!",
    "Redirect deleted!": "Редирект удалён!",
    "Redirect updated!": "Редирект обновлён!",
    "Are you sure you want to delete this redirect?":
        "Вы уверены, что хотите удалить этот редирект?",
    "Error loading redirects": "Ошибка загрузки редиректов",
    "Error loading data": "Ошибка загрузки данных",
    "Error adding redirect": "Ошибка добавления редиректа",
    "Error deleting redirect": "Ошибка удаления редиректа",
    "Error updating redirect": "Ошибка обновления редиректа",
    "Error updating status": "Ошибка обновления статуса",

    # --- CSV ---
    "Please select a CSV file.": "Пожалуйста, выберите CSV-файл.",
    "CSV import completed.": "Импорт CSV завершён.",
    "Imported": "Импортировано",
    "Updated": "Обновлено",
    "Skipped": "Пропущено",
    "Upload failed.": "Загрузка не удалась.",
    "Error": "Ошибка",
    "An error occurred": "Произошла ошибка",

    # --- IndexNow UI ---
    "Please enter at least one URL": "Пожалуйста, введите хотя бы один URL",
    "No valid URLs found": "Валидные URL не найдены",
    "Maximum 10,000 URLs per request. You have:":
        "Максимум 10 000 URL за один запрос. У вас:",
    "Sending...": "Отправка...",
    "Sending in batches...": "Отправка пакетами...",
    "Generating...": "Генерация...",
    "Checking...": "Проверка...",
    "Success!": "Успешно!",
    "URLs sent:": "URL отправлено:",
    "Error!": "Ошибка!",
    "Unknown error": "Неизвестная ошибка",
    "Server connection error": "Ошибка подключения к серверу",
    "Settings saved": "Настройки сохранены",
    "Save error": "Ошибка сохранения",
    "Key generated!": "Ключ сгенерирован!",
    "Verify key": "Проверить ключ",
    "No history yet": "Истории пока нет",
    "Are you sure you want to clear the entire history?":
        "Вы уверены, что хотите очистить всю историю?",
    "History cleared": "История очищена",
    "Clear failed": "Не удалось очистить",
    "Sending batch": "Отправка пакета",
    "of": "из",
    "All batches sent successfully!": "Все пакеты успешно отправлены!",
    "Total URLs:": "Всего URL:",
    "Batches:": "Пакеты:",
    "Completed with errors": "Завершено с ошибками",
    "Errors:": "Ошибки:",

    # --- License UI ---
    "Please enter a license key.": "Пожалуйста, введите лицензионный ключ.",
    "Invalid key format.": "Неверный формат ключа.",
    "Activating...": "Активация...",
    "License activated! The page will reload...":
        "Лицензия активирована! Страница перезагрузится...",
    "License activation failed": "Не удалось активировать лицензию",
    "Activation server connection error":
        "Ошибка подключения к серверу активации",
    "Are you sure you want to deactivate the license?\n\nAll PRO features will be disabled.":
        "Вы уверены, что хотите деактивировать лицензию?\n\nВсе PRO-функции будут отключены.",
    # Aliases with actual escaped quotes for PO-format matching
    'Search results for "%s"': 'Результаты поиска для «%s»',
    'One line per rule, e.g. "Mo-Fr 09:00-18:00"':
        'По одному правилу на строку, напр. «Mo-Fr 09:00-18:00»',
    'Example: "%1$s" \u2192 "%2$s"': 'Пример: «%1$s» \u2192 «%2$s»',
    'No per-URL overrides yet. Click "+ Add URL" to add one.':
        'Переопределений для URL пока нет. Нажмите «+ Добавить URL», чтобы добавить.',
    "Deactivating...": "Деактивация...",
    "License deactivated. The page will reload...":
        "Лицензия деактивирована. Страница перезагрузится...",
    "Deactivation failed": "Не удалось деактивировать",
    "License is active and valid!": "Лицензия активна и действительна!",
    "Plan:": "Тариф:",
    "Status:": "Статус:",
    "Expires:": "Истекает:",
    "License is inactive or expired.": "Лицензия неактивна или истекла.",
    "Could not reach the license server. Using local cache.":
        "Не удалось связаться с сервером лицензий. Используется локальный кеш.",
    "Key copied to clipboard!": "Ключ скопирован в буфер обмена!",
    "Click to copy": "Нажмите для копирования",

    # --- 404 Monitor UI ---
    "Load error": "Ошибка загрузки",
    "No 404 errors found": "Ошибки 404 не найдены",
    "Find": "Найти",
    "Redirect": "Редирект",
    "Resolve": "Решить",
    "Are you sure? All 404 logs will be deleted!":
        "Вы уверены? Все логи 404 будут удалены!",
    "Searching for similar pages...": "Поиск похожих страниц...",
    "Found %d similar pages:": "Найдено %d похожих страниц:",
    "Use this URL": "Использовать этот URL",
    "No similar pages found": "Похожие страницы не найдены",
    "Please provide a target URL": "Пожалуйста, укажите целевой URL",
    "Creating...": "Создание...",
    "Error creating redirect": "Ошибка создания редиректа",
    "Delete this entry?": "Удалить эту запись?",

    # --- Admin menu tabs ---
    "General Settings": "Общие настройки",
    "Meta Titles": "Мета-заголовки",
    "Robots.txt": "Robots.txt",
    "Sitemap": "Карта сайта",
    "Breadcrumbs": "Хлебные крошки",
    "Local SEO": "Локальный SEO",
    "SSL & Security": "SSL и безопасность",
    "WooCommerce SEO": "WooCommerce SEO",
    "Redirects": "Редиректы",
    "404 Monitor": "Монитор 404",
    "IndexNow": "IndexNow",
    "Changelog": "Журнал изменений",
    "License": "Лицензия",
    "Version %s": "Версия %s",

    # --- Internal Linking ---
    "Internal Linking": "Внутренняя перелинковка",
    "Scan your posts and pages for internal linking opportunities. The module analyzes your content and suggests relevant links to other published pages based on keyword and title matching.":
        "Сканируйте записи и страницы для поиска возможностей внутренней перелинковки. Модуль анализирует ваш контент и предлагает релевантные ссылки на другие опубликованные страницы на основе совпадений по ключевым словам и заголовкам.",
    "Open any post or page in the editor and click the":
        "Откройте любую запись или страницу в редакторе и нажмите на вкладку",
    "Links": "Ссылки",
    "tab in the SEO Fury sidebar.": "на боковой панели SEO Fury.",
    "PRO Feature": "PRO-функция",
    "Available in all PRO plans. Upgrade to unlock smart internal linking suggestions in the post editor.":
        "Доступно во всех PRO-тарифах. Обновитесь, чтобы разблокировать умные предложения по внутренней перелинковке в редакторе записей.",
    "Upgrade": "Обновить",

    # --- Sitemap Links ---
    "Sitemap Links": "Ссылки на карту сайта",
    "Index XML Sitemap:": "Индексная XML-карта сайта:",
    "HTML Sitemap:": "HTML-карта сайта:",
    "You can also use the %s shortcode to display the HTML sitemap on any page.":
        "Вы также можете использовать шорткод %s для отображения HTML-карты сайта на любой странице.",

    # --- Redirects ---
    "Create 301, 302 and 307 redirects. Track total hits.":
        "Создавайте редиректы 301, 302 и 307. Отслеживайте общее количество хитов.",
    "Redirects used: %1$s of %2$s": "Использовано редиректов: %1$s из %2$s",
    "You are nearing the FREE plan limit.":
        "Вы приближаетесь к лимиту бесплатного тарифа.",
    "PRO provides unlimited redirects.":
        "PRO предоставляет неограниченное количество редиректов.",
    "Upgrade to PRO": "Перейти на PRO",
    "Add a new redirect": "Добавить новый редирект",
    "Source URL": "URL-источник",
    "/old-page": "/старая-страница",
    "Relative path, e.g. %s": "Относительный путь, напр. %s",
    "Target URL": "Целевой URL",
    "/new-page": "/новая-страница",
    "Full URL or relative path": "Полный URL или относительный путь",
    "Redirect Type": "Тип редиректа",
    "301 (Permanent)": "301 (Постоянный)",
    "302 (Temporary)": "302 (Временный)",
    "307 (Temporary, preserves method)": "307 (Временный, сохраняет метод)",
    "Add Redirect": "Добавить редирект",
    "Import / Export CSV": "Импорт / Экспорт CSV",
    "Export all redirects or import a CSV with columns: %s.":
        "Экспортируйте все редиректы или импортируйте CSV с колонками: %s.",
    "Export CSV": "Экспорт CSV",
    "Import CSV": "Импорт CSV",
    "Redirects List": "Список редиректов",
    "ID": "ID",
    "Source": "Источник",
    "Target": "Цель",
    "Type": "Тип",
    "Created": "Создано",
    "Actions": "Действия",
    "Edit Redirect": "Редактировать редирект",
    "Save Changes": "Сохранить изменения",

    # --- IndexNow page ---
    "Submit URLs directly to the IndexNow API.":
        "Отправляйте URL напрямую в API IndexNow.",
    "Learn more": "Подробнее",
    "Save Settings": "Сохранить настройки",
    "Submit URLs": "Отправить URL",
    "URLs to submit": "URL для отправки",
    "Enter one URL per line...": "Введите по одному URL в строке...",
    "Enter one URL per line. You can submit up to 10,000 URLs at once.":
        "Введите по одному URL в строке. Можно отправить до 10 000 URL за раз.",
    "Submit to IndexNow": "Отправить в IndexNow",
    "Submission History": "История отправок",
    "Last 100 IndexNow API requests.": "Последние 100 запросов к API IndexNow.",
    "Load History": "Загрузить историю",
    "Clear History": "Очистить историю",
    "Time": "Время",
    "Response": "Ответ",
    "Method": "Метод",

    # --- 404 Monitor page ---
    "404 logs used: %1$s of %2$s": "Использовано логов 404: %1$s из %2$s",
    "PRO removes limits for 404 logging.":
        "PRO снимает ограничения на логирование 404.",
    "Tracking 404 errors helps find broken links and create redirects.":
        "Отслеживание ошибок 404 помогает находить нерабочие ссылки и создавать редиректы.",
    "404 Statistics": "Статистика 404",
    "Total URLs": "Всего URL",
    "Total Hits": "Всего хитов",
    "Refresh": "Обновить",
    "Clear All": "Очистить всё",
    "Find a Similar Page": "Найти похожую страницу",
    "404 URL:": "URL 404:",
    "Create Redirect": "Создать редирект",
    "Source (404 URL)": "Источник (URL 404)",
    "Target (Target URL)": "Цель (Целевой URL)",

    # --- License page ---
    "License Active": "Лицензия активна",
    "License Key:": "Лицензионный ключ:",
    "Free": "Бесплатный",
    "Pro Starter": "Pro Starter",
    "Pro Business": "Pro Business",
    "Pro Agency": "Pro Agency",
    "Lifetime": "Пожизненный",
    "Unknown": "Неизвестно",
    "Domain:": "Домен:",
    "Available Features:": "Доступные функции:",
    "Advanced SEO": "Расширенный SEO",
    "Advanced SEO features": "Расширенные SEO-функции",
    "Not available on your plan": "Недоступно на вашем тарифе",
    "Unlimited redirects": "Неограниченные редиректы",
    "Limited to 50": "Ограничено 50",
    "Unlimited 404 logs": "Неограниченные логи 404",
    "404 Logs": "Логи 404",
    "Limited to 100": "Ограничено 100",
    "Smart link suggestions": "Умные предложения ссылок",
    "White Label": "White Label",
    "Branding": "Брендинг",
    "Not available": "Недоступно",
    "Priority Support": "Приоритетная поддержка",
    "Priority support": "Приоритетная поддержка",
    "Support": "Поддержка",
    "Standard support": "Стандартная поддержка",
    "Priority support is active": "Приоритетная поддержка активна",
    "Reply within 24 hours": "Ответ в течение 24 часов",
    "Direct line to developers": "Прямая связь с разработчиками",
    "Help with setup and optimization": "Помощь с настройкой и оптимизацией",
    "Deactivate License": "Деактивировать лицензию",
    "Check Status": "Проверить статус",
    "License Not Activated": "Лицензия не активирована",
    "Enter a license key to activate plugin features.":
        "Введите лицензионный ключ для активации функций плагина.",
    "Supported formats:": "Поддерживаемые форматы:",
    "License Key": "Лицензионный ключ",
    "PRO format: %s": "Формат PRO: %s",
    "FREE format: %s": "Формат FREE: %s",
    "Activate License": "Активировать лицензию",
    "Available plans:": "Доступные тарифы:",
    "%s domain": "%s домен",
    "%s redirects": "%s редиректов",
    "%s 404 logs": "%s логов 404",
    "month": "мес.",
    "%s domains": "%s доменов",
    "Everything in Starter +": "Всё из Starter +",
    "Unlimited domains": "Неограниченные домены",
    "Everything in Business +": "Всё из Business +",
    "All pro features": "Все PRO-функции",
    "one-time": "разовый платёж",
    "All features forever": "Все функции навсегда",
    "Lifetime updates": "Пожизненные обновления",
    "Buy a license": "Купить лицензию",

    # --- SSL / HTTPS ---
    "SSL / HTTPS Security": "SSL / HTTPS безопасность",
    "Protect your site with HTTPS enforcement, mixed content fixes, and security headers.":
        "Защитите свой сайт с помощью принудительного HTTPS, исправления смешанного контента и заголовков безопасности.",
    "SSL Certificate": "SSL-сертификат",
    "Not detected": "Не обнаружен",
    "HTTPS Redirect": "HTTPS-редирект",
    "Enabled": "Включено",
    "Disabled": "Отключено",
    "Mixed Content": "Смешанный контент",
    "Auto-fix on": "Автоисправление включено",
    "Not active": "Не активно",
    "HSTS Header": "Заголовок HSTS",
    "Save Security Settings": "Сохранить настройки безопасности",
    "All updates and improvements for the plugin":
        "Все обновления и улучшения плагина",
    "Current version": "Текущая версия",
    "Unable to load changelog. Please check your internet connection.":
        "Не удалось загрузить журнал изменений. Проверьте подключение к интернету.",
    "Retry": "Повторить",

    # --- Breadcrumbs ---
    "Enable Breadcrumbs": "Включить хлебные крошки",
    "Show Home Link": "Показать ссылку на главную",
    "Home Label": "Название главной",
    "Home URL": "URL главной",
    "Breadcrumb Prefix": "Префикс хлебных крошек",
    "Separator": "Разделитель",
    "Archive Format": "Формат архива",
    "404 Label": "Название страницы 404",
    "Hide Post Title": "Скрыть заголовок записи",
    "Show Categories": "Показать рубрики",
    "Hide Taxonomy Name": "Скрыть название таксономии",
    "How to display breadcrumbs": "Как отобразить хлебные крошки",
    "Use this PHP snippet in your theme template:":
        "Используйте этот PHP-код в шаблоне вашей темы:",
    "Or use shortcode:": "Или используйте шорткод:",
    "Enable and configure breadcrumbs for your site.":
        "Включите и настройте хлебные крошки для вашего сайта.",
    "Show breadcrumbs output": "Показывать хлебные крошки",
    "Show link to the homepage": "Показывать ссылку на главную страницу",
    "Home": "Главная",
    "The label used for the homepage link (the first item) in breadcrumb trails.":
        "Название, используемое для ссылки на главную страницу (первый элемент) в цепочке хлебных крошек.",
    "The homepage link (the first item) in breadcrumb trails. Leave empty to use the default homepage URL.":
        "Ссылка на главную страницу (первый элемент) в цепочке хлебных крошек. Оставьте пустым для использования URL главной страницы по умолчанию.",
    "An element displayed before the breadcrumb trail.":
        "Элемент, отображаемый перед цепочкой хлебных крошек.",
    "Custom": "Произвольный",
    "Enter custom separator": "Введите произвольный разделитель",
    'Search results for "%s"': 'Результаты поиска для «%s»',
    "Format the label used for search results pages. Use %s as a placeholder for the search query.":
        "Настройте название для страниц результатов поиска. Используйте %s в качестве подстановки для поискового запроса.",
    "Page not found": "Страница не найдена",
    "The label used for the 404 error page in breadcrumb trails.":
        "Название страницы ошибки 404 в цепочке хлебных крошек.",
    "Hide the post title in the breadcrumb trail":
        "Скрыть заголовок записи в цепочке хлебных крошек",
    "If a category is a child, display all parent categories":
        "Если рубрика является дочерней, отображать все родительские рубрики",
    "Hide the taxonomy name in the breadcrumb trail":
        "Скрыть название таксономии в цепочке хлебных крошек",

    # --- Core ---
    "Plugin files have been modified. PRO features disabled for security.":
        "Файлы плагина были изменены. PRO-функции отключены в целях безопасности.",

    # --- General SEO Settings ---
    "General SEO Settings": "Общие настройки SEO",
    "Settings": "Настройки",
    "URL Transliteration": "Транслитерация URL",
    "Enable White Label": "Включить White Label",
    "Plugin Name": "Название плагина",
    "Hide Branding Links": "Скрыть ссылки на бренд",
    "Bulk URL Conversion": "Массовая конвертация URL",
    "Force HTTPS": "Принудительный HTTPS",
    "Fix Mixed Content": "Исправить смешанный контент",
    "WWW Redirect": "WWW-редирект",
    "Configure the main SEO settings for your site.":
        "Настройте основные SEO-параметры вашего сайта.",
    "Enable automatic transliteration for non-Latin URLs":
        "Включить автоматическую транслитерацию для нелатинских URL",
    "Automatically converts non-Latin characters to Latin in post and page URLs.":
        "Автоматически преобразует нелатинские символы в латинские в URL записей и страниц.",
    "Insufficient permissions.": "Недостаточно прав.",
    "Convert existing non-Latin URLs to Latin slugs.":
        "Преобразовать существующие нелатинские URL в латинские ярлыки.",
    "Loading stats...": "Загрузка статистики...",
    "Posts": "Записи",
    "Pages": "Страницы",
    "Refresh Stats": "Обновить статистику",
    "Convert URLs": "Преобразовать URL",
    "URL stats:": "Статистика URL:",
    "Total:": "Всего:",
    "Non-Latin:": "Нелатинские:",
    "Latin:": "Латинские:",
    "Are you sure? This will change URLs for all posts with non-Latin slugs.":
        "Вы уверены? Это изменит URL всех записей с нелатинскими ярлыками.",
    "We recommend backing up the database first.":
        "Рекомендуем сначала сделать резервную копию базы данных.",
    "Converting...": "Конвертация...",
    "Conversion completed!": "Конвертация завершена!",
    "Updated:": "Обновлено:",
    "Skipped (already Latin):": "Пропущено (уже латинские):",
    "Total checked:": "Всего проверено:",
    "Error:": "Ошибка:",
    "Configure HTTPS enforcement, HSTS headers, and WWW redirect.":
        "Настройте принудительный HTTPS, заголовки HSTS и WWW-редирект.",
    "Redirect all HTTP requests to HTTPS (301)":
        "Перенаправлять все HTTP-запросы на HTTPS (301)",
    "Requires a valid SSL certificate installed on your server.":
        "Требуется действующий SSL-сертификат, установленный на вашем сервере.",
    "Automatically replace HTTP with HTTPS in page output":
        "Автоматически заменять HTTP на HTTPS в выводе страниц",
    "Fixes mixed content warnings by rewriting internal HTTP URLs to HTTPS on the frontend.":
        "Исправляет предупреждения о смешанном контенте путём замены внутренних HTTP URL на HTTPS на стороне клиента.",
    "Send Strict-Transport-Security header":
        "Отправлять заголовок Strict-Transport-Security",
    "Max-Age (seconds):": "Max-Age (секунды):",
    "Default: 31536000 (1 year)": "По умолчанию: 31536000 (1 год)",
    "Tells browsers to always use HTTPS for this domain. Only enable if SSL is fully configured.":
        "Указывает браузерам всегда использовать HTTPS для этого домена. Включайте только при полностью настроенном SSL.",
    "No redirect": "Без редиректа",
    "Force www (redirect non-www to www)":
        "Принудительный www (редирект non-www на www)",
    "Force non-www (redirect www to non-www)":
        "Принудительный non-www (редирект www на non-www)",
    "Enforce a canonical www or non-www version of your domain (301 redirect).":
        "Задайте каноническую версию вашего домена с www или без www (301-редирект).",
    "White Label is a PRO feature": "White Label — это PRO-функция",
    "Rename the plugin and remove branding. Perfect for agencies and resellers.":
        "Переименуйте плагин и удалите брендинг. Идеально для агентств и реселлеров.",
    "Customize the plugin branding for your product.":
        "Настройте брендинг плагина для вашего продукта.",
    "Enable white label": "Включить white label",
    "When enabled, the plugin name changes across the admin UI.":
        "При включении название плагина меняется во всём интерфейсе администрирования.",
    "New plugin name used across the UI.":
        "Новое название плагина, используемое во всём интерфейсе.",
    "Hide all branding links": "Скрыть все ссылки на бренд",
    "Removes upgrade links and branding references.":
        "Удаляет ссылки на обновление и упоминания бренда.",

    # --- IndexNow Settings ---
    "IndexNow Settings": "Настройки IndexNow",
    "IndexNow API Key": "API-ключ IndexNow",
    "Search Engine": "Поисковая система",
    "Automatic Submission": "Автоматическая отправка",
    "Submit on Delete": "Отправлять при удалении",
    "Instant indexing module settings.":
        "Настройки модуля мгновенной индексации.",
    "Generate Key": "Сгенерировать ключ",
    "Verify Key": "Проверить ключ",
    "API key for IndexNow. It will be saved in the site root.":
        "API-ключ для IndexNow. Будет сохранён в корне сайта.",
    "IndexNow (all search engines)": "IndexNow (все поисковые системы)",
    "Bing": "Bing",
    "Yandex": "Яндекс",
    "Seznam": "Seznam",
    "Select the search engine to notify.":
        "Выберите поисковую систему для уведомления.",
    "Automatically submit URLs on publish/update":
        "Автоматически отправлять URL при публикации/обновлении",
    "Automatically notify on deletion":
        "Автоматически уведомлять при удалении",
    "Please provide URLs to submit": "Пожалуйста, укажите URL для отправки",
    "No valid URLs provided": "Валидные URL не предоставлены",
    "Submission completed": "Отправка завершена",
    "Failed to create key file. Check permissions.":
        "Не удалось создать файл ключа. Проверьте права доступа.",
    "API key is not configured": "API-ключ не настроен",
    "Key file not found on the server":
        "Файл ключа не найден на сервере",
    "Key file content does not match":
        "Содержимое файла ключа не совпадает",
    "Failed to check file availability: %s":
        "Не удалось проверить доступность файла: %s",
    "Key file is not accessible via URL (code: %d)":
        "Файл ключа не доступен по URL (код: %d)",
    "Key file content via URL does not match":
        "Содержимое файла ключа по URL не совпадает",
    "Key verified successfully!": "Ключ успешно проверен!",
    "Failed to clear history": "Не удалось очистить историю",
    "URL sent successfully": "URL успешно отправлен",
    "Error: %d": "Ошибка: %d",

    # --- License backend ---
    "Invalid license key format": "Неверный формат лицензионного ключа",
    "Error: invalid API response format":
        "Ошибка: неверный формат ответа API",
    "License activated successfully!": "Лицензия успешно активирована!",
    "License deactivated": "Лицензия деактивирована",
    "Invalid response": "Неверный ответ",
    "License key is required": "Лицензионный ключ обязателен",
    "Invalid response format": "Неверный формат ответа",
    "License activated": "Лицензия активирована",
    "Activation failed": "Ошибка активации",

    # --- Local SEO ---
    "Enable Local SEO": "Включить локальный SEO",
    "Business Type": "Тип бизнеса",
    "Business Name": "Название компании",
    "Phone": "Телефон",
    "Email": "Электронная почта",
    "Logo URL": "URL логотипа",
    "Image URL": "URL изображения",
    "Price Range": "Ценовой диапазон",
    "Street Address": "Улица",
    "City": "Город",
    "Region/State": "Регион/область",
    "Postal Code": "Почтовый индекс",
    "Country": "Страна",
    "Latitude": "Широта",
    "Longitude": "Долгота",
    "Opening Hours": "Часы работы",
    "Configure your local business details for Local SEO schema.":
        "Настройте данные вашего бизнеса для схемы локального SEO.",
    "Output LocalBusiness schema on the frontend":
        "Выводить схему LocalBusiness на сайте",
    "Example: LocalBusiness, Store, Restaurant, MedicalBusiness":
        "Например: LocalBusiness, Store, Restaurant, MedicalBusiness",
    'One line per rule, e.g. "Mo-Fr 09:00-18:00"':
        'По одному правилу на строку, напр. «Mo-Fr 09:00-18:00»',

    # --- Meta Titles ---
    "Robots Meta": "Robots Meta",
    "Robots Meta Tags": "Мета-теги Robots",
    "Advanced Robots Meta": "Расширенные Robots Meta",
    "Snippet": "Сниппет",
    "Video Preview": "Предпросмотр видео",
    "Image Preview Size": "Размер превью изображения",
    "Noindex Empty Archives": "Noindex для пустых архивов",
    "Empty Archives": "Пустые архивы",
    "Title Settings": "Настройки заголовков",
    "Title Separator": "Разделитель заголовка",
    "Capitalize Titles": "Заглавные буквы в заголовках",
    "Twitter Card": "Карточка Twitter",
    "Content Type Templates": "Шаблоны типов контента",
    "Templates": "Шаблоны",
    "Twitter Card Type": "Тип карточки Twitter",
    "Default values for the robots meta tag.":
        "Значения по умолчанию для мета-тега robots.",
    "Important:": "Важно:",
    "Do not enable %1$s and %2$s at the same time. If both are enabled, %2$s takes priority.":
        "Не включайте %1$s и %2$s одновременно. Если оба включены, приоритет имеет %2$s.",
    "Index": "Index",
    "Allow search engines to index and show these pages in results":
        "Разрешить поисковым системам индексировать и показывать эти страницы в результатах",
    "NoIndex": "NoIndex",
    "Prevent indexing and showing pages in search results":
        "Запретить индексацию и отображение страниц в результатах поиска",
    "NoFollow": "NoFollow",
    "Prevent search engines from following links on the page":
        "Запретить поисковым системам переходить по ссылкам на странице",
    "NoArchive": "NoArchive",
    "Prevent cached links in search results":
        "Запретить кешированные ссылки в результатах поиска",
    "NoImageIndex": "NoImageIndex",
    "Prevent indexing page images by search engines":
        "Запретить индексацию изображений на странице поисковыми системами",
    "NoSnippet": "NoSnippet",
    "Prevents displaying snippets in search results":
        "Запрещает отображение сниппетов в результатах поиска",
    "Additional settings to control content appearance in search results.":
        "Дополнительные настройки для управления отображением контента в результатах поиска.",
    "characters": "символов",
    "Set the maximum snippet length in characters.":
        "Установите максимальную длину сниппета в символах.",
    "means unlimited.": "означает без ограничений.",
    "disables snippets.": "отключает сниппеты.",
    "seconds": "секунд",
    "Set the maximum video preview length in seconds.":
        "Установите максимальную длительность предпросмотра видео в секундах.",
    "disables video previews.": "отключает предпросмотр видео.",
    "None": "Нет",
    "Standard": "Стандартный",
    "Large": "Большой",
    "Set the maximum image preview size for images on this page.":
        "Установите максимальный размер превью изображений на этой странице.",
    "disables image previews.": "отключает превью изображений.",
    "are standard limits.": "стандартные ограничения.",
    "Adding noindex for empty archives helps avoid indexing empty pages.":
        "Добавление noindex для пустых архивов помогает избежать индексации пустых страниц.",
    "Add %s for empty category and tag archives":
        "Добавить %s для пустых архивов рубрик и меток",
    "When a post is added, the archive switches back to %s.":
        "Когда добавляется запись, архив возвращается к %s.",
    "Configure how page titles are displayed on your site.":
        "Настройте отображение заголовков страниц на вашем сайте.",
    "Use the separator in title templates with %1$s or %2$s.":
        "Используйте разделитель в шаблонах заголовков с помощью %1$s или %2$s.",
    "Preview:": "Предпросмотр:",
    "Page title": "Заголовок страницы",
    "Site name": "Название сайта",
    "Automatically capitalize each word in titles":
        "Автоматически делать заглавной первую букву каждого слова в заголовках",
    'Example: "%1$s" \u2192 "%2$s"': 'Пример: «%1$s» \u2192 «%2$s»',
    "Configure the Twitter card type for your pages.":
        "Настройте тип карточки Twitter для ваших страниц.",
    "Summary with large image": "Сводка с большим изображением",
    "Summary": "Сводка",
    "This card type is used for new posts and for posts without a selected card type.":
        "Этот тип карточки используется для новых записей и для записей без выбранного типа карточки.",
    "Set default title and description templates for each content type.":
        "Задайте шаблоны заголовков и описаний по умолчанию для каждого типа контента.",
    "Available variables:": "Доступные переменные:",
    "Content Type": "Тип контента",
    "Title Template": "Шаблон заголовка",
    "Description Template": "Шаблон описания",
    "General Meta": "Общие мета-данные",
    "Authors": "Авторы",
    "Misc Pages": "Прочие страницы",
    "Taxonomies": "Таксономии",
    "Post Types": "Типы записей",
    "Homepage Title": "Заголовок главной страницы",
    "Homepage Description": "Описание главной страницы",
    "Author Archive Title": "Заголовок архива автора",
    "Author Archive Description": "Описание архива автора",
    "Blog Page Title": "Заголовок страницы блога",
    "Blog Page Description": "Описание страницы блога",
    "Search Results Title": "Заголовок результатов поиска",
    "Search Results Description": "Описание результатов поиска",
    "Date Archive Title": "Заголовок архива по дате",
    "Date Archive Description": "Описание архива по дате",
    "404 Title": "Заголовок 404",
    "404 Description": "Описание 404",
    "%s Title": "Заголовок %s",
    "%s Description": "Описание %s",
    "Page Not Found": "Страница не найдена",

    # --- Post Meta Basic ---
    "Google Preview": "Предпросмотр Google",
    "Edit Snippet": "Редактировать сниппет",
    "Focus Keyword": "Ключевое слово",
    "e.g. Rank Math SEO": "напр. Rank Math SEO",
    "Basic SEO": "Базовый SEO",
    "Keyword Density:": "Плотность ключевых слов:",
    "Readability": "Удобочитаемость",
    "Readability:": "Удобочитаемость:",
    "Additional SEO": "Дополнительный SEO",
    "Extra on-page checks to improve visibility.":
        "Дополнительные проверки страницы для улучшения видимости.",
    "These settings override global robots meta for this page":
        "Эти настройки переопределяют глобальные мета-теги robots для этой страницы",
    "Prevent indexing of this page": "Запретить индексацию этой страницы",
    "Prevent following links": "Запретить переход по ссылкам",
    "Prevent cached copy": "Запретить кешированную копию",
    "Prevent snippet display": "Запретить отображение сниппета",
    "Prevent image indexing": "Запретить индексацию изображений",
    "Max Snippet": "Макс. сниппет",
    "Text length (-1 = unlimited)": "Длина текста (-1 = без ограничений)",
    "Max Video Preview": "Макс. предпросмотр видео",
    "Video length in seconds": "Длительность видео в секундах",
    "Max Image Preview": "Макс. превью изображения",
    "Default": "По умолчанию",
    "Preview size": "Размер превью",
    "Canonical URL": "Канонический URL",
    "Defaults to current page URL":
        "По умолчанию используется URL текущей страницы",

    # --- Schema types ---
    "Article": "Статья",
    "Blog Posting": "Запись блога",
    "News Article": "Новостная статья",
    "Product": "Товар",
    "Review": "Обзор",
    "Recipe": "Рецепт",
    "FAQ Page": "Страница FAQ",
    "How To": "Инструкция",
    "BreadcrumbList": "BreadcrumbList",
    "Table": "Таблица",
    "Service": "Услуга",
    "Job Posting": "Вакансия",
    "Course": "Курс",
    "Event": "Событие",
    "Local Business": "Локальный бизнес",
    "Organization": "Организация",
    "Person": "Персона",
    "Video Object": "Видеообъект",
    "Book": "Книга",
    "Software Application": "Программное приложение",

    # --- Schema UI ---
    "Used Schema": "Используемая Schema",
    "Custom JSON-LD": "Пользовательский JSON-LD",
    "Preview": "Предпросмотр",
    "Remove": "Удалить",
    "No schema selected yet. Use Schema Generator to apply.":
        "Schema ещё не выбрана. Используйте генератор Schema.",
    "Schema Generator": "Генератор Schema",
    "Schema Templates": "Шаблоны Schema",
    "Import": "Импорт",
    "No schema selected. Choose a template or import JSON-LD.":
        "Schema не выбрана. Выберите шаблон или импортируйте JSON-LD.",
    "Available Schema Types": "Доступные типы Schema",
    "Apply": "Применить",
    "Schema Settings": "Настройки Schema",
    "Schema JSON-LD Preview": "Предпросмотр Schema JSON-LD",
    "Import JSON-LD": "Импорт JSON-LD",
    "Paste JSON-LD": "Вставьте JSON-LD",
    "Paste valid JSON-LD without the %s tag":
        "Вставьте валидный JSON-LD без тега %s",
    "Apply JSON-LD": "Применить JSON-LD",
    "Custom JSON-LD Preview": "Предпросмотр пользовательского JSON-LD",
    "Done": "Готово",
    "Schema fields for this type will be available soon. You can manually add schema using the JSON-LD editor above.":
        "Поля Schema для этого типа скоро будут доступны. Вы можете добавить разметку вручную, используя редактор JSON-LD выше.",

    # --- Article Schema ---
    "Article Schema Details": "Детали Schema статьи",
    "Headline": "Заголовок",
    "Article headline (defaults to post title)":
        "Заголовок статьи (по умолчанию — заголовок записи)",
    "Author Name": "Имя автора",
    "Author of the article": "Автор статьи",
    "Publisher Name": "Название издателя",
    "Publisher organization name": "Название организации-издателя",
    "Publisher Logo URL": "URL логотипа издателя",
    "URL of publisher's logo (recommended: 600x60px)":
        "URL логотипа издателя (рекомендуется: 600x60px)",
    "Featured Image URL": "URL основного изображения",
    "Main image for the article": "Главное изображение статьи",
    "Date Published": "Дата публикации",
    "When was this article published?": "Когда была опубликована эта статья?",
    "Date Modified": "Дата изменения",
    "Last modification date": "Дата последнего изменения",

    # --- Product Schema ---
    "Product Schema Details": "Детали Schema товара",
    "Product Name": "Название товара",
    "Price": "Цена",
    "Currency": "Валюта",
    "Availability": "Наличие",
    "In Stock": "В наличии",
    "Out of Stock": "Нет в наличии",
    "Pre Order": "Предзаказ",
    "Brand": "Бренд",
    "SKU": "Артикул (SKU)",

    # --- FAQ Schema ---
    "FAQ Schema Details": "Детали Schema FAQ",
    "Add frequently asked questions and their answers":
        "Добавьте часто задаваемые вопросы и ответы на них",
    "Question %d": "Вопрос %d",
    "What is your question?": "Какой у вас вопрос?",
    "Answer": "Ответ",
    "Type the answer here...": "Введите ответ здесь...",
    "Add FAQ Item": "Добавить элемент FAQ",

    # --- How-To Schema ---
    "How-To Schema Details": "Детали Schema инструкции",
    "Guide Name": "Название руководства",
    "Description": "Описание",
    "Steps": "Шаги",
    "Step %d Name": "Название шага %d",
    "Step Description": "Описание шага",
    "Remove Step": "Удалить шаг",
    "Add Step": "Добавить шаг",

    # --- Review Schema ---
    "Review Schema Details": "Детали Schema обзора",
    "Item Reviewed": "Объект обзора",
    "Rating (1-5)": "Рейтинг (1-5)",
    "Reviewer Name": "Имя рецензента",
    "Review Date": "Дата обзора",

    # --- Recipe Schema ---
    "Recipe Schema Details": "Детали Schema рецепта",
    "Recipe Name": "Название рецепта",
    "Prep Time (minutes)": "Время подготовки (минуты)",
    "Cook Time (minutes)": "Время приготовления (минуты)",
    "Servings": "Порции",
    "4 servings": "4 порции",
    "Calories": "Калории",
    "Ingredients (one per line)": "Ингредиенты (по одному на строку)",
    "Instructions": "Инструкции",

    # --- Event Schema ---
    "Event Schema Details": "Детали Schema события",
    "Event Name": "Название события",
    "Start Date & Time": "Дата и время начала",
    "End Date & Time": "Дата и время окончания",
    "Location Name": "Название места",
    "Address": "Адрес",

    # --- Video Schema ---
    "Video Schema Details": "Детали Schema видео",
    "Video Title": "Название видео",
    "Video URL": "URL видео",
    "Thumbnail URL": "URL миниатюры",
    "Upload Date": "Дата загрузки",
    "Duration (ISO 8601)": "Продолжительность (ISO 8601)",
    "Format: PT1H30M (1 hour 30 minutes)":
        "Формат: PT1H30M (1 час 30 минут)",

    # --- BreadcrumbList Schema ---
    "BreadcrumbList Details": "Детали BreadcrumbList",
    "Enter one breadcrumb per line: Label | URL":
        "Введите по одной хлебной крошке на строку: Название | URL",

    # --- Table Schema ---
    "Table Schema Details": "Детали Schema таблицы",
    "Table Name": "Название таблицы",
    "Rows": "Строки",
    "Use one row per line, columns separated by |":
        "По одной строке на линию, столбцы разделяются символом |",

    # --- Service Schema ---
    "Service Schema Details": "Детали Schema услуги",
    "Service Name": "Название услуги",
    "Provider Name": "Название поставщика",
    "Area Served": "Обслуживаемый регион",
    "Service Type": "Тип услуги",

    # --- Job Posting Schema ---
    "Job Posting Details": "Детали вакансии",
    "Job Title": "Должность",
    "Date Posted": "Дата размещения",
    "Valid Through": "Действительно до",
    "Employment Type": "Тип занятости",
    "Full-time": "Полная занятость",
    "Hiring Organization": "Организация-работодатель",
    "Job Location": "Место работы",
    "City, Country": "Город, Страна",

    # --- Social Preview ---
    "Social Preview": "Предпросмотр в соцсетях",
    "Facebook": "Facebook",
    "Twitter": "Twitter",
    "Facebook user": "Пользователь Facebook",
    "2 hours ago": "2 часа назад",
    "FB Preview": "Предпросмотр FB",
    "Twitter user": "Пользователь Twitter",
    "2 hours": "2 часа",
    "Post with a link!": "Пост со ссылкой!",
    "Twitter Preview": "Предпросмотр Twitter",
    "Social Settings": "Настройки соцсетей",
    "All Networks": "Все сети",
    "Title": "Заголовок",
    "Title for all networks": "Заголовок для всех сетей",
    "Description for all networks": "Описание для всех сетей",
    "Image": "Изображение",
    "Choose Image": "Выбрать изображение",
    "Values apply to Facebook and Twitter":
        "Значения применяются к Facebook и Twitter",
    "Facebook Title": "Заголовок Facebook",
    "Post title": "Заголовок записи",
    "SEO title": "SEO-заголовок",
    "Separator \u2014": "Разделитель \u2014",
    "Category": "Рубрика",
    "Publish date": "Дата публикации",
    "Facebook Image": "Изображение Facebook",
    "Facebook Description": "Описание Facebook",
    "Post excerpt": "Отрывок записи",
    "SEO description": "SEO-описание",
    "Site description": "Описание сайта",
    "Twitter Title": "Заголовок Twitter",
    "Summary Large Image": "Сводка с большим изображением",
    "Twitter Description": "Описание Twitter",
    "Twitter Image": "Изображение Twitter",
    "OG Title": "OG-заголовок",
    "OG Type": "OG-тип",
    "Website": "Веб-сайт",
    "Video": "Видео",
    "OG Description": "OG-описание",
    "Product short description": "Краткое описание товара",
    "OG Image": "OG-изображение",
    "Select image": "Выбрать изображение",
    "Facebook Preview": "Предпросмотр Facebook",
    "2h": "2ч",
    "Facebook Settings": "Настройки Facebook",
    "Twitter (X) Settings": "Настройки Twitter (X)",

    # --- Post Meta SEO checks ---
    "Focus keyword is set": "Ключевое слово задано",
    "Add a focus keyword": "Добавьте ключевое слово",
    "Focus keyword in SEO title": "Ключевое слово в SEO-заголовке",
    "Add focus keyword to SEO title":
        "Добавьте ключевое слово в SEO-заголовок",
    "Focus keyword in meta description":
        "Ключевое слово в мета-описании",
    "Add focus keyword to meta description":
        "Добавьте ключевое слово в мета-описание",
    "Focus keyword in content": "Ключевое слово в контенте",
    "Add focus keyword to content": "Добавьте ключевое слово в контент",
    "Focus keyword in URL": "Ключевое слово в URL",
    "Add focus keyword to URL": "Добавьте ключевое слово в URL",
    "Keyword density is OK (0.5\u20132.5%)":
        "Плотность ключевых слов в норме (0,5\u20132,5%)",
    "Keyword density out of range (0.5\u20132.5%)":
        "Плотность ключевых слов вне диапазона (0,5\u20132,5%)",
    "SEO title length is OK (50\u201360)":
        "Длина SEO-заголовка в норме (50\u201360)",
    "Optimize SEO title length (50\u201360)":
        "Оптимизируйте длину SEO-заголовка (50\u201360)",
    "Meta description length is OK (120\u2013160)":
        "Длина мета-описания в норме (120\u2013160)",
    "Optimize meta description length (120\u2013160)":
        "Оптимизируйте длину мета-описания (120\u2013160)",
    "Content length is sufficient (300+ words)":
        "Длина контента достаточна (300+ слов)",
    "Add more content (minimum 300 words)":
        "Добавьте больше контента (минимум 300 слов)",
    "H1 heading is present": "Заголовок H1 присутствует",
    "Add an H1 heading": "Добавьте заголовок H1",
    "H2 subheadings are present": "Подзаголовки H2 присутствуют",
    "Add H2 subheadings": "Добавьте подзаголовки H2",
    "Images have alt attributes": "Изображения имеют атрибуты alt",
    "Add alt attributes to images":
        "Добавьте атрибуты alt к изображениям",
    "Internal link is present": "Внутренняя ссылка присутствует",
    "Add an internal link": "Добавьте внутреннюю ссылку",
    "Enough sentences for readability":
        "Достаточно предложений для удобочитаемости",
    "Add more sentences": "Добавьте больше предложений",
    "Average sentence length is OK":
        "Средняя длина предложений в норме",
    "Make sentences shorter": "Сделайте предложения короче",
    "No overly long sentences": "Нет слишком длинных предложений",
    "There are overly long sentences": "Есть слишком длинные предложения",
    "Multiple paragraphs detected": "Обнаружено несколько абзацев",
    "Split text into paragraphs": "Разделите текст на абзацы",
    "Paragraph length is OK": "Длина абзацев в норме",
    "Make paragraphs shorter": "Сделайте абзацы короче",
    "Lists are present": "Списки присутствуют",
    "Add lists (ul/ol)": "Добавьте списки (ul/ol)",
    "Excellent": "Отлично",
    "Okay": "Нормально",
    "Needs work": "Требует доработки",
    "Select an image": "Выберите изображение",
    "Use this image": "Использовать это изображение",
    "Keyword in first paragraph": "Ключевое слово в первом абзаце",
    "Add keyword to first paragraph":
        "Добавьте ключевое слово в первый абзац",
    "URL length is OK": "Длина URL в норме",
    "Shorten URL (up to 75 chars)": "Сократите URL (до 75 символов)",
    "External link is present": "Внешняя ссылка присутствует",
    "Add an external link": "Добавьте внешнюю ссылку",
    "Images are present in content": "Изображения присутствуют в контенте",
    "Add an image": "Добавьте изображение",
    "Scan Content": "Сканировать контент",
    "Scanning...": "Сканирование...",
    "Linked!": "Связано!",
    "Not found": "Не найдено",
    "Untitled": "Без заголовка",
    "No description available": "Описание отсутствует",

    # --- Post Meta tabs ---
    "SEO Basics": "Основы SEO",
    "Advanced": "Расширенные",
    "Schema": "Schema",
    "Edit SEO Snippet": "Редактировать SEO-сниппет",
    "General": "Общее",
    "Social": "Социальные сети",
    "SEO Title": "SEO-заголовок",
    "Separator -, \u2014": "Разделитель -, \u2014",
    "Parent page": "Родительская страница",
    "Tag": "Метка",
    "Taxonomy term": "Термин таксономии",
    "Current date": "Текущая дата",
    "Current year": "Текущий год",
    "Author name": "Имя автора",
    "Page number (2 of 4)": "Номер страницы (2 из 4)",
    "Post type (singular)": "Тип записи (единственное число)",
    "Search query": "Поисковый запрос",
    "Meta Description": "Мета-описание",
    "Excerpt field only": "Только поле отрывка",
    "Term description": "Описание термина",
    "Author bio": "Биография автора",
    "Meta Keywords": "Мета-ключевые слова",
    "Focus keyword": "Ключевое слово",
    "Keywords": "Ключевые слова",
    "Tags": "Метки",
    "All categories": "Все рубрики",
    "Separate keywords with commas":
        "Разделяйте ключевые слова запятыми",
    "Cancel": "Отмена",

    # --- PRO Features ---
    "PRO": "PRO",
    "Unlimited Redirects": "Неограниченные редиректы",
    "Unlimited 404 Monitoring": "Неограниченный мониторинг 404",
    "AI Bot Blocking": "Блокировка AI-ботов",
    "Schema Markup": "Разметка Schema",
    "Social Cards": "Социальные карточки",
    "FREE": "БЕСПЛАТНО",
    "50 Redirects": "50 редиректов",
    "100 404 Logs": "100 логов 404",
    "Meta Tags": "Мета-теги",
    "Upgrade to PRO to unlock %s":
        "Перейдите на PRO, чтобы разблокировать %s",
    "This feature requires a PRO license.":
        "Эта функция требует PRO-лицензию.",
    "This feature requires %1$sPRO license%2$s.":
        "Эта функция требует %1$sPRO-лицензию%2$s.",
    "FREE plan limited to %d items. Upgrade to PRO for unlimited.":
        "Бесплатный тариф ограничен %d записями. Перейдите на PRO для снятия ограничений.",
    "FREE plan limited to %1$d items. %2$sUpgrade to PRO%3$s for unlimited.":
        "Бесплатный тариф ограничен %1$d записями. %2$sПерейдите на PRO%3$s для снятия ограничений.",

    # --- Redirects backend ---
    "FREE plan limit reached (%d redirects). Upgrade to PRO for unlimited redirects.":
        "Достигнут лимит бесплатного тарифа (%d редиректов). Перейдите на PRO для неограниченных редиректов.",
    "FREE plan limit reached (%1$d redirects). %2$sUpgrade to PRO%3$s for unlimited redirects.":
        "Достигнут лимит бесплатного тарифа (%1$d редиректов). %2$sПерейдите на PRO%3$s для неограниченных редиректов.",
    "Please fill in all fields.": "Пожалуйста, заполните все поля.",
    "A redirect with this source already exists.":
        "Редирект с таким источником уже существует.",
    "Redirect added successfully.": "Редирект успешно добавлен.",
    "Failed to add redirect.": "Не удалось добавить редирект.",
    "Redirect deleted.": "Редирект удалён.",
    "Failed to delete redirect.": "Не удалось удалить редирект.",
    "Status updated.": "Статус обновлён.",
    "Failed to update status.": "Не удалось обновить статус.",
    "Redirects table is not created.": "Таблица редиректов не создана.",
    "Redirect updated.": "Редирект обновлён.",
    "Failed to update redirect.": "Не удалось обновить редирект.",
    "Table created.": "Таблица создана.",
    "CSV file is required.": "Требуется CSV-файл.",
    "Failed to read CSV file.": "Не удалось прочитать CSV-файл.",
    "Invalid CSV header.": "Неверный заголовок CSV.",

    # --- Robots.txt ---
    "Robots.txt Settings": "Настройки Robots.txt",
    "Enable virtual robots.txt": "Включить виртуальный robots.txt",
    "robots.txt Content": "Содержимое robots.txt",
    "Additional User-agent Blocks":
        "Дополнительные блоки User-agent",
    "Crawl-delay for bots": "Crawl-delay для ботов",
    "Use dynamic variables": "Использовать динамические переменные",
    "Block AI bots": "Блокировать AI-ботов",
    "Block web archive bots": "Блокировать ботов веб-архивов",
    "Reset settings": "Сбросить настройки",
    "Current robots.txt": "Текущий robots.txt",
    "Warning!": "Внимание!",
    "A physical robots.txt file was found in the site root.":
        "Физический файл robots.txt найден в корне сайта.",
    "It takes precedence over the virtual WordPress robots.txt.":
        "Он имеет приоритет над виртуальным WordPress robots.txt.",
    "Show physical file contents": "Показать содержимое физического файла",
    "No physical robots.txt file found in the site root.":
        "Физический файл robots.txt не найден в корне сайта.",
    "The virtual WordPress robots.txt is used.":
        "Используется виртуальный WordPress robots.txt.",
    "robots.txt editor. Available variables:":
        "Редактор robots.txt. Доступные переменные:",
    "Additional rule blocks for specific user agents. Example:":
        "Дополнительные блоки правил для определённых user-agent. Пример:",
    "Format: one line = %s, for example:":
        "Формат: одна строка = %s, например:",
    "Converted to %s directives for the listed bots.":
        "Преобразовано в директивы %s для перечисленных ботов.",
    "Automatically replace": "Автоматически заменять",
    "Block AI crawlers (GPTBot, ChatGPT-User, Google-Extended, Omgilibot, ClaudeBot, Claude-Web)":
        "Блокировать AI-краулеры (GPTBot, ChatGPT-User, Google-Extended, Omgilibot, ClaudeBot, Claude-Web)",
    "When enabled, robots.txt will include Disallow rules for popular AI crawlers.":
        "При включении robots.txt будет содержать правила Disallow для популярных AI-краулеров.",
    "to unlock": "для разблокировки",
    "Block web archive bots (Wayback Machine, Archive.org, archive.is, and others)":
        "Блокировать ботов веб-архивов (Wayback Machine, Archive.org, archive.is и других)",
    "When enabled, web archive services cannot store copies of your site.":
        "При включении сервисы веб-архивов не смогут сохранять копии вашего сайта.",
    "This helps protect unique content and prevents unauthorized archiving.":
        "Это помогает защитить уникальный контент и предотвратить несанкционированную архивацию.",
    "Reset to defaults": "Сбросить к значениям по умолчанию",
    "Restores robots.txt to default values.":
        "Восстанавливает robots.txt до значений по умолчанию.",
    "All custom changes will be lost.":
        "Все пользовательские изменения будут потеряны.",
    "Are you sure? All robots.txt settings will be reset.":
        "Вы уверены? Все настройки robots.txt будут сброшены.",
    "Resetting...": "Сброс...",
    "Reset complete!": "Сброс завершён!",
    "unknown": "неизвестно",
    "AJAX error": "Ошибка AJAX",
    "Settings reset.": "Настройки сброшены.",

    # --- Sitemap ---
    "XML Sitemap Settings": "Настройки XML-карты сайта",
    "Enable XML Sitemap": "Включить XML-карту сайта",
    "Post Types for XML Sitemap": "Типы записей для XML-карты сайта",
    "Include Images": "Включить изображения",
    "Exclude URLs": "Исключить URL",
    "Additional URLs": "Дополнительные URL",
    "HTML Sitemap Settings": "Настройки HTML-карты сайта",
    "HTML Sitemap Slug": "Ярлык HTML-карты сайта",
    "Post Types for HTML Sitemap": "Типы записей для HTML-карты сайта",
    "XML sitemap generation settings for search engines.":
        "Настройки генерации XML-карты сайта для поисковых систем.",
    "HTML sitemap settings for site visitors.":
        "Настройки HTML-карты сайта для посетителей.",
    "Enable XML sitemap generation": "Включить генерацию XML-карты сайта",
    "Generates dynamic XML sitemap files for search engines.":
        "Генерирует динамические XML-файлы карты сайта для поисковых систем.",
    "Select post types to include in the XML sitemap and configure parameters for each type.":
        "Выберите типы записей для включения в XML-карту сайта и настройте параметры для каждого типа.",
    "Priority:": "Приоритет:",
    "Changefreq:": "Частота изменений:",
    "Always": "Всегда",
    "Hourly": "Ежечасно",
    "Daily": "Ежедневно",
    "Weekly": "Еженедельно",
    "Monthly": "Ежемесячно",
    "Yearly": "Ежегодно",
    "Never": "Никогда",
    "Include images in sitemap": "Включить изображения в карту сайта",
    "Full or relative URLs to exclude from the XML sitemap (one per line).":
        "Полные или относительные URL для исключения из XML-карты сайта (по одному на строку).",
    "Default priority and change frequency for all additional URLs (unless overridden individually below).":
        "Приоритет и частота изменений по умолчанию для всех дополнительных URL (если не переопределены индивидуально ниже).",
    "Default Priority:": "Приоритет по умолчанию:",
    "Default Changefreq:": "Частота изменений по умолчанию:",
    "Additional URLs to add to the XML sitemap (one per line). These will use the default priority and changefreq above.":
        "Дополнительные URL для добавления в XML-карту сайта (по одному на строку). Они будут использовать приоритет и частоту изменений по умолчанию, указанные выше.",
    "Per-URL Priority & Changefreq":
        "Приоритет и частота изменений для каждого URL",
    "+ Add URL": "+ Добавить URL",
    "Override priority & changefreq per URL":
        "Переопределить приоритет и частоту изменений для каждого URL",
    "Upgrade to PRO to set individual priority and change frequency for each additional URL in your sitemap.":
        "Перейдите на PRO, чтобы задать индивидуальный приоритет и частоту изменений для каждого дополнительного URL в карте сайта.",
    "Priority": "Приоритет",
    "Changefreq": "Частота изменений",
    'No per-URL overrides yet. Click "+ Add URL" to add one.':
        'Переопределений для URL пока нет. Нажмите «+ Добавить URL», чтобы добавить.',
    "HTML sitemap slug (e.g., html-sitemap)":
        "Ярлык HTML-карты сайта (напр., html-sitemap)",
    "Select which post types to show in the HTML sitemap.":
        "Выберите типы записей для отображения в HTML-карте сайта.",
    "XML Sitemap": "XML-карта сайта",
    "XML Sitemap Index": "Индекс XML-карты сайта",
    "This is the XML sitemap index. Each link below points to a sitemap for a specific content type.":
        "Это индекс XML-карты сайта. Каждая ссылка ниже ведёт к карте сайта для определённого типа контента.",
    "Total sitemap files:": "Всего файлов карты сайта:",
    "Last Modified": "Последнее изменение",
    "Back to sitemap index": "Назад к индексу карты сайта",
    "This XML sitemap is intended for search engines such as Google, Bing, and Yandex.":
        "Эта XML-карта сайта предназначена для поисковых систем, таких как Google, Bing и Яндекс.",
    "URLs": "URL",
    "Images": "Изображения",
    "Page": "Страница",
    "No entries available to display in the sitemap.":
        "Нет записей для отображения в карте сайта.",

    # --- WooCommerce ---
    "SEO": "SEO",
    "Custom SEO title for this taxonomy. Variables: %term_title%, %sitename%, %sep%":
        "Пользовательский SEO-заголовок для этой таксономии. Переменные: %term_title%, %sitename%, %sep%",
    "Custom meta description for this taxonomy page.":
        "Пользовательское мета-описание для этой страницы таксономии.",
    "Open Graph Image": "Изображение Open Graph",
    "Custom social sharing image for this taxonomy page.":
        "Пользовательское изображение для социальных сетей для этой страницы таксономии.",
    "Custom SEO title. Variables: %term_title%, %sitename%, %sep%":
        "Пользовательский SEO-заголовок. Переменные: %term_title%, %sitename%, %sep%",
    "WooCommerce is not installed or activated. This module requires WooCommerce to function.":
        "WooCommerce не установлен или не активирован. Для работы этого модуля требуется WooCommerce.",
    "WooCommerce SEO settings saved.":
        "Настройки WooCommerce SEO сохранены.",
    "WooCommerce Overview": "Обзор WooCommerce",
    "Products": "Товары",
    "Categories": "Рубрики",
    "ON": "ВКЛ",
    "OFF": "ВЫКЛ",
    "Auto Schema": "Автоматическая Schema",
    "Product Schema (Structured Data)":
        "Schema товара (структурированные данные)",
    "Automatically generate Product schema markup from WooCommerce product data.":
        "Автоматически генерировать разметку Schema товара из данных товара WooCommerce.",
    "Auto-generate Product Schema":
        "Автоматическая генерация Schema товара",
    "Automatically create Product schema from WooCommerce data when saving a product":
        "Автоматически создавать Schema товара из данных WooCommerce при сохранении товара",
    "Include Price": "Включить цену",
    "Include product price and currency in schema":
        "Включить цену и валюту товара в Schema",
    "Include Reviews": "Включить отзывы",
    "Include average rating and review count in schema":
        "Включить средний рейтинг и количество отзывов в Schema",
    "Include Brand": "Включить бренд",
    "Include brand from product attribute":
        "Включить бренд из атрибута товара",
    "Brand Attribute": "Атрибут бренда",
    "Product attribute slug for brand (e.g., %1$s or %2$s)":
        "Ярлык атрибута товара для бренда (напр., %1$s или %2$s)",
    "Remove WC Default Schema": "Удалить Schema WooCommerce по умолчанию",
    "Remove WooCommerce's built-in structured data to prevent conflicts":
        "Удалить встроенные структурированные данные WooCommerce для предотвращения конфликтов",
    "Warning: Only enable this if you are using SEO Fury to generate all product schema.":
        "Внимание: включайте это только если вы используете SEO Fury для генерации всей Schema товаров.",
    "SEO Title Templates": "Шаблоны SEO-заголовков",
    "Default SEO title/description templates for products and taxonomies. These are used when individual products don't have custom SEO titles set.":
        "Шаблоны SEO-заголовков/описаний по умолчанию для товаров и таксономий. Используются, когда у отдельных товаров не заданы пользовательские SEO-заголовки.",
    "Product Title Template": "Шаблон заголовка товара",
    "Variables: %1$s, %2$s, %3$s, %4$s":
        "Переменные: %1$s, %2$s, %3$s, %4$s",
    "Product Description Template": "Шаблон описания товара",
    "Variables: %1$s, %2$s, %3$s": "Переменные: %1$s, %2$s, %3$s",
    "Product Category Title": "Заголовок рубрики товара",
    "Product Tag Title": "Заголовок метки товара",
    "Save WooCommerce Settings": "Сохранить настройки WooCommerce",
    "Manifest updated!": "Манифест обновлён!",

    # --- Additional strings found during parsing ---
    "AUTO": "АВТО",
    "MANUAL": "ВРУЧНУЮ",
    "N/A": "Н/Д",
    "// Paste your JSON-LD here": "// Вставьте ваш JSON-LD сюда",
    "JSON-LD is empty.": "JSON-LD пуст.",
    "+ Link": "+ Ссылка",
}


def unescape_po(s):
    """Unescape a PO-format string to get the actual string content."""
    result = []
    i = 0
    while i < len(s):
        if s[i] == '\\' and i + 1 < len(s):
            c = s[i + 1]
            if c == 'n':
                result.append('\n')
            elif c == 't':
                result.append('\t')
            elif c == '\\':
                result.append('\\')
            elif c == '"':
                result.append('"')
            else:
                result.append(s[i])
                result.append(c)
            i += 2
        else:
            result.append(s[i])
            i += 1
    return "".join(result)


def parse_pot_file(pot_path):
    """Parse a .pot file into a list of entries.
    Each entry is a dict with keys: comments, msgid, msgstr, flags, msgctxt.
    Multi-line msgid/msgstr are joined into a single string.
    """
    entries = []
    current_entry = {"comments": [], "msgid_lines": [], "msgstr_lines": [], "flags": [], "msgctxt_lines": []}
    current_field = None  # 'msgid', 'msgstr', 'msgctxt'
    is_header = True

    with open(pot_path, "r", encoding="utf-8") as f:
        lines = f.readlines()

    def save_entry():
        nonlocal current_entry
        # Join multi-line strings and unescape
        msgid = unescape_po("".join(current_entry["msgid_lines"]))
        msgstr = unescape_po("".join(current_entry["msgstr_lines"]))
        msgctxt = unescape_po("".join(current_entry["msgctxt_lines"]))
        entry = {
            "comments": current_entry["comments"],
            "flags": current_entry["flags"],
            "msgctxt": msgctxt,
            "msgid": msgid,
            "msgstr": msgstr,
        }
        entries.append(entry)
        current_entry = {"comments": [], "msgid_lines": [], "msgstr_lines": [], "flags": [], "msgctxt_lines": []}

    for line in lines:
        line = line.rstrip("\n")

        # Comments
        if line.startswith("#"):
            if current_entry["msgid_lines"]:
                # We have a pending entry; save it first
                save_entry()
            if line.startswith("#,"):
                current_entry["flags"].append(line)
            else:
                current_entry["comments"].append(line)
            current_field = None
            continue

        # Empty line: separator between entries
        if line.strip() == "":
            if current_entry["msgid_lines"] or current_entry["msgstr_lines"]:
                save_entry()
            current_field = None
            continue

        # msgctxt
        if line.startswith("msgctxt "):
            m = re.match(r'^msgctxt\s+"(.*)"$', line)
            if m:
                current_entry["msgctxt_lines"].append(m.group(1))
            current_field = "msgctxt"
            continue

        # msgid
        if line.startswith("msgid "):
            m = re.match(r'^msgid\s+"(.*)"$', line)
            if m:
                current_entry["msgid_lines"].append(m.group(1))
            current_field = "msgid"
            continue

        # msgstr
        if line.startswith("msgstr "):
            m = re.match(r'^msgstr\s+"(.*)"$', line)
            if m:
                current_entry["msgstr_lines"].append(m.group(1))
            current_field = "msgstr"
            continue

        # Continuation line (starts with ")
        if line.startswith('"'):
            m = re.match(r'^"(.*)"$', line)
            if m:
                text = m.group(1)
                if current_field == "msgid":
                    current_entry["msgid_lines"].append(text)
                elif current_field == "msgstr":
                    current_entry["msgstr_lines"].append(text)
                elif current_field == "msgctxt":
                    current_entry["msgctxt_lines"].append(text)
            continue

    # Save last entry
    if current_entry["msgid_lines"] or current_entry["msgstr_lines"]:
        save_entry()

    return entries


def escape_po_string(s):
    """Escape a string for .po format."""
    s = s.replace("\\", "\\\\")
    s = s.replace('"', '\\"')
    s = s.replace("\t", "\\t")
    return s


def format_po_string(s, prefix="msgstr"):
    """Format a string for .po output, handling multi-line strings."""
    if "\n" in s:
        # Multi-line: use empty first line + continuation lines
        parts = s.split("\n")
        lines = [f'{prefix} ""']
        for i, part in enumerate(parts):
            escaped = escape_po_string(part)
            if i < len(parts) - 1:
                lines.append(f'"{escaped}\\n"')
            else:
                if escaped:  # don't add empty trailing line
                    lines.append(f'"{escaped}"')
        return "\n".join(lines)
    else:
        return f'{prefix} "{escape_po_string(s)}"'


def write_po_file(entries, translations, output_path):
    """Write entries to a .po file with translations applied."""
    with open(output_path, "w", encoding="utf-8") as f:
        for i, entry in enumerate(entries):
            # Write comments
            for comment in entry["comments"]:
                f.write(comment + "\n")

            # Write flags
            for flag in entry["flags"]:
                f.write(flag + "\n")

            # Write msgctxt if present
            if entry["msgctxt"]:
                f.write(format_po_string(entry["msgctxt"], "msgctxt") + "\n")

            # Header entry (empty msgid)
            if entry["msgid"] == "":
                f.write('msgid ""\n')
                f.write('msgstr ""\n')
                # Write the Russian header
                header_lines = [
                    "Project-Id-Version: SEO Fury 0.1.5\\n",
                    "Report-Msgid-Bugs-To: https://wordpress.org/support/plugin/seo-fury\\n",
                    "Last-Translator: SEO Fury Team <support@seo-fury.com>\\n",
                    "Language-Team: Russian <ru@li.org>\\n",
                    "Language: ru\\n",
                    "Plural-Forms: nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<12 || n%100>14) ? 1 : 2);\\n",
                    "MIME-Version: 1.0\\n",
                    "Content-Type: text/plain; charset=UTF-8\\n",
                    "Content-Transfer-Encoding: 8bit\\n",
                    f"POT-Creation-Date: 2026-02-08T09:27:12+00:00\\n",
                    f"PO-Revision-Date: {datetime.now().strftime('%Y-%m-%d %H:%M')}+0000\\n",
                    "X-Generator: WP-CLI 2.12.0\\n",
                    "X-Domain: seo-fury\\n",
                ]
                for hl in header_lines:
                    f.write(f'"{hl}"\n')
                f.write("\n")
                continue

            # Write msgid
            msgid = entry["msgid"]
            if "\n" in msgid:
                f.write('msgid ""\n')
                parts = msgid.split("\n")
                for j, part in enumerate(parts):
                    escaped = escape_po_string(part)
                    if j < len(parts) - 1:
                        f.write(f'"{escaped}\\n"\n')
                    else:
                        if escaped:
                            f.write(f'"{escaped}"\n')
                        else:
                            # Empty trailing part after \n
                            pass
            else:
                f.write(f'msgid "{escape_po_string(msgid)}"\n')

            # Look up translation
            translation = translations.get(msgid, "")

            # Write msgstr
            if translation:
                if "\n" in translation:
                    f.write('msgstr ""\n')
                    parts = translation.split("\n")
                    for j, part in enumerate(parts):
                        escaped = escape_po_string(part)
                        if j < len(parts) - 1:
                            f.write(f'"{escaped}\\n"\n')
                        else:
                            if escaped:
                                f.write(f'"{escaped}"\n')
                else:
                    f.write(f'msgstr "{escape_po_string(translation)}"\n')
            else:
                f.write('msgstr ""\n')

            f.write("\n")


def main():
    print(f"Reading .pot file: {POT_FILE}")
    entries = parse_pot_file(POT_FILE)
    print(f"Total entries parsed: {len(entries)}")

    # Count non-header entries
    translatable = [e for e in entries if e["msgid"] != ""]
    print(f"Translatable strings: {len(translatable)}")

    # Count how many have translations
    translated_count = 0
    untranslated = []
    for e in translatable:
        if e["msgid"] in TRANSLATIONS:
            translated_count += 1
        else:
            untranslated.append(e["msgid"])

    print(f"Translations provided: {translated_count}")
    print(f"Missing translations: {len(untranslated)}")

    if untranslated:
        print("\n--- Missing translations ---")
        for u in untranslated:
            display = u[:80] + "..." if len(u) > 80 else u
            print(f'  "{display}"')
        print("---")

    print(f"\nWriting .po file: {PO_FILE}")
    write_po_file(entries, TRANSLATIONS, PO_FILE)
    print("Done!")

    # Verify output
    output_entries = parse_pot_file(PO_FILE)
    output_translatable = [e for e in output_entries if e["msgid"] != ""]
    output_translated = [e for e in output_translatable if e["msgstr"] != ""]
    print(f"\nVerification:")
    print(f"  Total entries in output: {len(output_entries)}")
    print(f"  Translatable entries: {len(output_translatable)}")
    print(f"  Translated entries: {len(output_translated)}")
    print(f"  Empty translations: {len(output_translatable) - len(output_translated)}")


if __name__ == "__main__":
    main()
