<?php
/**
 * Plugin Name: SEO Fury
 * Description: Complete SEO plugin with licensing, robots.txt, sitemaps, redirects, and IndexNow.
 * Version: 0.1.7
 * Author: SEO Fury Team
 * Text Domain: seo-fury
 * Domain Path: /languages
 * License: GPL v2 or later
 */

if (!defined('ABSPATH')) {
    exit;
}

define('SEO_FURY_VERSION', '0.1.7');
define('SEO_FURY_PATH', plugin_dir_path(__FILE__));
define('SEO_FURY_URL', plugin_dir_url(__FILE__));

define('MY_SEO_PLUGIN_VERSION', SEO_FURY_VERSION);
define('MY_SEO_PLUGIN_PATH', SEO_FURY_PATH);
define('MY_SEO_PLUGIN_URL', SEO_FURY_URL);

register_activation_hook(__FILE__, 'seo_fury_activate');

function seo_fury_activate() {
    require_once SEO_FURY_PATH . 'includes/class-core.php';

    SEO_Fury_Core::activate();
}

register_deactivation_hook(__FILE__, 'seo_fury_deactivate');

function seo_fury_deactivate() {
    flush_rewrite_rules();
}

require_once SEO_FURY_PATH . 'includes/class-core.php';

function seo_fury_init() {
    global $wpdb;

    $redirects_table = $wpdb->prefix . 'seo_redirects';
    $indexnow_table = $wpdb->prefix . 'seo_indexnow_log';

    SEO_Fury_Core::get_instance($redirects_table, $indexnow_table);
}
add_action('plugins_loaded', 'seo_fury_init');

add_action('init', function() {
    $plugin_lang = get_option('my_seo_plugin_language', '');

    unload_textdomain('seo-fury');

    if ($plugin_lang === 'en_US') {
        add_filter('gettext_seo-fury', function($translation, $text, $domain) {
            return $text;
        }, 10, 3);
        add_filter('gettext_with_context_seo-fury', function($translation, $text, $context, $domain) {
            return $text;
        }, 10, 4);
        add_filter('ngettext_seo-fury', function($translation, $single, $plural, $number, $domain) {
            return $number === 1 ? $single : $plural;
        }, 10, 5);
        return;
    }

    $locale = !empty($plugin_lang) ? $plugin_lang : determine_locale();
    $mo_file = SEO_FURY_PATH . 'languages/seo-fury-' . $locale . '.mo';
    if (file_exists($mo_file)) {
        load_textdomain('seo-fury', $mo_file);
    }
}, 1);

function seo_fury_is_white_label_enabled() {
    return (bool) get_option('my_seo_white_label_enabled', 0);
}

function seo_fury_get_brand_name() {
    $default = 'SEO Fury';
    if (!seo_fury_is_white_label_enabled()) {
        return $default;
    }
    $name = get_option('my_seo_white_label_name', $default);
    $name = is_string($name) ? trim($name) : $default;
    return $name !== '' ? $name : $default;
}

function seo_fury_hide_branding() {
    return seo_fury_is_white_label_enabled() && get_option('my_seo_white_label_hide_links', 0);
}
